<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!-- 
$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/util/domino/document-xml-to-html.xsl 1     23.06.03 15:17 Kbg $
Copyright (C) 2002 GoPro Development.  All rights reserved
-->
	<xsl:output method="html"/>
	<xsl:template match="/">
		<html>
		<head>
		<title>
		<xsl:value-of select="//info/subject" />
		</title>
		<xsl:comment>$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/util/domino/document-xml-to-html.xsl 1     23.06.03 15:17 Kbg $</xsl:comment>
		</head>
		<body>
		<xsl:apply-templates />
		</body>
		</html>
	</xsl:template>
	
	<xsl:template match="document">
		<h1>
		<xsl:value-of select="//info/subject" />
		</h1>
		<small>
		<a href="../index.html">Back to index</a>
		<xsl:text>.::.</xsl:text>
		<a>
			<xsl:attribute name="href">
			<xsl:text>../index.html#</xsl:text>
			<xsl:value-of select="//info/xmlbasename"/>
			</xsl:attribute>
			Back to tree in index
		</a>
		</small>
		<hr/>
		<xsl:apply-templates select="info" />
		<xsl:apply-templates select="items" />
		<xsl:apply-templates select="parent" />
		<xsl:apply-templates select="responses" />
		<xsl:apply-templates select="attachments" />
		<h2>XML</h2>
		<ul><li>
			<a>
			<xsl:attribute name="href">
			<xsl:text>../xml/</xsl:text>
			<xsl:value-of select="///info/xmlbasename" />
			<xsl:text>.xml</xsl:text>
			</xsl:attribute>
			<xsl:text>This document as XML</xsl:text>
			</a>
		</li></ul>
	</xsl:template>		 

	<xsl:template match="info">
		<h2>Info</h2>
		<ul>
    	<xsl:for-each select = "*" > 
			<li>
        	<strong><xsl:value-of select = "name()" /> </strong>
			<xsl:text> </xsl:text>
            <xsl:value-of select = "." /> 
			</li>
		</xsl:for-each>
		</ul>
	</xsl:template>		 

	<xsl:template match="parent">
		<h2>Parent</h2>
		<ul>
		<li>
			<a>
			<xsl:attribute name="href">
			<xsl:text>./</xsl:text>
			<xsl:value-of select="xmlbasename" />
			<xsl:text>.html</xsl:text>
			</xsl:attribute>
			<xsl:value-of select="subject" />
			</a>
		</li>
		</ul>
 	</xsl:template>		 

	<xsl:template match="items">
		<h2>Items</h2>
		<ul>
    		<xsl:for-each select = "*" > 
				<li>
        		<strong>
        		<xsl:value-of select = "@name" />
				<xsl:text>(</xsl:text>
        		<xsl:value-of select = "@type" />
				<xsl:text>)  </xsl:text>
				</strong>
        	    <xsl:value-of select = "." /> 
				</li>
			</xsl:for-each>
		</ul>
 	</xsl:template>		 

	<xsl:template match="attachments">
		<h2>Attachments</h2>
		<ul>
		<xsl:apply-templates />
		</ul>
	</xsl:template>

	<xsl:template match="file">
		<li>
		<a>
		<xsl:attribute name="href">
			<xsl:text>../attachments/</xsl:text>
			<xsl:value-of select="//info/xmlbasename" />	
			<xsl:text>.</xsl:text>
			<xsl:value-of select="." />
		</xsl:attribute>
		<xsl:value-of select="." />
		</a>
		</li>
	</xsl:template>		 

	<xsl:template match="responses">
		<h2>Responses</h2>
		<ul>
			<xsl:apply-templates />
		</ul>
	</xsl:template>		 

	<xsl:template match="children">
		<ul>
			<xsl:apply-templates />
		</ul>
	</xsl:template>		 

	<xsl:template match="child">
		<li>
			<a>
			<xsl:attribute name="href">
			<xsl:text>./</xsl:text>
			<xsl:value-of select="@xmlbasename" />
			<xsl:text>.html</xsl:text>
			</xsl:attribute>
			<xsl:value-of select="@subject" />
			</a>
			<xsl:apply-templates/>
		</li>
	</xsl:template>		 
</xsl:stylesheet>
