<?xml version="1.0" encoding ="ISO-8859-1"?>
<!--

 XSL Stylesheet to convert from GDF to notes
 
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.lotus.com/dxl">
  <xsl:output method="xml" encoding="ISO-8859-1" indent="no" omit-xml-declaration="no"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="gdf">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="document">
    <document version="6.0">
      <xsl:apply-templates select="item"/>
      <xsl:apply-templates select="item/html//a" mode="attachment"/>
    </document>
  </xsl:template>

  <xsl:template match="item">
    <xsl:if test="not(.//xdatetime)">
      <item name="{@name}">
        <xsl:apply-templates/>
      </item>
    </xsl:if>
  </xsl:template>

  <xsl:template match="textlist">
    <textlist>
      <xsl:apply-templates/>
    </textlist>
  </xsl:template>

  <xsl:template match="text">
    <text>
      <xsl:apply-templates/>
    </text>
  </xsl:template>

  <xsl:template match="numberlist">
    <numberlist>
      <xsl:apply-templates/>
    </numberlist>
  </xsl:template>

  <xsl:template match="number">
    <number>
      <xsl:apply-templates/>
    </number>
  </xsl:template>

  <xsl:template match="datetimelist">
    <datetimelist>
      <xsl:apply-templates/>
    </datetimelist>
  </xsl:template>

  <xsl:template match="datetime">
    <datetime>
      <xsl:apply-templates/>
    </datetime>
  </xsl:template>

  <xsl:template match="img">
    <xsl:if test="starts-with(@src,'cid:')">
      <xsl:variable name="cid" select="substring(@src,5)"/>
      <xsl:variable name="attachment" select="//attachment[@cid=$cid]"/>
      <xsl:variable name="type" select="substring-after($attachment/@mime,'/')"/>
      <picture width="{@width}px" height="{@height}px">
        <xsl:element name="{$type}">
          <xsl:value-of select="$attachment/text()"/>
        </xsl:element>
      </picture>
    </xsl:if>
  </xsl:template>

  <xsl:template match="ol">
    <xsl:variable name="id" select="generate-id()"/>
    <xsl:apply-templates>
      <xsl:with-param name="id" select="$id"/>
      <xsl:with-param name="list">number</xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="ul">
    <xsl:variable name="id" select="generate-id()"/>
    <xsl:apply-templates>
      <xsl:with-param name="id" select="$id"/>
      <xsl:with-param name="list">bullet</xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="li">
    <xsl:param name="id" select="generate-id()"/>
    <xsl:param name="list"/>
    <xsl:apply-templates>
      <xsl:with-param name="id" select="$id"/>
      <xsl:with-param name="list" select="$list"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="html">
    <richtext>
      <xsl:apply-templates/>
    </richtext>
  </xsl:template>

  <xsl:template match="p">
    <xsl:param name="id" select="generate-id()"/>
    <xsl:param name="list"/>
    <pardef id="{$id}">
      <xsl:if test="$list!=''">
        <xsl:attribute name="list">
          <xsl:value-of select="$list"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@align">
        <xsl:attribute name="align">
          <xsl:value-of select="@align"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="contains(@style,'margin-left:')">
        <xsl:attribute name="leftmargin">
          <xsl:call-template name="style">
            <xsl:with-param name="n" select="'margin-left'"/>
            <xsl:with-param name="s" select="@style"/>
          </xsl:call-template>
        </xsl:attribute>
      </xsl:if>
    </pardef>
    <par def="{$id}">
      <xsl:apply-templates/>
    </par>
  </xsl:template>

  <xsl:template match="br">
    <break/>
  </xsl:template>

<!-- **** Tables **** -->
  <xsl:template match="table">
    <table>
      <xsl:apply-templates/>
    </table>
  </xsl:template>

  <xsl:template match="tr">
    <tablerow>
      <xsl:apply-templates/>
    </tablerow>
  </xsl:template>

  <xsl:template match="td">
    <tablecell>
      <xsl:apply-templates/>
    </tablecell>
  </xsl:template>

  <xsl:template match="span">
    <run>
      <xsl:apply-templates select="." mode="css-to-style"/>
      <xsl:apply-templates select="." mode="css-to-font"/>
      <xsl:apply-templates/>
    </run>
  </xsl:template>

<!-- **** Links **** -->
  <xsl:template match="a">
    <xsl:choose>
      <xsl:when test="starts-with(@href,'cid:')">
        <xsl:variable name="cid" select="substring-after(@href,'cid:')"/>
        <xsl:variable name="attachment" select="//document/attachment[@cid=$cid]"/>
        <xsl:apply-templates/>
        <attachmentref name="{$attachment/@filename}" displayname="{$attachment/@filename}"/>
      </xsl:when>
      <xsl:otherwise>
        <urllink href="{@href}">
          <xsl:apply-templates/>
        </urllink>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="style">
    <xsl:param name="n"/>
    <xsl:param name="s"/>
    <xsl:value-of select="substring-before(substring-after($s,concat($n,': ')),';')"/>
  </xsl:template>

  <xsl:template match="a" mode="attachment">
    <xsl:if test="starts-with(@href,'cid:')">
      <xsl:variable name="cid" select="substring-after(@href,'cid:')"/>
      <xsl:variable name="attachment" select="//document/attachment[@cid=$cid]"/>
      <item name="$FILE">
        <object>
          <file hosttype="msdos" name="{$attachment/@filename}">
            <xsl:choose>
              <xsl:when test="$attachment/@modified">
                <created>
                  <datetime>
                    <xsl:value-of select="$attachment/@modified"/>
                  </datetime>
                </created>
                <modified>
                  <datetime>
                    <xsl:value-of select="$attachment/@modified"/>
                  </datetime>
                </modified>
              </xsl:when>
              <xsl:otherwise>
                <created>
                  <datetime>19700101</datetime>
                </created>
                <modified>
                  <datetime>19700101</datetime>
                </modified>
              </xsl:otherwise>
            </xsl:choose>
            <filedata>
              <xsl:value-of select="$attachment"/>
            </filedata>
          </file>
        </object>
      </item>
    </xsl:if>
  </xsl:template>

<!-- **** Fonts **** -->
  <xsl:template match="span" mode="css-to-font">
    <font>
      <xsl:variable name="style">
        <xsl:if test="contains(@style,'font-weight: bold;')">bold</xsl:if>
        <xsl:if test="contains(@style,'font-style: italic;')">italic</xsl:if>
        <xsl:if test="contains(@style,'text-decoration: underline;')">underline</xsl:if>
        <xsl:if test="contains(@style,'text-decoration: line-through;')">strikethrough</xsl:if>
      </xsl:variable>

      <xsl:if test="not($style='')">
        <xsl:attribute name="style">
          <xsl:value-of select="$style"/>
        </xsl:attribute>
      </xsl:if>

      <xsl:if test="contains(@style,'color: ')">
        <xsl:attribute name="color">
          <xsl:call-template name="style">
            <xsl:with-param name="n" select="'color'"/>
            <xsl:with-param name="s" select="@style"/>
          </xsl:call-template>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="contains(@style,'font-size: ')">
        <xsl:attribute name="size">
          <xsl:call-template name="style">
            <xsl:with-param name="n">font-size</xsl:with-param>
            <xsl:with-param name="s" select="@style"/>
          </xsl:call-template>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="contains(@style,'font-family: ')">
        <xsl:attribute name="name">
          <xsl:call-template name="style">
            <xsl:with-param name="n">font-family</xsl:with-param>
            <xsl:with-param name="s" select="@style"/>
          </xsl:call-template>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="contains(@style,'font-family: ')">
        <xsl:attribute name="name">
          <xsl:call-template name="style">
            <xsl:with-param name="n">font-family</xsl:with-param>
            <xsl:with-param name="s" select="@style"/>
          </xsl:call-template>
        </xsl:attribute>
      </xsl:if>
    </font>
  </xsl:template>

  <xsl:template match="span" mode="css-to-style">
    <xsl:variable name="bcolor">
      <xsl:call-template name="style">
        <xsl:with-param name="n">background-color</xsl:with-param>
        <xsl:with-param name="s" select="@style"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="highlight">
      <xsl:if test="not($bcolor='')">
        <xsl:choose>
          <xsl:when test="$bcolor='#FFFFC0'">yellow</xsl:when>
          <xsl:when test="$bcolor='#FFCFCF'">pink</xsl:when>
          <xsl:when test="$bcolor='#FFFFC0'">blue</xsl:when>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>

    <xsl:if test="not($highlight='')">
      <xsl:attribute name="highlight">
        <xsl:value-of select="highlight"/>
      </xsl:attribute>
    </xsl:if>

  </xsl:template>

<!-- Default Match for everyting else -->
  <xsl:template match="@* | node()">
    <xsl:copy>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>

