<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
 XSL Stylesheet to convert from GDF to XSL:FO
 
 Most of the code is based on:
 "HTML to Formatting Objects (FO) conversion guide"
 at http://www-106.ibm.com/developerworks/library/x-xslfo2app 
-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" encoding="ISO-8859-1" indent="yes" omit-xml-declaration="no"/>

	<!-- Start customization -->
  <!-- Default attributes for normal text -->
	<xsl:attribute-set name="normal">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
	</xsl:attribute-set>
	
  <!-- Default Attributes for body -->
	<xsl:attribute-set name="body">
		<xsl:attribute name="font-size">11pt</xsl:attribute>
	</xsl:attribute-set>         

	<!-- Default attributes for title -->
	<xsl:attribute-set name="title">
		<xsl:attribute name="font-size">16pt</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>  
  <!-- End customization -->
	
	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="simple" page-height="29.7cm" page-width="21cm" margin-top="1cm" margin-bottom="2cm" margin-left="2.5cm" margin-right="2.5cm">
					<fo:region-body margin-top="3cm" margin-bottom="1.5cm"/>
					<fo:region-before extent="2cm"/>
					<fo:region-after extent="1.8cm"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<xsl:apply-templates/>
		</fo:root>
	</xsl:template>
	
	<xsl:template match="gdf">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="document">
		<xsl:variable name="form" select="item[@name='form']/text"/>    
		<fo:page-sequence master-reference="simple">
      
    <!-- Select the form type -->
		<xsl:choose>				
		<xsl:when test="$form='MainDoc'"> 
    <!-- Start Case document -->    
    <!-- Header -->
    <fo:static-content flow-name="xsl-region-before">
      <fo:block text-align="end">           
      <fo:external-graphic src="_hugvit_header.gif" width="133px" height="49px"/>
      </fo:block>
    </fo:static-content>

    <!-- Footer -->
    <fo:static-content flow-name="xsl-region-after">
      <fo:block text-align="center">
        <fo:external-graphic src="_hugvit_footer.gif" width="413px" height="45px"/>
      </fo:block>
    </fo:static-content>              
            
  	<!-- Pages -->
    <fo:flow flow-name="xsl-region-body">       
      <!-- hr -->
      <fo:block><fo:leader leader-pattern="rule" leader-length="16cm"/></fo:block>
        
      <!-- Fields -->
      <fo:list-block provisional-distance-between-starts="1cm" provisional-label-separation="0.5cm">		
 		  <xsl:apply-templates select="item[@name='name']">
		    <xsl:with-param name="name">Nafn tengilis</xsl:with-param>
		  </xsl:apply-templates>
		  <xsl:apply-templates select="item[@name='companyname']">
		    <xsl:with-param name="name">Nafn fyrirtkis</xsl:with-param>
		  </xsl:apply-templates>				
		  <xsl:apply-templates select="item[@name='casenumber']">
		    <xsl:with-param name="name">Mlsnmer</xsl:with-param>
		  </xsl:apply-templates>
		  <xsl:apply-templates select="item[@name='personresponsible']">
		    <xsl:with-param name="name">byrgarmaur mls</xsl:with-param>
		  </xsl:apply-templates>				        
		  <xsl:apply-templates select="item[@name='status']">
		    <xsl:with-param name="name">Staa</xsl:with-param>
		  </xsl:apply-templates>				      
  		<xsl:apply-templates select="item[@name='date']">
			  <xsl:with-param name="name">Dagsetning</xsl:with-param>
			</xsl:apply-templates>
      </fo:list-block>
   
      <!-- hr -->
      <fo:block><fo:leader leader-pattern="rule" leader-length="16cm"/></fo:block>
        
      <!-- Subject -->
      <fo:block></fo:block>
			<fo:block xsl:use-attribute-sets="title">
			  <xsl:value-of select="item[@name='subject']"/>
      </fo:block>
      <fo:block></fo:block>
				       
      <!-- html body -->
			<fo:block xsl:use-attribute-sets="body">       
       <xsl:apply-templates select="item[@name='body']/html"/>
			</fo:block>
		</fo:flow>
    <!-- End Case document -->
    </xsl:when>
    
    <!-- Start customization for your form -->
    <xsl:when test="$form='my_custom_form_name'">
    
    <!-- Header -->
    <fo:static-content flow-name="xsl-region-before">
      <fo:block text-align="end">           
      <fo:external-graphic src="_hugvit_header.gif" width="133px" height="49px"/>
      </fo:block>
    </fo:static-content>

    <!-- Footer -->
    <fo:static-content flow-name="xsl-region-after">
      <fo:block text-align="center">
        <fo:external-graphic src="_hugvit_footer.gif" width="413px" height="45px"/>
      </fo:block>
    </fo:static-content>              
            
  	<!-- Pages -->
    <fo:flow flow-name="xsl-region-body">       
      <!-- hr -->
      <fo:block><fo:leader leader-pattern="rule" leader-length="16cm"/></fo:block>
        
      <!-- Fields -->
      <fo:list-block provisional-distance-between-starts="1cm" provisional-label-separation="0.5cm">		
 		  <xsl:apply-templates select="item[@name='my_field']">
		    <xsl:with-param name="name">My field title</xsl:with-param>
		  </xsl:apply-templates>
      </fo:list-block>
   
      <!-- hr -->
      <fo:block><fo:leader leader-pattern="rule" leader-length="16cm"/></fo:block>
        
      <!-- Subject -->
      <fo:block></fo:block>
			<fo:block xsl:use-attribute-sets="title">
			  <xsl:value-of select="item[@name='subject']"/>
      </fo:block>
      <fo:block></fo:block>
				       
      <!-- html body -->
			<fo:block xsl:use-attribute-sets="body">       
       <xsl:apply-templates select="item[@name='body']/html"/>
			</fo:block>
		</fo:flow>
    
    </xsl:when>
    <!-- End customization -->

    <!-- Default for all other forms -->
    <xsl:otherwise>
    <!-- Header -->
    <fo:static-content flow-name="xsl-region-before">
      <fo:block text-align="end">           
      <fo:external-graphic src="_hugvit_header.gif" width="133px" height="49px"/>
      </fo:block>
    </fo:static-content>

    <!-- Footer -->
    <fo:static-content flow-name="xsl-region-after">
      <fo:block text-align="center">
        <fo:external-graphic src="_hugvit_footer.gif" width="413px" height="45px"/>
      </fo:block>
    </fo:static-content>              
            
  	<!-- Pages -->
    <fo:flow flow-name="xsl-region-body">       
      <!-- hr -->
      <fo:block><fo:leader leader-pattern="rule" leader-length="16cm"/></fo:block>
        
      <!-- Fields -->
      <fo:list-block provisional-distance-between-starts="1cm" provisional-label-separation="0.5cm">		
  		<xsl:apply-templates select="item[@name='date']">
			  <xsl:with-param name="name">Dagsetning</xsl:with-param>
			</xsl:apply-templates>
      </fo:list-block>
   
      <!-- hr -->
      <fo:block><fo:leader leader-pattern="rule" leader-length="16cm"/></fo:block>
        
      <!-- Subject -->
      <fo:block></fo:block>
			<fo:block xsl:use-attribute-sets="title">
			  <xsl:value-of select="item[@name='subject']"/>
      </fo:block>
      <fo:block></fo:block>
				       
      <!-- html body -->
			<fo:block xsl:use-attribute-sets="body">       
       <xsl:apply-templates select="item[@name='body']/html"/>
			</fo:block>
		</fo:flow>
    </xsl:otherwise>    
    
    </xsl:choose>      
		</fo:page-sequence>
	</xsl:template>
		
	<xsl:template match="item">
	<xsl:param name="name" select="@name"/>
   <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block>&#x2022;</fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block>
          <xsl:value-of select="$name"/><xsl:text>: </xsl:text><xsl:apply-templates/>
        </fo:block>
      </fo:list-item-body>
   </fo:list-item>    
	</xsl:template>
	
	<xsl:template match="textlist | numberlist | datetimelist">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="text | number | datetime">
		<xsl:value-of select="."/>
	</xsl:template>
	
	<xsl:template match="html">
		<xsl:apply-templates/>
	</xsl:template>
		
	<xsl:template match="p">
	  <fo:block xsl:use-attribute-sets="normal">
		<xsl:call-template name="style-to-fo">
		  <xsl:with-param name="s" select="@style"/>
		</xsl:call-template>
		<xsl:apply-templates/>
		</fo:block>
	</xsl:template>

	<xsl:template match="span">
    <xsl:choose>
    <xsl:when test="false()">
	  <fo:block/>
    </xsl:when>
    <xsl:otherwise>
	  <fo:inline>
		<xsl:call-template name="style-to-fo">
		  <xsl:with-param name="s" select="@style"/>
		</xsl:call-template>
		<xsl:apply-templates/>
		</fo:inline>
    </xsl:otherwise>
    </xsl:choose>
	</xsl:template>
	
  <!-- ============================================
    Tables are a hassle.  The main problem we have
    is converting the cols attribute into some 
    number of <fo:table-column> elements.  We do 
    this with a named template called build-columns.
    Once we've processed the cols attribute, we 
    invoke all of the templates for the children 
    of this element. 
    =============================================== -->
  <xsl:template match="table">
    <fo:table table-layout="fixed">
      <xsl:choose>
        <xsl:when test="@cols">
         <xsl:call-template name="build-columns">
           <xsl:with-param name="cols" 
             select="concat(@cols, ' ')"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="count" select="count(tr[1]/td)"/>
				  <xsl:for-each select="tr[1]/td">
					<fo:table-column column-width="{400 div $count}pt"/>
					</xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
      <fo:table-body>
        <xsl:apply-templates/>
      </fo:table-body>
    </fo:table>
  </xsl:template>

  <!-- ============================================
    For a table cell, we put everything inside a
    <fo:table-cell> element.  We set the padding
    property correctly, then we set the border 
    style.  For the border style, we look to see if
    any of the ancestor elements we care about 
    specified a solid border.  Next, we check for the 
    rowspan, colspan, and align attributes.  Notice 
    that for align, we check this element, then go
    up the ancestor chain until we find the <table>
    element or we find something that specifies the 
    alignment. 
    =============================================== -->
  <xsl:template match="td">
    <fo:table-cell 
      padding-start="3pt" padding-end="3pt"
      padding-before="3pt" padding-after="3pt">
      <xsl:if test="@colspan">
        <xsl:attribute name="number-columns-spanned">
          <xsl:value-of select="@colspan"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@rowspan">
        <xsl:attribute name="number-rows-spanned">
          <xsl:value-of select="@rowspan"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@border='1' or 
                    ancestor::tr[@border='1'] or
                    ancestor::thead[@border='1'] or
                    ancestor::table[@border='1']">
        <xsl:attribute name="border-style">
          <xsl:text>solid</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="border-color">
          <xsl:text>black</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="border-width">
          <xsl:text>1pt</xsl:text>
        </xsl:attribute>
      </xsl:if>
      <xsl:variable name="align">
        <xsl:choose>
          <xsl:when test="@align">
            <xsl:choose>
              <xsl:when test="@align='center'">
                <xsl:text>center</xsl:text>
              </xsl:when>
              <xsl:when test="@align='right'">
                <xsl:text>end</xsl:text>
              </xsl:when>
              <xsl:when test="@align='justify'">
                <xsl:text>justify</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>start</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="ancestor::tr[@align]">
            <xsl:choose>
              <xsl:when test="ancestor::tr/@align='center'">
                <xsl:text>center</xsl:text>
              </xsl:when>
              <xsl:when test="ancestor::tr/@align='right'">
                <xsl:text>end</xsl:text>
              </xsl:when>
              <xsl:when test="ancestor::tr/@align='justify'">
                <xsl:text>justify</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>start</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="ancestor::thead">
            <xsl:text>center</xsl:text>
          </xsl:when>
          <xsl:when test="ancestor::table[@align]">
            <xsl:choose>
              <xsl:when test="ancestor::table/@align='center'">
                <xsl:text>center</xsl:text>
              </xsl:when>
              <xsl:when test="ancestor::table/@align='right'">
                <xsl:text>end</xsl:text>
              </xsl:when>
              <xsl:when test="ancestor::table/@align='justify'">
                <xsl:text>justify</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>start</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>start</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <fo:block text-align="{$align}">
        <xsl:apply-templates/>
      </fo:block>
    </fo:table-cell>
  </xsl:template>

  <!-- ============================================
    The rarely-used <tfoot> element contains some
    number of <tr> elements; we just invoke the 
    template for <tr> here. 
    =============================================== -->
  <xsl:template match="tfoot">
    <xsl:apply-templates select="tr"/>
  </xsl:template>

  <!-- ============================================
    If there's a <th> element, we process it just 
    like a normal <td>, except the font-weight is 
    always bold and the text-align is always center. 
    =============================================== -->
  <xsl:template match="th">
    <fo:table-cell
      padding-start="3pt" padding-end="3pt"
      padding-before="3pt" padding-after="3pt">
      <xsl:if test="@border='1' or 
                    ancestor::tr[@border='1'] or
                    ancestor::table[@border='1']">
        <xsl:attribute name="border-style">
          <xsl:text>solid</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="border-color">
          <xsl:text>black</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="border-width">
          <xsl:text>1pt</xsl:text>
        </xsl:attribute>
      </xsl:if>
      <fo:block font-weight="bold" text-align="center">
        <xsl:apply-templates/>
      </fo:block>
    </fo:table-cell>
  </xsl:template>

  <!-- ============================================
    Just like <tfoot>, the rarely-used <thead> element
    contains some number of table rows.  We just 
    invoke the template for <tr> here. 
    =============================================== -->
  <xsl:template match="thead">
    <xsl:apply-templates select="tr"/>
  </xsl:template>

  <!-- ============================================
    For an HTML table row, we create an XSL-FO table
    row, then invoke the templates for everything 
    inside it. 
    =============================================== -->
  <xsl:template match="tr">
    <fo:table-row>
      <xsl:apply-templates/>
    </fo:table-row>
  </xsl:template>
	
  <!-- ============================================
    We handle a break element by inserting an 
    empty <fo:block>.
    =============================================== -->
  <xsl:template match="br">
    <fo:block></fo:block>    
  </xsl:template>
  
  
  <xsl:template match="hr">
    <fo:block>
      <fo:leader leader-pattern="rule"/>
    </fo:block>
  </xsl:template>  
		
  <!-- ============================================
    Processing for the anchor tag is complex.  First
    of all, if this is a named anchor, we write an empty
    <fo:block> with the appropriate id.  (In the special
    case that the next element is an <h1>, we ignore
    the element altogether and put the id on the <h1>.)
    Next, if this is a regular anchor and the href
    starts with a hash mark (#), we create a link with
    an internal-destination.  Otherwise, we create a
    link with an external destination. 
    =============================================== -->
  <xsl:template match="a">
    <xsl:choose>
      <xsl:when test="@name">
        <xsl:if test="not(name(following-sibling::*[1]) = 'h1')">
          <fo:block line-height="0pt" space-after="0pt" 
            font-size="0pt" id="{@name}"/>
        </xsl:if>
      </xsl:when>
      <xsl:when test="@href">
          <xsl:choose>
            <xsl:when test="starts-with(@href, '#')">
						  <fo:basic-link color="blue">
              <xsl:attribute name="internal-destination">
                <xsl:value-of select="substring(@href, 2)"/>
              </xsl:attribute>
              <xsl:apply-templates/>
							</fo:basic-link>
            </xsl:when>
            <xsl:when test="starts-with(@href, 'cid:')">
						  <!-- Ignore cid attachments -->
            </xsl:when>						
            <xsl:otherwise>
						  <fo:basic-link color="blue">
              <xsl:attribute name="external-destination">
                <xsl:value-of select="@href"/>
              </xsl:attribute>
              <xsl:apply-templates/>
							</fo:basic-link>
            </xsl:otherwise>
          </xsl:choose>
        <xsl:if test="starts-with(@href, '#')">
          <xsl:text> on page </xsl:text>
          <fo:page-number-citation ref-id="{substring(@href, 2)}"/>
        </xsl:if>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
		
  <!-- ============================================
    The unordered list is pretty straightforward; 
    the only complication is calculating the space-
    after and start-indent properties.  If this 
    list is inside another list, we don't put any 
    space after this one, and we calculate the 
    indentation based on the nesting level of this 
    list. 
    =============================================== -->
  <xsl:template match="ul">
    <fo:list-block provisional-distance-between-starts="1cm"
      provisional-label-separation="0.5cm">
      <xsl:attribute name="space-after">
        <xsl:choose>
          <xsl:when test="ancestor::ul or ancestor::ol">
            <xsl:text>0pt</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>12pt</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:attribute name="start-indent">
        <xsl:variable name="ancestors">
          <xsl:choose>
            <xsl:when test="count(ancestor::ol) or count(ancestor::ul)">
              <xsl:value-of select="1 + 
                                    (count(ancestor::ol) + 
                                     count(ancestor::ul)) * 
                                    1.25"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>1</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="concat($ancestors, 'cm')"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </fo:list-block>
  </xsl:template>

  <!-- ============================================
    List items inside unordered lists are easy; we
    just have to use the correct Unicode character
    for the bullet.  
    =============================================== -->
  <xsl:template match="ul/li">
    <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block>&#x2022;</fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block>
          <xsl:apply-templates/>
        </fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template>
	
	
  <!-- ============================================
    We handle an ordered list with two complications:
    If the list appears inside another list (either 
    an <ol> or <ul>), we don't put any vertical space
    after it.  The other issue is that we indent the
    list according to how deeply nested the list is. 
    =============================================== -->

  <xsl:template match="ol">
    <fo:list-block provisional-distance-between-starts="1cm"
      provisional-label-separation="0.5cm">
      <xsl:attribute name="space-after">
        <xsl:choose>
          <xsl:when test="ancestor::ul or ancestor::ol">
            <xsl:text>0pt</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>12pt</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:attribute name="start-indent">
        <xsl:variable name="ancestors">
          <xsl:choose>
            <xsl:when test="count(ancestor::ol) or count(ancestor::ul)">
              <xsl:value-of select="1 + 
                                    (count(ancestor::ol) + 
                                     count(ancestor::ul)) * 
                                    1.25"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>1</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="concat($ancestors, 'cm')"/>
      </xsl:attribute>
      <xsl:apply-templates select="*"/>
    </fo:list-block>
  </xsl:template>

  <!-- ============================================
    When we handle items in an ordered list, we need
    to check if the list has a start attribute.  If
    it does, we change the starting number accordingly.
    Once we've figured out where to start counting,
    we check the type attribute to see what format
    the numbers should use.  
    =============================================== -->

  <xsl:template match="ol/li">
    <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block>
          <xsl:variable name="value-attr">
            <xsl:choose>
              <xsl:when test="../@start">
                <xsl:number value="position() + ../@start - 1"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:number value="position()"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:choose>
            <xsl:when test="../@type='i'">
              <xsl:number value="$value-attr" format="i. "/>
            </xsl:when>
            <xsl:when test="../@type='I'">
              <xsl:number value="$value-attr" format="I. "/>
            </xsl:when>
            <xsl:when test="../@type='a'">
              <xsl:number value="$value-attr" format="a. "/>
            </xsl:when>
            <xsl:when test="../@type='A'">
              <xsl:number value="$value-attr" format="A. "/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:number value="$value-attr" format="1. "/>
            </xsl:otherwise>
          </xsl:choose>
        </fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block>
          <xsl:apply-templates select="*|text()"/>
        </fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template>
	
	
  <!-- ============================================
    For the <img> element, we use the src attribute
    as it comes from HTML.  We also check for any 
    width and height attributes.  If those attributes
    are there, we try to use them; height="300px" is
    used as-is, while height="300" is converted to 
    the value "300px".
    =============================================== -->
  <xsl:template match="img">
    <fo:block space-after="12pt">
      <fo:external-graphic src="{@src}">
        <xsl:if test="@width">
          <xsl:attribute name="width">
            <xsl:choose>
              <xsl:when test="contains(@width, 'px')">
                <xsl:value-of select="@width"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat(@width, 'px')"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
        </xsl:if>
        <xsl:if test="@height">
          <xsl:attribute name="height">
            <xsl:choose>
              <xsl:when test="contains(@height, 'px')">
                <xsl:value-of select="@height"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat(@height, 'px')"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
        </xsl:if>
      </fo:external-graphic>
    </fo:block>
  </xsl:template>

  <!-- ============================================
    This template generates an <fo:table-column>
    element for each token in the cols attribute of
    the HTML <table> tag.  The template processes
    the first token, then invokes itself with the 
    rest of the string. 
    =============================================== -->
  <xsl:template name="build-columns">
    <xsl:param name="cols"/>

    <xsl:if test="string-length(normalize-space($cols))">
      <xsl:variable name="next-col">
        <xsl:value-of select="substring-before($cols, ' ')"/>
      </xsl:variable>
      <xsl:variable name="remaining-cols">
        <xsl:value-of select="substring-after($cols, ' ')"/>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="contains($next-col, 'pt')">
          <fo:table-column column-width="{$next-col}"/>
        </xsl:when>
        <xsl:when test="number($next-col) &gt; 0">
          <fo:table-column column-width="{concat($next-col, 'pt')}"/>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-column column-width="50pt"/>
        </xsl:otherwise>
      </xsl:choose>

      <xsl:call-template name="build-columns">
        <xsl:with-param name="cols" select="concat($remaining-cols, ' ')"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
	
	<!-- Converts style attribute on p tag to attributes for a fo:block or fo:inline -->
	<xsl:template name="style-to-fo">
	  <xsl:param name="s"/>
		<xsl:variable name="t">
		  <xsl:choose>
			  <xsl:when test="contains($s,';')">
				 <xsl:value-of select="normalize-space(substring-before($s,';'))"/>
				</xsl:when>
				<xsl:otherwise>
				 <xsl:value-of select="normalize-space($s)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
	  <xsl:if test="$t!=''">
		  <xsl:variable name="n" select="normalize-space(substring-before($t,':'))"/>
			<xsl:variable name="v" select="normalize-space(substring-after($t,':'))"/>
			<xsl:attribute name="{$n}"><xsl:value-of select="$v"/></xsl:attribute>
	    <xsl:call-template name="style-to-fo">
		    <xsl:with-param name="s" select="substring-after($s,';')"/>
		  </xsl:call-template>		
		</xsl:if>
	</xsl:template>	
			
</xsl:stylesheet>

