/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.domino;

import java.util.Calendar;
import lotus.domino.DateTime;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.Session;
import net.gopro.util.SerialNumberException;
import net.gopro.util.SerialNumberFormat;

public class SerialNumber {
    static final String ssid = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/util/domino/SerialNumber.java 1     23.06.03 15:17 Kbg $";
    final int DEBUG = 0;
    final int MAX_ROMAN_LEN = 64;
    final int MAX_ROMAN_VALUE = 40000;
    final int MAX_FMTNUM_LEN = 1024;
    final int AS_ARABIC = 1;
    final int AS_HEX = 2;
    final int AS_ROMAN = 4;
    final int AS_roman = 8;
    final int SIMPLE = 0;
    final int DAILY = 1;
    final int WEEKLY = 2;
    final int MONTHLY = 3;
    final int YEARLY = 4;
    final int GOPRO = 5;
    private Session s;
    private DateTime dtNow;
    private DateTime dtThen;
    private int week_number;
    private int number;
    private boolean hasBeenRun = false;
    private String sReturn;
    private String sName;
    private String sFormat;
    private String sType;
    private String sExtra;
    private int type;

    public SerialNumber() {
        try {
            this.s = NotesFactory.createSession();
            this.sReturn = new String();
            this.sName = new String();
            this.sFormat = new String();
            this.sType = new String();
            this.sExtra = new String();
            this.dtNow = this.s.createDateTime("Today");
            this.dtThen = this.s.createDateTime("Today");
            this.type = 0;
        }
        catch (NotesException e) {
            e.printStackTrace();
        }
    }

    public String getExtraParam() {
        return this.sExtra;
    }

    public String getSerialNumber(String param) {
        try {
            this.getSerialInfo(param);
            this.readSerialInfoFromIni();
            this.makeSerialNumber();
            this.writeSerialInfoToIni();
            return new String(this.sReturn);
        }
        catch (SerialNumberException hve) {
            return new String("ERROR: " + hve.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String("ERROR: " + e.getMessage());
        }
    }

    private int getSerialInfo(String param) throws SerialNumberException {
        int args = 0;
        if (param == null) {
            throw new SerialNumberException("No parameter given");
        }
        for (int i = 0; i < param.length(); ++i) {
            if (param.charAt(i) == ';') {
                ++args;
                continue;
            }
            if (args == 0) {
                this.sName = this.sName + param.charAt(i);
                continue;
            }
            if (args == 1) {
                this.sFormat = this.sFormat + param.charAt(i);
                continue;
            }
            if (args == 2) {
                this.sType = this.sType + param.charAt(i);
                continue;
            }
            if (args != 3) continue;
            this.sExtra = this.sExtra + param.charAt(i);
        }
        if (this.sName.length() == 0) {
            throw new SerialNumberException("Missing counter name");
        }
        if (args > 0 && this.sFormat.length() == 0) {
            throw new SerialNumberException("Missing format");
        }
        if (args > 1 && this.sType.length() == 0) {
            throw new SerialNumberException("Missing type");
        }
        if (args > 2 && this.sExtra.length() == 0) {
            throw new SerialNumberException("Missing extra param");
        }
        return 0;
    }

    private int readSerialInfoFromIni() throws SerialNumberException {
        boolean i = false;
        try {
            String sINIType = new String(this.sName + "_TYPE");
            String sININumber = new String(this.sName + "_NUMBER");
            String sINIDate = new String(this.sName + "_DATE");
            String sINIFormat = new String(this.sName + "_FORMAT");
            if (this.sFormat.length() == 0) {
                this.sFormat = this.s.getEnvironmentString(sINIFormat, true);
            } else {
                this.debug("format = " + this.sFormat);
            }
            if (this.sType.length() == 0) {
                this.sType = this.s.getEnvironmentString(sINIType, true);
                if (this.sType.length() == 0) {
                    this.sType = new String("gopro");
                    this.s.setEnvironmentVar(sINIType, (Object)this.sType, true);
                }
            } else {
                this.debug("sType = " + this.sType);
            }
            if (this.sType.toLowerCase().compareTo("simple") == 0) {
                this.type = 0;
            } else if (this.sType.toLowerCase().compareTo("daily") == 0) {
                this.type = 1;
            } else if (this.sType.toLowerCase().compareTo("weekly") == 0) {
                this.type = 2;
            } else if (this.sType.toLowerCase().compareTo("monthly") == 0) {
                this.type = 3;
            } else if (this.sType.toLowerCase().compareTo("yearly") == 0) {
                this.type = 4;
            } else if (this.sType.toLowerCase().compareTo("gopro") == 0) {
                this.type = 5;
            } else {
                if (this.sType.length() != 0) {
                    throw new SerialNumberException("Wrong type specified");
                }
                this.type = 5;
                this.s.setEnvironmentVar(sINIType, (Object)new String("gopro"), true);
            }
            String sDate = this.s.getEnvironmentString(sINIDate, true);
            if (sDate.length() == 0) {
                this.dtThen.setNow();
                this.s.setEnvironmentVar(sINIDate, (Object)new String(this.dtThen.toString()), true);
            } else {
                this.dtThen = this.s.createDateTime(sDate);
            }
            String sNumber = this.s.getEnvironmentString(sININumber, true);
            if (sNumber.length() != 0) {
                this.number = Integer.parseInt(sNumber);
            } else {
                this.number = 0;
                this.s.setEnvironmentVar(sININumber, (Object)new String("0"), true);
            }
        }
        catch (NotesException ne) {
            ne.printStackTrace();
        }
        return 0;
    }

    private void debug(String s) {
    }

    private int makeSerialNumber() {
        try {
            this.dtNow.setNow();
            Calendar calNow = Calendar.getInstance();
            Calendar calThen = Calendar.getInstance();
            calNow.setTime(this.dtNow.toJavaDate());
            calThen.setTime(this.dtThen.toJavaDate());
            if (calThen.before(calNow)) {
                switch (this.type) {
                    case 4: {
                        if (calNow.get(1) > calThen.get(1)) {
                            this.number = 1;
                            break;
                        }
                        ++this.number;
                        break;
                    }
                    case 1: {
                        if (calNow.get(1) > calThen.get(1) || calNow.get(2) > calThen.get(2) || calNow.get(6) > calThen.get(6)) {
                            this.number = 1;
                            break;
                        }
                        ++this.number;
                        break;
                    }
                    case 0: {
                        ++this.number;
                        break;
                    }
                    case 2: {
                        if (calNow.get(1) > calThen.get(1) || calNow.get(2) > calThen.get(2) || calNow.get(3) > calThen.get(3)) {
                            this.number = 1;
                            break;
                        }
                        ++this.number;
                        break;
                    }
                    default: {
                        if (calNow.get(1) > calThen.get(1) || calNow.get(2) > calThen.get(2)) {
                            this.number = 1;
                            break;
                        }
                        ++this.number;
                        break;
                    }
                }
            } else {
                ++this.number;
            }
            if (this.sFormat.length() > 0) {
                SerialNumberFormat hvs = new SerialNumberFormat(this.sFormat, calNow.get(1), calNow.get(2) + 1, calNow.get(5), calNow.get(3) - 1, this.number);
                this.sReturn = new String(hvs.toString());
            } else if (this.type == 5) {
                int y = calNow.get(1);
                String yy = new String(Integer.toString(y));
                String mm = new String(Integer.toString(calNow.get(2) + 1));
                String n = new String(Integer.toString(this.number));
                if (y < 2000) {
                    yy = yy.substring(2, 4);
                }
                if (mm.length() < 2) {
                    mm = "0" + mm;
                }
                if (n.length() < 2) {
                    n = "000" + n;
                } else if (n.length() < 3) {
                    n = "00" + n;
                } else if (n.length() < 4) {
                    n = "0" + n;
                }
                this.sReturn = new String(yy + mm + n);
            } else {
                this.sReturn = new String(Integer.toString(this.number) + ';' + this.dtNow.toString() + ';' + Integer.toString(calNow.get(3) - 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.debug("sReturn: " + this.sReturn);
        return 0;
    }

    private int writeSerialInfoToIni() {
        try {
            String sNumber = new String(this.sName + "_NUMBER");
            String sDate = new String(this.sName + "_DATE");
            Session s = NotesFactory.createSession();
            s.setEnvironmentVar(sNumber, (Object)Integer.toString(this.number), true);
            s.setEnvironmentVar(sDate, (Object)this.dtNow.toString(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public String getServletInfo() {
        return "SerialNumberServlet";
    }
}

