/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.domino;

import lotus.domino.Document;
import net.gopro.util.Log;
import net.gopro.util.domino.DocumentFormatter;

public class GoProCaseDocumentFormatter
extends DocumentFormatter {
    @Override
    public String getXMLBaseName(Document doc) {
        String filenameSuper = super.getXMLBaseName(doc);
        try {
            String filename = "GoPro.Case.";
            filename = filename + doc.getItemValueString("form");
            filename = filename + ".";
            filename = filename + doc.getNoteID();
            return filename;
        }
        catch (Exception e) {
            Log.print_exception(e);
            Log.println("using " + filenameSuper);
            return filenameSuper;
        }
    }

    @Override
    public String getSubject(Document doc) throws Exception {
        if (doc.isResponse()) {
            return this.getSubjectResponse(doc);
        }
        return this.getSubjectMain(doc);
    }

    private String getSubjectMain(Document doc) throws Exception {
        String dsp = "";
        String form = doc.getItemValueString("form");
        if ("maindoc".equalsIgnoreCase(form)) {
            dsp = dsp + doc.getItemValueString("casenumber");
            dsp = dsp + " " + doc.getItemValueString("subject");
        } else {
            dsp = "compcontact".equalsIgnoreCase(form) ? dsp + doc.getItemValueString("name") : ("company".equalsIgnoreCase(form) ? dsp + doc.getItemValueString("companyname") : dsp + "Unknown Document type " + form);
        }
        return dsp;
    }

    private String getSubjectResponse(Document doc) throws Exception {
        String dsp = "";
        String date = doc.getItemValueString("Date");
        dsp = date != null && date.length() > 0 ? dsp + date : dsp + doc.getCreated().getGMTTime();
        dsp = doc.hasItem("DocName") ? dsp + " " + doc.getItemValueString("DocName") : dsp + " " + doc.getItemValueString("DocType");
        dsp = dsp + ": " + doc.getItemValueString("subject");
        dsp = dsp + " (" + doc.getItemValueString("editor") + ")";
        return dsp;
    }
}

