/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.domino;

import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.DocumentCollection;
import lotus.domino.Item;
import lotus.domino.MIMEEntity;
import net.gopro.util.Log;
import org.jdom.Document;
import org.jdom.Element;

public abstract class DocumentFormatter {
    public abstract String getSubject(lotus.domino.Document var1) throws Exception;

    public Document handleJDOMDocument(Document jdoc, lotus.domino.Document ddoc) throws Exception {
        return jdoc;
    }

    public String getXMLBaseName(lotus.domino.Document doc) {
        String filename = "";
        try {
            filename = doc.getUniversalID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filename;
    }

    public Document createJDOMDocument(lotus.domino.Document ddoc) {
        Document retdoc = new Document(new Element("document"));
        try {
            Vector items = ddoc.getItems();
            Database db = ddoc.getParentDatabase();
            String sServer = db.getServer().length() == 0 ? "" : db.getServer();
            Element doc = retdoc.getRootElement();
            Element docInfo = new Element("info");
            doc.addContent(docInfo);
            docInfo.addContent(new Element("server").addContent(sServer));
            docInfo.addContent(new Element("databasepath").addContent(db.getFilePath()));
            docInfo.addContent(new Element("databasetitle").addContent(db.getTitle()));
            docInfo.addContent(new Element("form").addContent(ddoc.getItemValueString("form")));
            docInfo.addContent(new Element("unid").addContent(ddoc.getUniversalID()));
            docInfo.addContent(new Element("subject").addContent(this.getSubject(ddoc)));
            docInfo.addContent(new Element("xmlbasename").addContent(this.getXMLBaseName(ddoc)));
            if (!ddoc.getParentDocumentUNID().equals("")) {
                String parentUNID = ddoc.getParentDocumentUNID();
                lotus.domino.Document parentDoc = ddoc.getParentDatabase().getDocumentByUNID(parentUNID);
                Element parent = new Element("parent");
                parent.addContent(new Element("unid").addContent(parentUNID));
                parent.addContent(new Element("subject").addContent(this.getSubject(parentDoc)));
                parent.addContent(new Element("xmlbasename").addContent(this.getXMLBaseName(parentDoc)));
                doc.addContent(parent);
            }
            DateTime dt = ddoc.getCreated();
            docInfo.addContent(new Element("created").addContent(dt.getGMTTime()));
            dt = ddoc.getLastModified();
            docInfo.addContent(new Element("modified").addContent(dt.getGMTTime()));
            dt = ddoc.getLastAccessed();
            docInfo.addContent(new Element("accessed").addContent(dt.getGMTTime()));
            dt.setNow();
            docInfo.addContent(new Element("thisread").addContent(dt.getGMTTime()));
            docInfo.addContent(new Element("isresponse").addContent(ddoc.isResponse() ? "true" : "false"));
            DocumentCollection dc = ddoc.getResponses();
            lotus.domino.Document rdoc = dc.getFirstDocument();
            if (rdoc != null) {
                Element responses = new Element("responses");
                while (rdoc != null) {
                    Element childrenTree = this.getChildrenTree(rdoc);
                    if (childrenTree != null) {
                        responses.addContent(this.getChildrenTree(rdoc));
                    }
                    rdoc = dc.getNextDocument(rdoc);
                }
                doc.addContent(responses);
            }
            dc.recycle();
            Element eitems = new Element("items");
            for (int j = 0; j < items.size(); ++j) {
                String sType = null;
                Item item = (Item)items.elementAt(j);
                switch (item.getType()) {
                    case 1076: {
                        sType = "AUTHOR";
                        break;
                    }
                    case 1024: {
                        sType = "DATETIME";
                        break;
                    }
                    case 1074: {
                        sType = "NAME";
                        break;
                    }
                    case 768: {
                        sType = "NUMBER";
                        break;
                    }
                    case 1: {
                        sType = "RICHTEXT";
                        break;
                    }
                    case 1075: {
                        sType = "READER";
                        break;
                    }
                    case 1280: {
                        sType = "TEXT";
                        break;
                    }
                    case 25: {
                        sType = "MIME";
                    }
                }
                String sName = item.getName().toLowerCase();
                if (sType == null || sName.equals("form")) continue;
                Element eitem = new Element("item");
                eitem.setAttribute("name", sName);
                if (item.getType() == 25) {
                    MIMEEntity m = item.getMIMEEntity();
                    eitem.setAttribute("type", sType);
                    eitem.addContent(m.getContentAsText());
                } else {
                    Vector vValues = item.getValues();
                    if (vValues == null) continue;
                    if (vValues.size() > 1) {
                        eitem.setAttribute("type", sType + "LIST");
                        for (int i = 0; i < vValues.size(); ++i) {
                            Element listitem = new Element(sType);
                            listitem.addContent(vValues.elementAt(i).toString());
                            eitem.addContent(listitem);
                        }
                    } else {
                        eitem.setAttribute("type", sType);
                        String sValue = "";
                        if (vValues.size() != 1) continue;
                        sValue = vValues.elementAt(0).toString();
                        eitem.addContent(sValue);
                    }
                }
                eitems.addContent(eitem);
            }
            doc.addContent(eitems);
            retdoc = this.handleJDOMDocument(retdoc, ddoc);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return retdoc;
    }

    private Element getChildrenTree(lotus.domino.Document ddoc) throws Exception {
        Element document = new Element("child");
        document.setAttribute("unid", ddoc.getUniversalID());
        document.setAttribute("subject", this.getSubject(ddoc));
        document.setAttribute("xmlbasename", this.getXMLBaseName(ddoc));
        document.setAttribute("created", ddoc.getCreated().getGMTTime());
        document.setAttribute("form", ddoc.getItemValueString("form"));
        DocumentCollection dcChildren = ddoc.getResponses();
        lotus.domino.Document docChild = dcChildren.getFirstDocument();
        if (docChild != null) {
            Element children = new Element("children");
            while (docChild != null) {
                Element cc = this.getChildrenTree(docChild);
                if (cc != null) {
                    children.addContent(cc);
                }
                docChild = dcChildren.getNextDocument(docChild);
            }
            if (children.getChild("child") != null) {
                document.addContent(children);
            }
        }
        dcChildren.recycle();
        return document;
    }
}

