/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.domino;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.transform.Transformer;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import net.gopro.GoProException;
import net.gopro.util.Log;
import net.gopro.util.XSLTransformer;
import net.gopro.util.domino.DefaultDocumentFormatter;
import net.gopro.util.domino.DocumentFormatter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class DocumentDumper {
    lotus.domino.Document m_Doc;
    static DocumentFormatter m_DocumentFormatter = new DefaultDocumentFormatter();
    static XMLOutputter m_XMLOutputter = new XMLOutputter();
    static XMLOutputter m_HTMLOutputter = new XMLOutputter();
    static int m_iAttachmentsDumped = 0;

    static void setAttachmentsDumped(int i) {
        m_iAttachmentsDumped = i;
    }

    static int getAttachmentsDumped() {
        return m_iAttachmentsDumped;
    }

    static void setXMLOutputter(XMLOutputter x) {
        m_XMLOutputter = x;
    }

    static void setHTMLOutputter(XMLOutputter x) {
        m_HTMLOutputter = x;
    }

    static void setDocumentFormatter(String sdf) {
        String success = "Loaded document formatter of type ";
        try {
            m_DocumentFormatter = (DocumentFormatter)Class.forName(sdf).newInstance();
            Log.println(success + sdf);
        }
        catch (Exception e1) {
            String err1 = "Error loading document formatter '" + sdf + "': " + e1.toString();
            String sdf2 = "net.gopro.util.domino." + sdf;
            try {
                m_DocumentFormatter = (DocumentFormatter)Class.forName(sdf2).newInstance();
                Log.println(success + sdf2);
            }
            catch (Exception e2) {
                Log.println(err1);
                String err2 = "Error loading document formatter '" + sdf2 + "': " + e2.toString();
                Log.println(err2);
                m_DocumentFormatter = new DefaultDocumentFormatter();
                Log.println("Using default document formatter");
            }
        }
    }

    public DocumentDumper(lotus.domino.Document doc) {
        this.m_Doc = doc;
    }

    public Element dump(String outputRoot, Transformer transXML, Transformer transHTML, boolean bHTML, boolean bAttachments) throws Exception {
        Vector vAttachments;
        String outputDirXML = outputRoot + File.separator + "xml";
        String outputDirHTML = outputRoot + File.separator + "html";
        String outputDirAttachments = outputRoot + File.separator + "attachments";
        Element e = new Element("document");
        String form = this.m_Doc.getItemValueString("form");
        e.setAttribute("form", form);
        String unid = this.m_Doc.getUniversalID();
        e.setAttribute("unid", unid);
        String subject = m_DocumentFormatter.getSubject(this.m_Doc);
        String xmlbasename = m_DocumentFormatter.getXMLBaseName(this.m_Doc);
        Log.verbose_println("Dumping " + subject);
        e.setAttribute("xmlbasename", xmlbasename);
        if (subject != null && !"".equals(subject)) {
            e.setAttribute("subject", subject);
        }
        e.setAttribute("created", this.m_Doc.getCreated().getGMTTime());
        String filenameXML = outputDirXML + File.separator + m_DocumentFormatter.getXMLBaseName(this.m_Doc) + ".xml";
        Log.verbose_println("XML " + filenameXML);
        Document xmldoc = m_DocumentFormatter.createJDOMDocument(this.m_Doc);
        if (bAttachments && (vAttachments = this.dumpAttachments(outputDirAttachments)) != null && vAttachments.size() > 0) {
            m_iAttachmentsDumped += vAttachments.size();
            e.setAttribute("hasattachments", "true");
            Element root = xmldoc.getRootElement();
            Element fa = new Element("attachments");
            root.addContent(fa);
            for (int i = 0; i < vAttachments.size(); ++i) {
                Element file = new Element("file");
                fa.addContent(file);
                Vector vAttachmentInfo = (Vector)vAttachments.elementAt(i);
                String filename = (String)vAttachmentInfo.elementAt(0);
                String filesize = (String)vAttachmentInfo.elementAt(1);
                String filetype = (String)vAttachmentInfo.elementAt(2);
                file.addContent(filename);
                file.setAttribute("size", filesize);
                file.setAttribute("type", filetype);
            }
        }
        if (transXML != null) {
            Document xmldocout = XSLTransformer.transform(xmldoc, transXML);
            m_XMLOutputter.output(xmldocout, (OutputStream)new FileOutputStream(filenameXML));
        } else {
            m_XMLOutputter.output(xmldoc, (OutputStream)new FileOutputStream(filenameXML));
        }
        if (outputDirHTML == null || transHTML == null || !bHTML) {
            Log.verbose_println("No HTML transformation because of a missing html output dir, transformer or interest");
            return e;
        }
        String filenameHTML = outputDirHTML + File.separator + m_DocumentFormatter.getXMLBaseName(this.m_Doc) + ".html";
        Log.verbose_println("HTML " + filenameHTML);
        Document htmldoc = XSLTransformer.transform(xmldoc, transHTML);
        m_HTMLOutputter.output(htmldoc, (OutputStream)new FileOutputStream(filenameHTML));
        return e;
    }

    public Vector dumpAttachments(String path) throws Exception {
        Vector vReturn = null;
        if (this.m_Doc.hasEmbedded()) {
            int i;
            if (path == null || "".equals(path)) {
                Log.verbose_println("Skipping attachments because of missing attachment path");
                return null;
            }
            if (this.m_Doc.hasItem("$FILE")) {
                vReturn = new Vector();
                Vector vItems = this.m_Doc.getItems();
                for (i = 0; i < vItems.size(); ++i) {
                    int tmp;
                    Item item = (Item)vItems.elementAt(i);
                    if (item.getType() != 1084) continue;
                    String filename = item.getValueString();
                    EmbeddedObject eo = this.m_Doc.getAttachment(filename);
                    Vector<String> vEOInfo = new Vector<String>();
                    String eoname = eo.getSource();
                    vEOInfo.addElement(eoname);
                    vEOInfo.addElement(Integer.toString(eo.getFileSize()));
                    int dot = eoname.indexOf(46);
                    while (dot > -1 && (tmp = eoname.indexOf(46, dot + 1)) != -1) {
                        dot = tmp;
                    }
                    String postfix = "";
                    if (dot > -1) {
                        postfix = eoname.substring(dot + 1);
                    }
                    vEOInfo.addElement(postfix);
                    this.handleAttachment(eo, path);
                    vReturn.addElement(vEOInfo);
                }
            }
            Vector vEO = this.m_Doc.getEmbeddedObjects();
            for (i = 0; i < vEO.size(); ++i) {
                EmbeddedObject eo = (EmbeddedObject)vEO.elementAt(i);
                if (eo.getType() == 1454) continue;
                this.handleObject((EmbeddedObject)vEO.elementAt(i));
            }
        }
        return vReturn;
    }

    private void handleAttachment(EmbeddedObject eo, String path) throws GoProException {
        String filename = "";
        try {
            int len;
            filename = path + File.separator + m_DocumentFormatter.getXMLBaseName(this.m_Doc) + "." + eo.getSource();
            Log.verbose_println("Attachment, " + eo.getFileSize() + " bytes, " + filename);
            BufferedInputStream bis = new BufferedInputStream(eo.getInputStream());
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filename));
            byte[] buff = new byte[10000];
            while ((len = bis.read(buff)) > 0) {
                bos.write(buff, 0, len);
            }
            bos.flush();
        }
        catch (Exception e) {
            String msg = "Problem saving attachments '" + filename + "'.  I will try to continue anyway";
            Log.println(msg);
            Log.print_exception(e);
        }
    }

    private void handleObject(EmbeddedObject eo) throws Exception {
        try {
            Log.println("Warning: document '" + m_DocumentFormatter.getSubject(this.m_Doc) + "' has an object which will not be dumped: '" + eo.getName() + "'");
        }
        catch (Exception e) {
            throw new GoProException("Problem reporting objects", e);
        }
    }
}

