/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.domino;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;
import net.gopro.GoProException;
import net.gopro.util.Log;
import net.gopro.util.Parameters;
import net.gopro.util.XSLTransformer;
import net.gopro.util.domino.DocumentDumper;
import net.gopro.util.domino.DocumentFormatter;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public final class DatabaseDumper {
    Parameters m_Parameters;
    Session m_Session;
    Database m_DB;
    DocumentFormatter m_DocumentFormatter;
    XMLOutputter m_XMLOutputter;
    XMLOutputter m_HTMLOutputter;
    Transformer m_transIndexXML;
    Transformer m_transIndexHTML;
    Transformer m_transDocumentXML;
    Transformer m_transDocumentHTML;
    String m_sOutputRoot;
    boolean m_bOutputAttachments;
    boolean m_bOutputHTML;
    String m_sDocumentSelection = "!@IsResponseDoc";
    final String VERSION = "0.9.3";
    final String VERSIONDATE = "April 4 2002";
    final String COPYRIGHT = "Copyright (C) 2002 GoPro Development, All rights reserved";
    final String APPNAME = "GoPro Domino Dumper";
    final String LOGHEADER1 = "GoPro Domino Dumper, Version 0.9.3 of April 4 2002";
    final String LOGHEADER2 = "Copyright (C) 2002 GoPro Development, All rights reserved";
    final String[] m_aMandatoryParams = new String[]{"domino.database", "output.path"};
    int m_iDumpedDocuments = 0;
    int m_iMainDocDumpMSGInterval = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            NotesThread.sinitThread();
            DatabaseDumper dd = args.length > 0 ? new DatabaseDumper(args[0]) : new DatabaseDumper();
            dd.dump();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
    }

    public DatabaseDumper() throws Exception {
        this(new Parameters("DatabaseDumper.xml"));
    }

    public DatabaseDumper(String database, String outputPath) throws Exception {
        Parameters p = new Parameters();
        p.put("domino.database", database);
        p.put("output.path", outputPath);
        this.init(p);
    }

    public DatabaseDumper(String filename) throws Exception {
        this(new Parameters(filename));
    }

    public DatabaseDumper(Parameters param) throws Exception {
        this.init(param);
    }

    private void init(Parameters param) throws Exception {
        this.m_Parameters = param;
        this.m_Parameters.checkMandatories(this.m_aMandatoryParams);
        String logParameter = "log.debug";
        try {
            Log.setDebug(this.m_Parameters.getBoolean(logParameter, false));
            logParameter = "log.file";
            Log.setDebugFile(this.m_Parameters.getString(logParameter, null));
            logParameter = "log.tofileonly";
            Log.setLogToFileOnly(this.m_Parameters.getBoolean(logParameter, false));
            logParameter = "log.verbose";
            Log.setVerbose(this.m_Parameters.getBoolean(logParameter, false));
        }
        catch (Exception e2) {
            String msg = "Error setting up log.  There is something wrong with parameter " + logParameter + "\n" + "I will try to continue anyway";
            Log.println(msg);
        }
        Log.println_no_stamp("");
        Log.println_no_stamp("GoPro Domino Dumper, Version 0.9.3 of April 4 2002");
        Log.println_no_stamp("Copyright (C) 2002 GoPro Development, All rights reserved");
        Log.println_no_stamp("");
        try {
            String sServer = this.m_Parameters.getString("domino.server");
            String sUser = this.m_Parameters.getString("domino.user");
            String sPassword = this.m_Parameters.getString("domino.password");
            String sSessionType = this.m_Parameters.getString("domino.sessiontype", "local");
            if (sSessionType.equals("server")) {
                Log.verbose_println("Creating server session");
                this.m_Session = NotesFactory.createSession();
            } else if (sSessionType.equals("iiop")) {
                Log.verbose_println("Creating iiop session");
                this.m_Session = NotesFactory.createSession((String)sServer, (String)sUser, (String)sPassword);
            } else if (sSessionType.equals("local")) {
                Log.verbose_println("Creating local session");
                this.m_Session = NotesFactory.createSession((String)null, (String)sUser, (String)sPassword);
            }
            this.m_Session.setConvertMime(true);
        }
        catch (Exception e) {
            throw new GoProException("Unable to create Domino session", e);
        }
        Log.verbose_println("Session server: " + this.m_Session.getServerName());
        Log.verbose_println("Session user: " + this.m_Session.getUserName());
        Log.verbose_println("Session platform: " + this.m_Session.getPlatform());
        try {
            this.m_DB = this.m_Session.getDatabase(this.m_Parameters.getString("domino.server"), this.m_Parameters.getString("domino.database"));
            if (!this.m_DB.isOpen()) {
                this.m_DB.open();
            }
        }
        catch (Exception e) {
            Log.println("Unable to open " + this.m_Parameters.getString("domino.server") + "!!" + this.m_Parameters.getString("domino.database"));
            throw e;
        }
        String selection = this.m_Parameters.getString("document.selection", null);
        if (selection != null) {
            this.m_sDocumentSelection = selection;
        }
        Log.verbose_println("Database title: " + this.m_DB.getTitle());
        Log.verbose_println("Database path: " + this.m_DB.getFilePath());
        this.m_iMainDocDumpMSGInterval = this.m_Parameters.getInt("output.msginterval", 10);
        this.m_bOutputHTML = this.m_Parameters.getBoolean("output.html", true);
        this.m_bOutputAttachments = this.m_Parameters.getBoolean("output.attachments", true);
        this.m_sOutputRoot = this.m_Parameters.getString("output.path", null);
        this.setupOutputRoot();
        String formatter = this.m_Parameters.getString("document.formatter", null);
        if (formatter != null) {
            Log.verbose_println("Setting up document formatter: " + formatter);
            DocumentDumper.setDocumentFormatter(formatter);
        }
        Log.verbose_println("Setting up XML outputter");
        this.m_XMLOutputter = this.makeXMLOutputter("output.xml");
        DocumentDumper.setXMLOutputter(this.m_XMLOutputter);
        Log.verbose_println("Setting up HTML outputter");
        this.m_HTMLOutputter = this.makeXMLOutputter("output.html");
        DocumentDumper.setHTMLOutputter(this.m_HTMLOutputter);
        String xslKey = "";
        try {
            URL sourceURL;
            xslKey = "output.index.xmltransformation";
            String xsl = this.m_Parameters.getString(xslKey);
            if (xsl != null && !"".equals(xsl)) {
                this.m_transIndexXML = TransformerFactory.newInstance().newTransformer(new StreamSource(xsl));
                Log.verbose_println("Using " + xsl + " for index xml to xml transformation");
            }
            if ((xsl = this.m_Parameters.getString(xslKey = "output.index.htmltransformation", null)) == null || "".equals(xsl)) {
                sourceURL = this.getClass().getResource("index-xml-to-html.xsl");
                xsl = sourceURL.toString();
            }
            this.m_transIndexHTML = TransformerFactory.newInstance().newTransformer(new StreamSource(xsl));
            Log.verbose_println("Using " + xsl + " for index xml to html transformation");
            xslKey = "output.document.xmltransformation";
            xsl = this.m_Parameters.getString(xslKey, null);
            if (xsl != null && !"".equals(xsl)) {
                this.m_transDocumentXML = TransformerFactory.newInstance().newTransformer(new StreamSource(xsl));
                Log.verbose_println("Using " + xsl + " for document xml to xml transformation");
            }
            if ((xsl = this.m_Parameters.getString(xslKey = "output.document.htmltransformation", null)) == null || "".equals(xsl)) {
                sourceURL = this.getClass().getResource("document-xml-to-html.xsl");
                xsl = sourceURL.toString();
            }
            this.m_transDocumentHTML = TransformerFactory.newInstance().newTransformer(new StreamSource(xsl));
            Log.verbose_println("Using " + xsl + " for document xml to html transformation");
        }
        catch (Exception e) {
            String msg = "Error setting up XSL transformators.  There is something wrong with parameter " + xslKey;
            throw new GoProException(msg, e);
        }
    }

    public void dump() throws Exception {
        Log.println("Starting dump of database");
        Log.println("Searching for documents using " + this.m_sDocumentSelection);
        org.jdom.Document index = this.makeIndexDoc();
        Element root = index.getRootElement();
        Element documents = new Element("documents");
        root.addContent(documents);
        DocumentCollection dc = this.m_DB.search(this.m_sDocumentSelection);
        Log.println("found " + dc.getCount());
        Document ddoc = dc.getFirstDocument();
        int documentInterval = this.m_iMainDocDumpMSGInterval;
        int mainDocsDumped = 0;
        while (ddoc != null) {
            Element indexElement = this.dumpRecursive(ddoc, 0);
            documents.addContent(indexElement);
            ddoc = dc.getNextDocument(ddoc);
            if (++mainDocsDumped <= documentInterval) continue;
            String msg = "" + mainDocsDumped + " main documents, ";
            msg = msg + this.m_iDumpedDocuments + " in total, dumped";
            Log.println(msg);
            documentInterval += this.m_iMainDocDumpMSGInterval;
        }
        if (mainDocsDumped > 0) {
            String msg = "" + mainDocsDumped + " main documents, ";
            msg = msg + this.m_iDumpedDocuments + " in total, dumped";
            Log.println(msg);
        }
        dc.recycle();
        String filenameIndexXML = this.m_sOutputRoot + File.separator + "index.xml";
        if (this.m_transIndexXML != null) {
            org.jdom.Document xmldocout = XSLTransformer.transform(index, this.m_transIndexXML);
            this.m_XMLOutputter.output(xmldocout, (OutputStream)new FileOutputStream(filenameIndexXML));
        } else {
            this.m_XMLOutputter.output(index, (OutputStream)new FileOutputStream(filenameIndexXML));
        }
        if (this.m_transIndexHTML == null) {
            Log.verbose_println("No HTML transformation of the index because of a missing transformer");
        } else {
            try {
                String filenameIndexHTML = this.m_sOutputRoot + File.separator + "index.html";
                org.jdom.Document htmldocout = XSLTransformer.transform(index, this.m_transIndexHTML);
                this.m_HTMLOutputter.output(htmldocout, (OutputStream)new FileOutputStream(filenameIndexHTML));
                Log.verbose_println("HTML index " + filenameIndexHTML);
            }
            catch (Exception e) {
                Log.println("Error converting index.xml to index.html");
                Log.print_exception(e);
            }
        }
        Log.println("Done!");
    }

    private org.jdom.Document makeIndexDoc() throws Exception {
        org.jdom.Document doc = new org.jdom.Document(new Element("index"));
        Element root = doc.getRootElement();
        Element info = new Element("info");
        root.addContent(info);
        info.addContent(new Element("root").addContent(this.m_sOutputRoot));
        info.addContent(new Element("server").addContent(this.m_DB.getServer()));
        info.addContent(new Element("databasepath").addContent(this.m_DB.getFilePath()));
        info.addContent(new Element("databasetitle").addContent(this.m_DB.getTitle()));
        info.addContent(new Element("lastmodified").addContent(this.m_DB.getLastModified().getGMTTime()));
        info.addContent(new Element("created").addContent(this.m_DB.getCreated().getGMTTime()));
        info.addContent(new Element("replicaid").addContent(this.m_DB.getReplicaID()));
        info.addContent(new Element("template").addContent(this.m_DB.getTemplateName()));
        return doc;
    }

    private Element dumpRecursive(Document doc, int level) throws GoProException {
        try {
            DocumentDumper dd = new DocumentDumper(doc);
            Element e = dd.dump(this.m_sOutputRoot, this.m_transDocumentXML, this.m_transDocumentHTML, this.m_bOutputHTML, this.m_bOutputAttachments);
            ++this.m_iDumpedDocuments;
            DocumentCollection dc = doc.getResponses();
            Document rdoc = dc.getFirstDocument();
            Element children = new Element("children");
            if (rdoc != null) {
                e.addContent(children);
            }
            while (rdoc != null) {
                children.addContent(this.dumpRecursive(rdoc, level + 1));
                rdoc = dc.getNextDocument(rdoc);
            }
            return e;
        }
        catch (Exception e) {
            throw new GoProException("Problem going recurse down the document tree", e);
        }
    }

    private XMLOutputter makeXMLOutputter(String prefix) throws GoProException {
        XMLOutputter xo = new XMLOutputter();
        try {
            String s = this.m_Parameters.getString(prefix + "encoding", "ISO-8859-1");
            xo.setEncoding(s);
            boolean b = this.m_Parameters.getBoolean(prefix + "expandemptyelements", false);
            xo.setExpandEmptyElements(b);
            b = this.m_Parameters.getBoolean(prefix + "indent", true);
            xo.setIndent(b);
            int i = this.m_Parameters.getInt(prefix + "indentsize", 3);
            xo.setIndentSize(i);
            b = this.m_Parameters.getBoolean(prefix + "newlines", true);
            xo.setNewlines(b);
            b = this.m_Parameters.getBoolean(prefix + "omitdeclaration", false);
            xo.setOmitDeclaration(b);
            b = this.m_Parameters.getBoolean(prefix + "omitencoding", false);
            xo.setOmitEncoding(b);
            b = this.m_Parameters.getBoolean(prefix + "textnormalize", false);
            xo.setTextNormalize(b);
        }
        catch (Exception e) {
            String msg = "Error parsing " + prefix + " settings";
            Log.println(msg);
            throw new GoProException(msg, e);
        }
        return xo;
    }

    private void setupOutputRoot() throws GoProException {
        String dir = "";
        try {
            dir = this.m_sOutputRoot + File.separator + "xml";
            new File(dir).mkdirs();
            if (this.m_bOutputHTML) {
                dir = this.m_sOutputRoot + File.separator + "html";
                new File(dir).mkdirs();
            }
            if (this.m_bOutputAttachments) {
                dir = this.m_sOutputRoot + File.separator + "attachments";
                new File(dir).mkdirs();
            }
        }
        catch (Exception e) {
            String msg = "Problem setting up " + dir;
            throw new GoProException(msg, e);
        }
    }
}

