/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.util.Calendar;
import net.gopro.util.Format;

public class SerialNumberFormat {
    static final String ssid = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/util/SerialNumberFormat.java 2     20.09.05 9:38 Kbg $";
    final int DEBUG = 1;
    final int MAX_ROMAN_LEN = 64;
    final int MAX_ROMAN_VALUE = 40000;
    final int MAX_FMTNUM_LEN = 1024;
    final int AS_ARABIC = 1;
    final int AS_HEX = 2;
    final int AS_ROMAN = 4;
    final int AS_roman = 8;
    String sReturn;

    public SerialNumberFormat() {
        this.sReturn = new String();
    }

    public SerialNumberFormat(String fmt, int y, int m, int d, int w, int n) {
        this.sReturn = this.fmtnum(fmt, y, m, d, w, n);
    }

    public SerialNumberFormat(String fmt, Calendar calNow, int n) {
        this.sReturn = this.fmtnum(fmt, calNow.get(1), calNow.get(2) + 1, calNow.get(5), calNow.get(3) - 1, n);
    }

    public String toString() {
        return this.sReturn;
    }

    String asroman(int value_, boolean asupper) {
        int value;
        char[] roman = new char[66];
        int i = 0;
        int dvalue = value_;
        if (value > 40000) {
            return new String(new Format("%d").add(value).toString());
        }
        for (value = value_; value >= 1000 && i < 64; value -= 1000) {
            roman[i++] = 77;
        }
        if (value >= 900) {
            roman[i++] = 67;
            roman[i++] = 77;
            value -= 900;
        }
        while (value >= 500 && i < 64) {
            roman[i++] = 68;
            value -= 500;
        }
        if (value >= 400 && i < 64) {
            roman[i++] = 67;
            roman[i++] = 68;
            value -= 400;
        }
        while (value >= 100 && i < 64) {
            roman[i++] = 67;
            value -= 100;
        }
        if (value >= 90 && i < 64) {
            roman[i++] = 88;
            roman[i++] = 67;
            value -= 90;
        }
        while (value >= 50 && i < 64) {
            roman[i++] = 76;
            value -= 50;
        }
        if (value >= 40 && i < 64) {
            roman[i++] = 88;
            roman[i++] = 76;
            value -= 40;
        }
        while (value >= 10 && i < 64) {
            roman[i++] = 88;
            value -= 10;
        }
        if (value >= 9) {
            roman[i++] = 73;
            roman[i++] = 88;
            value -= 9;
        }
        while (value >= 5) {
            roman[i++] = 86;
            value -= 5;
        }
        if (value >= 4) {
            roman[i++] = 73;
            roman[i++] = 86;
            value -= 4;
        }
        while (value > 0 && i < 64) {
            roman[i++] = 73;
            --value;
        }
        if (!asupper) {
            return new String(roman).toLowerCase();
        }
        return new String(roman);
    }

    public String fmtnum(String sFormat, int number) {
        Calendar calNow = Calendar.getInstance();
        return this.fmtnum(sFormat, calNow.get(1), calNow.get(2) + 1, calNow.get(5), calNow.get(3) - 1, number);
    }

    public String fmtnum(String sfmt, int y, int m, int d, int w, int n) {
        char[] fmt = new char[sfmt.length() + 1];
        fmt = sfmt.toCharArray();
        int fmt_idx = 0;
        StringBuffer strbuffer = new StringBuffer();
        while (fmt.length > fmt_idx) {
            if (fmt[fmt_idx] == '%') {
                char[] tmp_format = new char[1000];
                boolean done = false;
                int tmp_format_idx = 0;
                int cfmt = 100;
                while (fmt.length > fmt_idx && !done) {
                    char sign = fmt[fmt_idx++];
                    char uppersign = Character.toUpperCase(sign);
                    int value = 0;
                    int ntype = 1;
                    switch (uppersign) {
                        case 'Y': {
                            done = true;
                            value = y;
                            break;
                        }
                        case 'M': {
                            done = true;
                            value = m;
                            break;
                        }
                        case 'D': {
                            done = true;
                            value = d;
                            break;
                        }
                        case 'N': {
                            done = true;
                            value = n;
                            break;
                        }
                        case 'W': {
                            done = true;
                            value = w;
                            break;
                        }
                        default: {
                            tmp_format[tmp_format_idx++] = sign;
                        }
                    }
                    if (done) {
                        int i = 0;
                        if (tmp_format_idx > 1) {
                            switch (tmp_format[tmp_format_idx - 1]) {
                                case 'X': {
                                    cfmt = 88;
                                    --tmp_format_idx;
                                    ntype = 2;
                                    break;
                                }
                                case 'x': {
                                    cfmt = 120;
                                    --tmp_format_idx;
                                    ntype = 2;
                                    break;
                                }
                                case 'r': {
                                    cfmt = 115;
                                    --tmp_format_idx;
                                    ntype = 8;
                                    break;
                                }
                                case 'R': {
                                    cfmt = 115;
                                    --tmp_format_idx;
                                    ntype = 4;
                                    break;
                                }
                                default: {
                                    cfmt = 100;
                                    ntype = 1;
                                }
                            }
                        }
                        while (fmt.length > fmt_idx && Character.toUpperCase(fmt[fmt_idx]) == uppersign) {
                            ++i;
                            ++fmt_idx;
                        }
                        switch (uppersign) {
                            case 'Y': {
                                if (i == true || i == 3) break;
                                this.sReturn = new String("Error in year format");
                                return this.sReturn;
                            }
                            case 'D': 
                            case 'M': 
                            case 'N': 
                            case 'W': {
                                if (i == 0) break;
                                this.sReturn = new String("Error in week format");
                                return this.sReturn;
                            }
                        }
                        if (i < 3 && uppersign == 'Y') {
                            value = value < 2000 ? value - 1900 : value - 2000;
                        }
                        tmp_format[tmp_format_idx++] = cfmt;
                        String sformat = new String(tmp_format, 0, tmp_format_idx);
                        Format f = new Format(sformat);
                        if (ntype == 4 || ntype == 8) {
                            String sroman = new String(this.asroman(value, ntype == 4));
                            f.add(sroman);
                        } else {
                            f.add(value);
                        }
                        strbuffer.append(f.toString());
                        continue;
                    }
                    if (fmt.length != fmt_idx) continue;
                    strbuffer.append(tmp_format);
                }
                continue;
            }
            while (fmt.length > fmt_idx && fmt[fmt_idx] != '%') {
                strbuffer.append(fmt[fmt_idx++]);
            }
        }
        this.sReturn = new String(strbuffer.toString());
        return this.sReturn;
    }
}

