/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import net.gopro.GoProException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class Parameters
extends Hashtable {
    public Parameters() throws Exception {
    }

    public Parameters(String filename) throws Exception {
        this(filename, null);
    }

    public Parameters(String filename, String[] mandatories) throws Exception {
        Document jdocParameters = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            jdocParameters = builder.build(new File(filename));
        }
        catch (Exception e) {
            throw new GoProException("Unable to parse init file: " + filename, e);
        }
        this.init(jdocParameters, mandatories);
    }

    public Parameters(Document jdocParameters) throws Exception {
        this.init(jdocParameters, null);
    }

    public Parameters(Document jdocParameters, String[] mandatories) throws Exception {
        this.init(jdocParameters, mandatories);
    }

    public void save(String filename) throws Exception {
        throw new Exception("Parameters.save is not currently implemented");
    }

    private void init(Document jdocParameters, String[] mandatories) throws Exception {
        try {
            Iterator it = jdocParameters.getRootElement().getChildren().iterator();
            while (it != null && it.hasNext()) {
                Element e = (Element)it.next();
                if (e.getAttribute("name") == null) {
                    throw new GoProException("Element missing 'name' attribute in parameters");
                }
                String name = e.getAttributeValue("name");
                String value = e.getAttribute("value") == null ? e.getText() : e.getAttributeValue("value");
                this.put(name, value);
            }
        }
        catch (Exception e1) {
            throw new GoProException("Error parsing parameters", e1);
        }
        this.checkMandatories(mandatories);
    }

    public Object getParameter(String key) {
        return this.get(key);
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String def) {
        String rs = (String)this.get(key);
        return rs == null ? def : rs;
    }

    public boolean getBoolean(String key, boolean def) {
        String rs = (String)this.get(key);
        if (rs == null) {
            return def;
        }
        if ("true".equalsIgnoreCase(rs) || "1".equals(rs)) {
            return true;
        }
        if ("false".equalsIgnoreCase(rs) || "0".equals(rs)) {
            return false;
        }
        return def;
    }

    public int getInt(String key, int def) {
        Object oo = this.get(key);
        try {
            return (Integer)oo;
        }
        catch (Exception e) {
            return def;
        }
    }

    public void checkMandatories(String[] mandatories) throws Exception {
        if (mandatories == null) {
            return;
        }
        for (int i = 0; i < mandatories.length; ++i) {
            String name = mandatories[i];
            if (this.get(name) != null) continue;
            throw new GoProException("Missing mandatory <param name='" + name + "' value='...'>");
        }
    }
}

