/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import lotus.domino.NotesException;

public class Log {
    static String ssid = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/util/Log.java 1     23.06.03 15:17 Kbg $";
    static boolean m_bNoLogging = false;
    static boolean m_bDebug = false;
    static boolean m_bVerbose = false;
    static boolean m_bLogToFileOnly = false;
    static PrintWriter m_pwLog = null;
    static SimpleDateFormat m_DateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    public static void setDateFormat(SimpleDateFormat d) {
        m_DateFormat = d;
    }

    public static void setPrintWriter(PrintWriter pw) {
        m_pwLog = pw;
    }

    public static void setNoLogging(boolean nl) {
        m_bNoLogging = nl;
    }

    public static void setVerbose(boolean verbose) {
        m_bVerbose = verbose;
    }

    public static void setDebug(boolean debug) {
        m_bDebug = debug;
    }

    public static void setLogToFileOnly(boolean b) {
        m_bLogToFileOnly = b;
    }

    public static void setDebugFile(String name) {
        m_pwLog = null;
        if (name == null || "".equals(name)) {
            return;
        }
        try {
            m_pwLog = new PrintWriter(new FileOutputStream(name), true);
        }
        catch (Exception e) {
            System.out.println("Unable to create logfile " + name);
            e.printStackTrace();
        }
    }

    public static boolean getDebug() {
        return m_bDebug;
    }

    public static boolean getVerbose() {
        return m_bVerbose;
    }

    public static void println_to_file(String s) {
        if (m_bNoLogging) {
            return;
        }
        if (m_pwLog != null) {
            String stamp = m_DateFormat.format(new Date());
            m_pwLog.println(stamp + " " + s);
        }
    }

    public static void print_exception(Exception e) {
        if (m_bNoLogging) {
            return;
        }
        String msg = e instanceof NotesException ? ((NotesException)((Object)e)).text : e.getLocalizedMessage();
        if (msg != null && msg.length() > 0) {
            msg = ": " + msg;
        }
        Log.println("EXCEPTION(" + e.getClass().getName() + ")" + msg);
        if (m_pwLog != null) {
            e.printStackTrace(m_pwLog);
        }
        if (Log.getDebug() && !m_bLogToFileOnly) {
            e.printStackTrace();
        }
    }

    public static void println(String what) {
        if (m_bNoLogging) {
            return;
        }
        String stamp = m_DateFormat.format(new Date());
        Log.println_no_stamp(stamp + " " + what);
    }

    public static void println_no_stamp(String s) {
        if (m_bNoLogging) {
            return;
        }
        if (!m_bLogToFileOnly) {
            System.out.println(s);
        }
        if (m_pwLog != null) {
            m_pwLog.println(s);
        }
    }

    public static void debug_println(String s) {
        if (m_bDebug) {
            Log.println("debug: " + s);
        }
    }

    public static void verbose_println(String s) {
        if (m_bVerbose) {
            Log.println(s);
        }
    }

    public static void debug_time_println(String s, Date d1, Date d2) {
        if (m_bDebug && d1 != null & d2 != null) {
            String strTime = s + (d2.getTime() - d1.getTime()) + " ms";
            Log.println("\n\n" + strTime + "\n\n");
        }
    }
}

