/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ISODateFormat
extends SimpleDateFormat {
    private int type;
    private static final TimeZone tz_gmt = TimeZone.getTimeZone("GMT");

    public ISODateFormat() {
        this(3);
    }

    public ISODateFormat(int type) {
        this.type = type;
        StringBuffer s = new StringBuffer(24);
        switch (type) {
            case 0: {
                s.append('z');
            }
            case 1: {
                s.append("SSS.");
            }
            case 2: {
                s.append("ss:mm:HH'T'");
            }
        }
        s.append("dd-MM-yyyy");
        s.reverse();
        this.applyPattern(s.toString());
        this.setTimeZone(tz_gmt);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        if (this.type == 1) {
            toAppendTo = super.format(date, toAppendTo, pos);
            toAppendTo.append("0000");
            return toAppendTo;
        }
        if (this.type == 0) {
            StringBuffer s = new StringBuffer(33);
            s = super.format(date, s, pos);
            s.replace(23, 26, "0000-00:00");
            return toAppendTo.append(s.toString());
        }
        return super.format(date, toAppendTo, pos);
    }

    @Override
    public Date parse(String text) throws ParseException {
        StringBuffer s = new StringBuffer(32);
        if (text.length() > 23) {
            s.append(text.substring(0, 23));
            if (this.type == 0) {
                s.append("GMT");
                s.append(text.substring(text.length() - 6));
            }
        } else {
            s.append(text);
        }
        return super.parse(s.toString());
    }
}

