/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

public class Format {
    static final String ssid = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/util/Format.java 1     23.06.03 15:17 Kbg $";
    static final int LEFT_ALIGN = 1;
    static final int SIGN_PREFIX = 2;
    static final int SPACE_PREFIX = 4;
    static final int ZERO_PAD = 8;
    static final int ALTERNATE = 16;
    static final int UNKNOWN = 0;
    static final int CHARACTER = 1;
    static final int DECIMAL = 2;
    static final int FLOAT = 3;
    static final int LCHEX = 4;
    static final int UCHEX = 5;
    static final int STRING = 6;
    char[] fmt;
    int fmtLen;
    int idx;
    int flags;
    int type;
    int width;
    int precision;
    StringBuffer result;

    public Format(String fmtString) {
        this.fmtLen = fmtString.length();
        this.fmt = new char[this.fmtLen];
        fmtString.getChars(0, this.fmtLen, this.fmt, 0);
        this.reset();
    }

    public void reset() {
        this.result = new StringBuffer(this.fmtLen);
        this.idx = 0;
        this.getNextField();
    }

    public String toString() {
        return this.result.toString();
    }

    public Format add(long i) {
        String field2 = null;
        switch (this.type) {
            case 1: {
                this.result.append((char)i);
                break;
            }
            case 2: {
                if (i > 0L) {
                    if ((this.flags & 2) > 0) {
                        field2 = "+" + Long.toString(i, 10);
                        break;
                    }
                    if ((this.flags & 4) > 0) {
                        field2 = " " + Long.toString(i, 10);
                        break;
                    }
                }
                field2 = Long.toString(i, 10);
                break;
            }
            case 4: 
            case 5: {
                field2 = (this.flags & 0x10) > 0 ? "0x" + Long.toString(i, 16) : Long.toString(i, 16);
                if (this.type != 5) break;
                field2 = field2.toUpperCase();
                break;
            }
            default: {
                throw new IllegalArgumentException("Format type and add() type don't match");
            }
        }
        if (field2 != null) {
            int len = field2.length();
            if (len < this.width) {
                int missing = this.width - len;
                if ((this.flags & 1) > 0) {
                    this.padRight(field2, ' ', missing);
                } else {
                    this.padLeft(field2, (this.flags & 8) > 0 ? (char)'0' : ' ', missing);
                }
            } else {
                this.result.append(field2);
            }
        }
        this.getNextField();
        return this;
    }

    public Format add(double d) {
        String field2 = null;
        switch (this.type) {
            case 3: {
                if (d > 0.0) {
                    if ((this.flags & 2) > 0) {
                        field2 = "+" + Double.toString(d);
                        break;
                    }
                    if ((this.flags & 4) > 0) {
                        field2 = " " + Double.toString(d);
                        break;
                    }
                }
                field2 = Double.toString(d);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                this.add((int)d);
            }
            default: {
                throw new IllegalArgumentException("Format type and add() type don't match");
            }
        }
        if (field2 != null) {
            int len = field2.length();
            int fraction_len = 0;
            int point = field2.indexOf(46);
            if (point > 0) {
                fraction_len = len - point - 1;
            }
            if (this.precision >= 0 && fraction_len > this.precision) {
                field2 = field2.substring(0, len -= fraction_len - this.precision);
            }
            if (len < this.width) {
                int missing = this.width - len;
                if ((this.flags & 1) > 0) {
                    this.padRight(field2, ' ', missing);
                } else {
                    this.padLeft(field2, ' ', missing);
                }
            } else {
                this.result.append(field2);
            }
        }
        this.getNextField();
        return this;
    }

    public Format add(Number n) {
        switch (this.type) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return this.add(n.longValue());
            }
            case 3: {
                return this.add(n.doubleValue());
            }
        }
        throw new IllegalArgumentException("Format type and add() type don't match");
    }

    public Format add(String s) {
        String field2 = null;
        switch (this.type) {
            case 6: {
                field2 = s;
                break;
            }
            default: {
                throw new IllegalArgumentException("Format type and add() type don't match");
            }
        }
        if (field2 != null) {
            int len = field2.length();
            if (len < this.width) {
                int missing = this.width - len;
                if ((this.flags & 1) > 0) {
                    this.padRight(field2, ' ', missing);
                } else {
                    this.padLeft(field2, ' ', missing);
                }
            } else if (this.precision > 0 && len > this.precision) {
                this.result.append(field2.substring(0, this.precision));
            } else {
                this.result.append(field2);
            }
        }
        this.getNextField();
        return this;
    }

    void padLeft(String str, char pad, int num) {
        for (int i = 0; i < num; ++i) {
            this.result.append(pad);
        }
        this.result.append(str);
    }

    void padRight(String str, char pad, int num) {
        this.result.append(str);
        for (int i = 0; i < num; ++i) {
            this.result.append(pad);
        }
    }

    void getNextField() {
        while (this.idx < this.fmtLen) {
            char ch = this.fmt[this.idx];
            if (ch == '%' && this.idx < this.fmtLen - 1 && (ch = this.fmt[++this.idx]) != '%') {
                this.readField();
                return;
            }
            this.result.append(ch);
            ++this.idx;
        }
    }

    void readField() {
        this.flags = 0;
        this.type = 0;
        this.width = 0;
        this.precision = -1;
        char ch = '\u0000';
        while (this.idx < this.fmtLen && this.setFlag(ch = this.fmt[this.idx])) {
            ++this.idx;
        }
        while (this.idx < this.fmtLen && ch >= '0' && ch <= '9') {
            this.width = 10 * this.width + (ch - 48);
            ch = this.fmt[++this.idx];
        }
        if (this.idx < this.fmtLen && ch == '.') {
            this.precision = 0;
            ch = this.fmt[++this.idx];
            while (this.idx < this.fmtLen && ch >= '0' && ch <= '9') {
                this.precision = 10 * this.precision + (ch - 48);
                ch = this.fmt[++this.idx];
            }
        }
        switch (ch) {
            case 'c': {
                this.type = 1;
                break;
            }
            case 'd': {
                this.type = 2;
                break;
            }
            case 'f': {
                this.type = 3;
                break;
            }
            case 's': {
                this.type = 6;
                break;
            }
            case 'X': {
                this.type = 5;
                break;
            }
            case 'x': {
                this.type = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format type: " + ch);
            }
        }
        ++this.idx;
    }

    boolean setFlag(char ch) {
        switch (ch) {
            case '-': {
                this.flags |= 1;
                return true;
            }
            case '+': {
                this.flags |= 2;
                return true;
            }
            case ' ': {
                this.flags |= 4;
                return true;
            }
            case '0': {
                this.flags |= 8;
                return true;
            }
            case '#': {
                this.flags |= 0x10;
                return true;
            }
        }
        return false;
    }
}

