/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.rpc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.rpc.DominoXMLRPCServlet;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;

class XmlRpcReflect
implements XmlRpcHandler {
    private Class cls;
    private Object obj;
    private String sHandlerName;

    XmlRpcReflect(String handlerName, Object o) {
        this.obj = o;
        this.cls = o.getClass();
        this.sHandlerName = handlerName;
    }

    String htmlFunc(String f, Vector params) {
        String s = "";
        s = (String)params.elementAt(0) + " " + f + "(";
        for (int i = 1; i < params.size(); ++i) {
            if (i > 1) {
                s = s + ", ";
            }
            s = s + (String)params.elementAt(i);
        }
        s = s + ")";
        return s;
    }

    String mkHeader(String title, int fontsize, boolean bClose) {
        String s = "";
        s = s + "<TABLE WIDTH='100%' BORDER='1' cellspacing='0' cellpadding='3'> ";
        s = s + "\t<TR BGCOLOR='#CCCCFF'> ";
        s = s + "\t\t<TD WIDTH='100%' colspan=2><FONT SIZE=+" + fontsize + ">";
        s = s + title;
        s = s + "    </FONT></td></tr>";
        if (bClose) {
            s = s + "</table>";
        }
        return s;
    }

    String htmlDocument(HttpServletRequest request, HttpServletResponse resp) {
        String s = "";
        try {
            Vector sigs;
            String func;
            int i;
            String bugurl = "http://forum.gopro.net/brunnar/tickets/gpcaseticket.nsf/frmticket?OpenForm&";
            bugurl = bugurl + "product=GoPro%20XML-RPC&version=" + DominoXMLRPCServlet.Version();
            ServletOutputStream out = resp.getOutputStream();
            out.println("<html>");
            String uri = request.getRequestURI();
            String title = DominoXMLRPCServlet.VersionName() + " at " + request.getServerName() + ":" + request.getServerPort() + uri;
            out.println("<head><title>" + title + "</title></head>");
            Vector methods = this.listMethods();
            out.println(this.mkHeader(title, 3, true));
            out.println("<p>This is ");
            out.println(DominoXMLRPCServlet.VersionName() + ", version ");
            out.println(DominoXMLRPCServlet.Version() + " of ");
            out.println(DominoXMLRPCServlet.VersionDate() + " from ");
            out.println("<a href='http://www.gopro.net'>GoPro Development</a>.  ");
            out.println("Please submit a <a href='" + bugurl + "'>bug or feature</a> if you think that this product can be improved.</p>");
            out.println("<p>Information about XML-RPC implementations, specifications and communities can be found at <a href='http://www.xmlrpc.com'>xmlrpc.com</a></p>");
            out.println(this.mkHeader("Method Summary", 3, false));
            for (i = 0; i < methods.size(); ++i) {
                func = (String)methods.elementAt(i);
                sigs = this.methodSignature(func);
                if (sigs.size() == 0) continue;
                Vector sig = (Vector)sigs.elementAt(0);
                out.println("<tr><td align=right>" + (String)sig.elementAt(0) + "</td>");
                String paramlist = "";
                for (int j = 1; j < sig.size(); ++j) {
                    if (j > 1) {
                        paramlist = paramlist + ", ";
                    }
                    paramlist = paramlist + (String)sig.elementAt(j);
                }
                out.println("<td><a href=\"#" + func + "\"><b><code>" + func + "</code></b></a>(" + paramlist + ")</td></tr>");
            }
            out.println("</table><br/>");
            out.println(this.mkHeader("Method Details", 3, true));
            out.println("<br/>");
            for (i = 0; i < methods.size(); ++i) {
                func = (String)methods.elementAt(i);
                sigs = this.methodSignature(func);
                out.println("<a name=\"" + func + "\"<!-- --></a>");
                out.println("<h3>" + func + "</h3>");
                out.println("<pre>" + this.htmlFunc(func, (Vector)sigs.elementAt(0)) + "</pre>");
                out.println("<dl><dd>" + this.methodHelp(func) + "</dd></dl><hr/>");
            }
            out.println("<font size='-1'><p>");
            out.println("<p>");
            out.println("GoPro, GoPro Case and GoPro Web are trademarks or registered trademarks of ");
            out.println("<a href='http://www.gopro.net'>GoPro Development</a> in the US, Europe and other countries.</p>");
            out.println("<p>");
            out.println(DominoXMLRPCServlet.VersionCopyrightHTML());
            out.println("</p>");
            out.println("</font></html>");
        }
        catch (Exception e) {
            e.printStackTrace();
            s = e.toString();
        }
        return s;
    }

    private static String XMLRPCTypeName(Class type) {
        if (type == Integer.TYPE) {
            return "int";
        }
        if (type == String.class) {
            return "string";
        }
        if (type == Vector.class) {
            return "array";
        }
        if (type == Hashtable.class) {
            return "struct";
        }
        if (type == Boolean.TYPE) {
            return "boolean";
        }
        if (type == Double.TYPE) {
            return "double";
        }
        if (type == Date.class) {
            return "dateTime.iso8601";
        }
        if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            return "base64";
        }
        if (type == Object.class) {
            return "any";
        }
        return "unsupported type: " + type.toString();
    }

    public Vector listMethods() throws XmlRpcException {
        Method[] methods = this.cls.getMethods();
        Vector<String> v = new Vector<String>();
        v.addElement(new String("system.listMethods"));
        v.addElement(new String("system.methodHelp"));
        v.addElement(new String("system.methodSignature"));
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (m.getDeclaringClass().getName().equals("java.lang.Object") || v.contains(this.sHandlerName + "." + m.getName())) continue;
            v.addElement(this.sHandlerName + "." + m.getName());
        }
        return v;
    }

    Vector methodSignature(String methodName) throws XmlRpcException {
        Vector v = new Vector();
        if (methodName.equals("system.methodSignature")) {
            Vector<String> sig = new Vector<String>();
            sig.addElement(new String("array"));
            sig.addElement(new String("string"));
            v.addElement(sig);
            return v;
        }
        if (methodName.equals("system.methodHelp")) {
            Vector<String> sig = new Vector<String>();
            sig.addElement(new String("string"));
            sig.addElement(new String("string"));
            v.addElement(sig);
            return v;
        }
        if (methodName.equals("system.listMethods")) {
            Vector<String> sig = new Vector<String>();
            sig.addElement(new String("array"));
            v.addElement(sig);
            return v;
        }
        Method[] methods = this.cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String fullName;
            Method m = methods[i];
            if (m.getDeclaringClass().getName().equals("java.lang.Object") || !(fullName = this.sHandlerName + "." + m.getName()).equals(methodName)) continue;
            Vector<String> sig = new Vector<String>();
            sig.addElement(XmlRpcReflect.XMLRPCTypeName(m.getReturnType()));
            Class<?>[] paramTypes = m.getParameterTypes();
            for (int j = 0; j < paramTypes.length; ++j) {
                sig.addElement(XmlRpcReflect.XMLRPCTypeName(paramTypes[j]));
            }
            v.addElement(sig);
        }
        return v;
    }

    String methodHelp(String methodNameWithHandler) throws XmlRpcException {
        if (methodNameWithHandler.equals("system.methodSignature")) {
            return "Returns a array of signatures for this function or empty if the function doesn't exist.  Each function can have multiple signatures and each signature is an array, ['return type', 'param1',...,'paramN']";
        }
        if (methodNameWithHandler.equals("system.methodHelp")) {
            return "Returns a help string describing the function or empty if the function doesn't exist.  The string can contain HTML";
        }
        if (methodNameWithHandler.equals("system.listMethods")) {
            return "Returns a array of strings with the function names";
        }
        String help = "";
        String methodName = methodNameWithHandler;
        int dot = methodNameWithHandler.lastIndexOf(".");
        if (dot == -1) {
            return help;
        }
        methodName = methodNameWithHandler.substring(dot + 1);
        try {
            String helpFieldName = methodName.concat("_help");
            Field helpField = this.cls.getField(helpFieldName);
            help = (String)helpField.get(this.obj);
        }
        catch (Exception e) {
            // empty catch block
        }
        return help;
    }

    public Object execute(String method, Vector params) throws Exception {
        if (method.equals("listMethods")) {
            return this.listMethods();
        }
        if (method.equals("methodSignature")) {
            return this.methodSignature((String)params.elementAt(0));
        }
        if (method.equals("methodHelp")) {
            return this.methodHelp((String)params.elementAt(0));
        }
        throw new Exception("Unknown method " + method);
    }
}

