/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.rpc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.util.Log;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcServer;

public class TestServlet
extends HttpServlet
implements XmlRpcHandler {
    XmlRpcServer xmlrpc;

    public String echoString(String s) {
        Log.println(s);
        return s;
    }

    public Object execute(String method, Vector params) throws Exception {
        if (method.equals("echo")) {
            return params;
        }
        return null;
    }

    byte[] getInputStreamAsByteBuffer(InputStream is) {
        String s = "";
        try {
            int len;
            byte[] tmp = new byte[100];
            while ((len = is.read(tmp)) > 0) {
                s = s + new String(tmp, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s.getBytes();
    }

    public void init(ServletConfig conf) {
        try {
            Log.println("TestServlet::init");
            this.xmlrpc = new XmlRpcServer();
            this.xmlrpc.addHandler("test", (Object)this);
            Log.setDebugFile("c:\\test.log");
            super.init(conf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            Log.println(((Object)((Object)this)).getClass().getName() + "::doPost");
            byte[] inB = this.getInputStreamAsByteBuffer((InputStream)req.getInputStream());
            byte[] outB = this.xmlrpc.execute((InputStream)new ByteArrayInputStream(inB));
            resp.setContentType("text/xml");
            resp.setContentLength(outB.length);
            ServletOutputStream out = resp.getOutputStream();
            String inS = new String(inB, 0, inB.length);
            String outS = new String(outB, 0, outB.length);
            Log.println_to_file("\nInput message--------------------------\n" + inS);
            Log.println_to_file("\nOutput message-------------------------:\n" + outS);
            out.write(outB);
            out.flush();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            ServletOutputStream out = resp.getOutputStream();
            out.println("<html>");
            out.println("<h1>" + ((Object)((Object)this)).getClass().getName() + "</h1>");
            out.println("<h2>" + new Date().toString() + "</h2>");
            out.println("</html>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

