/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.rpc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.gopro.util.Log;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class SimpleCRMServer {
    Document clients;
    String filename;

    public SimpleCRMServer(String filename) {
        this.filename = filename;
        SAXBuilder builder = new SAXBuilder();
        try {
            File file = new File(filename);
            this.clients = builder.build(file);
            int port = Integer.parseInt(this.clients.getRootElement().getChild("port").getText());
            String debug = this.clients.getRootElement().getChild("debug").getText();
            boolean bDebug = false;
            if (debug.equals("true")) {
                bDebug = true;
            }
            Log.println("Attemting to start server on port " + port + "...");
            WebServer server = new WebServer(port);
            XmlRpc.setDebug((boolean)bDebug);
            Log.println("Started server on port " + port);
            server.addHandler("crm", (Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int saveClients(int wdc) {
        try {
            Log.println("saveClients in");
            XMLOutputter xo = new XMLOutputter("  ", true, "ISO-8859-1");
            xo.output(this.clients, (OutputStream)new FileOutputStream(this.filename));
            Log.println("saveClients out");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int addClient(Hashtable h) {
        try {
            Log.println("addClient in");
            Element client = new Element("client");
            this.clients.getRootElement().getChild("clients").addContent(client);
            client.setAttribute("id", String.valueOf(System.currentTimeMillis()));
            client.setAttribute("name", (String)h.get("name"));
            Element items = new Element("items");
            client.addContent(items);
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                Element item = new Element("item");
                String name = (String)e.nextElement();
                item.setAttribute("name", name);
                item.addContent((String)h.get(name));
                items.addContent(item);
            }
            this.saveClients(0);
            Log.println("addClient out");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public Vector getClients(int max) {
        Log.println("getClients in");
        Vector<String> v = new Vector<String>();
        try {
            Iterator i = this.clients.getRootElement().getChild("clients").getChildren().iterator();
            int idx = 0;
            while (i.hasNext()) {
                Element client = (Element)i.next();
                String id = client.getAttributeValue("id");
                String name = client.getAttributeValue("name");
                v.add(id + "#&#" + name);
                if (++idx < max) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.println("getClients out");
        return v;
    }

    public Hashtable getClient(String id) {
        Log.println("getClient in");
        Hashtable<String, String> h = new Hashtable<String, String>();
        boolean bFound = false;
        try {
            Iterator i = this.clients.getRootElement().getChild("clients").getChildren().iterator();
            boolean idx = false;
            while (i.hasNext()) {
                Element client = (Element)i.next();
                String tmpid = client.getAttributeValue("id");
                if (!id.equals(tmpid)) continue;
                bFound = true;
                h.put("id", id);
                for (Element e : client.getChild("items").getChildren()) {
                    h.put(e.getAttributeValue("name"), e.getText());
                }
            }
            if (!bFound) {
                h.put("Sorry", id + " not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.println("getClient out");
        return h;
    }

    public String removeClient(String id) {
        Log.println("removeClient in");
        boolean bFound = false;
        String ret = "Client " + id + " removed";
        try {
            Iterator i = this.clients.getRootElement().getChild("clients").getChildren().iterator();
            boolean idx = false;
            while (i.hasNext()) {
                Element client = (Element)i.next();
                String tmpid = client.getAttributeValue("id");
                if (!id.equals(tmpid)) continue;
                this.clients.getRootElement().getChild("clients").removeContent(client);
                bFound = true;
                break;
            }
            if (!bFound) {
                ret = "Unable to remove client " + id + ". ID not found";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.println("removeClient out");
        return ret;
    }

    public static void main(String[] args) {
        try {
            new SimpleCRMServer(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

