/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.rpc;

import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.NotesException;
import lotus.domino.NotesThread;
import net.gopro.crm.domino.Database;
import net.gopro.crm.domino.Factory;
import net.gopro.crm.domino.Session;
import net.gopro.rpc.CRMServer;
import net.gopro.rpc.DominoServer;
import net.gopro.util.Log;

public class GoProCaseDominoCRMServer
extends DominoServer
implements CRMServer {
    static String ssid = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/rpc/GoProCaseDominoCRMServer.java 2     20.09.05 9:38 Kbg $";
    private Database m_gpDb = null;
    static String DATABASE = "dev/gopro/ver2002-05-15/gpcase.nsf";
    public String getNumberOfCases_help = "Returns a the number of cases in GoPro Case that are not marked for deletion<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>Struct criteria -</code> fieldnames and values the documents should match.</dd></dl>";
    public String getNumberOfClients_help = "Returns a the number of clients in GoPro Case that are not marked for deletion<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>Struct criteria -</code> fieldnames and values the documents should match. Counts all if empty.</dd></dl>";
    public String getNumberOfContacts_help = "Returns a the number of contacts in GoPro Case that are not marked for deletion<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>Struct criteria -</code> fieldnames and values the documents should match. Counts all if empty.</dd></dl>";
    public String getDocumentByID_help = "Returns a struct for the document<dl><dt><b>Parameters:</b></dt><dd><code>int session -</code> the session id</dd><dd><code>String ID -</code> the document unique identifier within the database</dd><dd><code>Array fields -</code> an array of field names that should be included in the returned struct</dd></dl>";
    public String getGoProTitle_help = "Returns a string with the title of the database<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd></dl>";
    public String getClients_help = "Returns a array of clients, as structs, matching the criteria<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>String searchBy -</code> the lookup and return order of documents, possible values:</dd><dl><dd><code>COMPANY_NAME -</code>Lookup of companies by their names</dd><dd><code>CLIENT_CONTACT_ACCOUNTMANAGER -</code>Lookup of companies and contacts by their account manager </dd><dd><code>CLIENT_CONTACT_IDNUMBER -</code>Lookup of companies and contacts by their id-number</dd><dd><code>DOC_CREATED -</code>Lookup of all documents by their creation date </dd><dd><code>DOC_AUTHOR -</code>Lookup of all documents by their author </dd></dl><dd><code>Struct criteria or String key -</code> search criteria for the clients, with fieldnames as keys,  empty returns all</dd><dd><code>int maxReturn -</code> max number of documents to return.  Default 2147483647</dd><dd><code>int startPoint -</code> where to start in the return collection.  Default 1</dd><dd><code>array fields -</code> array of strings specifying what fields from the documents to return. If the array is empty all fields will be returned.  Default empty</dd></dl>";
    public String getContacts_help = "Returns a array of contacts, as structs, matching the criteria<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>String searchBy -</code> the lookup and return order of documents, possible values:</dd><dl><dd><code>CONTACT_NAME -</code>Lookup of contacts by their names</dd><dd><code>CONTACT_COMPANYNAME -</code>Lookup of contacts by the names of their companies</dd><dd><code>CLIENT_CONTACT_ACCOUNTMANAGER -</code>Lookup of companies and contacts by their account manager </dd><dd><code>CLIENT_CONTACT_IDNUMBER -</code>Lookup of companies and contacts by their id-number</dd><dd><code>DOC_CREATED -</code>Lookup of all documents by their creation date </dd><dd><code>DOC_AUTHOR -</code>Lookup of all documents by their author </dd></dl><dd><code>Struct criteria -</code> search criteria for the contacts, with fieldnames as keys, empty returns all</dd><dd><code>int maxReturn -</code> max number of documents to return.  Default 2147483647</dd><dd><code>int startPoint -</code> where to start in the return collection.  Default 1</dd><dd><code>array fields -</code> array of strings specifying what fields from the documents to return. If the array is empty all fields will be returned.  Default empty</dd></dl>";
    public String getCases_help = "Returns a array of cases, as structs, matching the criteria<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>String searchBy -</code> the lookup and return order of documents, possible values:</dd><dl><dd><code>CASE_NUMBER -</code>Lookup of cases by casenumber </dd><dd><code>CASE_EMPLOYEE -</code>Lookup of cases by responsible employees </dd><dd><code>CASE_TYPE -</code>Lookup of cases by casetype </dd><dd><code>CASE_STATUS -</code>Lookup of cases by status </dd><dd><code>CASE_SUBJECT -</code>Lookup of cases by their subject </dd><dd><code>CASE_CATEGORY -</code>Lookup of cases by case category </dd><dd><code>CASE_DEADLINE -</code>Lookup of cases by deadline/follow-up date </dd><dd><code>DOC_CREATED -</code>Lookup of all documents by their creation date </dd><dd><code>DOC_AUTHOR -</code>Lookup of all documents by their author </dd><dd><code>CASE_COMPANYNAME -</code>Lookup of all cases by the company name </dd></dl><dd><code>Struct criteria -</code> search criteria for the cases, with fieldnames as keys, empty returns all</dd><dd><code>int maxReturn -</code> max number of documents to return.  Default 2147483647</dd><dd><code>int startPoint -</code> where to start in the return collection.  Default 1</dd><dd><code>array fields -</code> array of strings specifying what fields from the documents to return. If the array is empty all fields will be returned.  Default empty</dd></dl>";
    public String createClient_help = "Returns a struct with the newly created document<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>struct doc -</code> struct with a #(fieldname,[[fieldvalue1],..,[fieldvalueN]]) </dd></dl>";
    public String createContact_help = "Returns a struct with the newly created document<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>struct doc -</code> struct with a #(fieldname,[[fieldvalue1],..,[fieldvalueN]]) </dd></dl>";
    public String createCase_help = "Returns a struct with the newly created document<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>struct doc -</code> struct with a #(fieldname,[[fieldvalue1],..,[fieldvalueN]]) </dd></dl>";
    public String getRelatedDocuments_help = "Returns a array of documents, as structs, that are related to this document<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>String strDocumentKey -</code> A unique key for the document</dd></dl>";
    public final String getSession_help = "Returns a int session id > 0 if the user/password is valid, otherwise -1.  NB: There is no guaranty how long this session id is valid.<dl><dt><b>Parameters:</b></dt><dd><code>String username -</code> a proper user name</dd><dd><code>String password -</code> a proper password for this user</dd></dl>";
    public String createEmail_help = "Returns a struct with the newly created document<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>String strParentID -</code> a unique ID of the document this email is related to</dd><dd><code>struct doc -</code> struct with a #(fieldname,[[fieldvalue1],..,[fieldvalueN]]) </dd></dl>";
    public String createLetter_help = "Returns a struct with the newly created document<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>String strParentID -</code> a unique ID of the document this email is related to</dd><dd><code>struct doc -</code> struct with a #(fieldname,[[fieldvalue1],..,[fieldvalueN]]) </dd></dl>";
    public String createFax_help = "Returns a struct with the newly created fax document<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>String strParentID -</code> a unique ID of the document this email is related to</dd><dd><code>struct doc -</code> struct with a #(fieldname,[[fieldvalue1],..,[fieldvalueN]]) </dd></dl>";
    public String createResponseDocument_help = "Returns a struct with the newly created responseDocument document<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>String strParentID -</code> a unique ID of the document this email is related to</dd><dd><code>struct doc -</code> struct with a #(fieldname,[[fieldvalue1],..,[fieldvalueN]]) </dd></dl>";
    public String deleteDocument_help = "Deletes a document, returns 1 if success, 0 if not<dl><dt><b>Parameters:</b></dt><dd><code>int session -</code> the session id</dd><dd><code>String strDocumentID -</code> a unique ID of the document to delete</dd></dl>";
    public String sendMail_help = "Sends a document as email to a recipient and updates its recipient field. Returns 1 if success, 0 if not<dl><dt><b>Parameters:</b></dt><dd><code>int session -</code> the session id</dd><dd><code>String documentID -</code> a unique ID of the document to be sent</dd><dd><code>array recipients -</code> an array of recipients. If empty the default recipient is the one defined in the document. </dd></dl>";
    public String markForDelete_help = "Marks a document for deletion so it disappears from all lookup. Returns 1 if success, 0 if not<dl><dt><b>Parameters:</b></dt><dd><code>int session -</code> the session id</dd><dd><code>String strDocumentID -</code> a unique ID of the document to be deleted</dd></dl>";
    public String updateDocument_help = "Updates a set of fields in a document. Refreshes the document and saves the result. Returns 1 if success, 0 if not<dl><dt><b>Parameters:</b></dt><dd><code>int sessionID -</code> the session id</dd><dd><code>String strDocumentID -</code> a unique ID of the document to be updated</dd><dd><code>struct docFields -</code> struct with fields to change and their new values, with fieldnames as keys. </dd></dl>";

    public GoProCaseDominoCRMServer(String database) throws NotesException {
        super(database);
        Log.debug_println("net.gopro.rpc.GoProCaseDominoCRMServer.Construct");
        this.m_gpDb = new Database(database);
    }

    public GoProCaseDominoCRMServer() throws NotesException {
        super(DATABASE);
        Log.debug_println("net.gopro.rpc.GoProCaseDominoCRMServer.Construct");
        this.m_gpDb = new Database(DATABASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCases(int sessionID, Hashtable criteria) {
        int res = 0;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            res = this.m_gpDb.getNumberOfCases(sessionID, "CASE_NUMBER", criteria);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfClients(int sessionID, Hashtable criteria) {
        int res = 0;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            res = this.m_gpDb.getNumberOfClients(sessionID, "COMPANY_NAME", criteria);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfContacts(int sessionID, Hashtable criteria) {
        int res = 0;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            res = this.m_gpDb.getNumberOfContacts(sessionID, "CONTACT_NAME", criteria);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDocumentByID(int session, String ID, Vector fields) {
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            h = this.m_gpDb.getDocumentByID(session, ID, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGoProTitle(int sessionID) {
        String dbTitle = new String();
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            dbTitle = this.m_gpDb.getDatabaseTitle(sessionID);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return dbTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getClients(int sessionID, String searchBy, Hashtable criteria, int maxReturn, int startPoint, Vector fields) {
        Vector vec = null;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            vec = this.m_gpDb.getClients(sessionID, searchBy, criteria, maxReturn, startPoint, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getClients(int sessionID, String searchBy, String key, int maxReturn, int startPoint, Vector fields) {
        Vector vec = null;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            vec = this.m_gpDb.getClients(sessionID, searchBy, key, maxReturn, startPoint, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return vec;
    }

    public Vector getClients(int sessionID, String searchBy, Hashtable criteria) {
        return this.getClients(sessionID, searchBy, criteria, Integer.MAX_VALUE, 1, null);
    }

    public Vector getClients(int sessionID, String searchBy, String key) {
        return this.getClients(sessionID, searchBy, key, Integer.MAX_VALUE, 1, null);
    }

    public Vector getClients(int sessionID, String searchBy, Hashtable criteria, int maxReturn) {
        return this.getClients(sessionID, searchBy, criteria, maxReturn, 1, null);
    }

    public Vector getClients(int sessionID, String searchBy, String key, int maxReturn) {
        return this.getClients(sessionID, searchBy, key, maxReturn, 1, null);
    }

    public Vector getClients(int sessionID, String searchBy, Hashtable criteria, int maxReturn, int startPoint) {
        return this.getClients(sessionID, searchBy, criteria, maxReturn, startPoint, null);
    }

    public Vector getClients(int sessionID, String searchBy, String key, int maxReturn, int startPoint) {
        return this.getClients(sessionID, searchBy, key, maxReturn, startPoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getContacts(int sessionID, String searchBy, Hashtable criteria, int maxReturn, int startPoint, Vector fields) {
        Vector vec = null;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            vec = this.m_gpDb.getContacts(sessionID, searchBy, criteria, maxReturn, startPoint, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getContacts(int sessionID, String searchBy, String key, int maxReturn, int startPoint, Vector fields) {
        Vector vec = null;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            vec = this.m_gpDb.getContacts(sessionID, searchBy, key, maxReturn, startPoint, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return vec;
    }

    public Vector getContacts(int sessionID, String searchBy, Hashtable criteria) {
        return this.getContacts(sessionID, searchBy, criteria, Integer.MAX_VALUE, 1, null);
    }

    public Vector getContacts(int sessionID, String searchBy, String key) {
        return this.getContacts(sessionID, searchBy, key, Integer.MAX_VALUE, 1, null);
    }

    public Vector getContacts(int sessionID, String searchBy, Hashtable criteria, int maxReturn) {
        return this.getContacts(sessionID, searchBy, criteria, maxReturn, 1, null);
    }

    public Vector getContacts(int sessionID, String searchBy, String key, int maxReturn) {
        return this.getContacts(sessionID, searchBy, key, maxReturn, 1, null);
    }

    public Vector getContacts(int sessionID, String searchBy, Hashtable criteria, int maxReturn, int startPoint) {
        return this.getContacts(sessionID, searchBy, criteria, maxReturn, startPoint, null);
    }

    public Vector getContacts(int sessionID, String searchBy, String key, int maxReturn, int startPoint) {
        return this.getContacts(sessionID, searchBy, key, maxReturn, startPoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getCases(int sessionID, String searchBy, Hashtable criteria, int maxReturn, int startPoint, Vector fields) {
        Vector vec = null;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            vec = this.m_gpDb.getCases(sessionID, searchBy, criteria, maxReturn, startPoint, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCases(int sessionID, String searchBy, String key, int maxReturn, int startPoint, Vector fields) {
        Vector vec = null;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            vec = this.m_gpDb.getCases(sessionID, searchBy, key, maxReturn, startPoint, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return vec;
    }

    public Vector getCases(int sessionID, String searchBy, Hashtable criteria) {
        return this.getCases(sessionID, searchBy, criteria, Integer.MAX_VALUE, 1, null);
    }

    public Vector getCases(int sessionID, String searchBy, String key) {
        return this.getCases(sessionID, searchBy, key, Integer.MAX_VALUE, 1, null);
    }

    public Vector getCases(int sessionID, String searchBy, Hashtable criteria, int maxReturn) {
        return this.getCases(sessionID, searchBy, criteria, maxReturn, 1, null);
    }

    public Vector getCases(int sessionID, String searchBy, String key, int maxReturn) {
        return this.getCases(sessionID, searchBy, key, maxReturn, 1, null);
    }

    public Vector getCases(int sessionID, String searchBy, Hashtable criteria, int maxReturn, int startPoint) {
        return this.getCases(sessionID, searchBy, criteria, maxReturn, startPoint, null);
    }

    public Vector getCases(int sessionID, String searchBy, String key, int maxReturn, int startPoint) {
        return this.getCases(sessionID, searchBy, key, maxReturn, startPoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable createClient(int session, Hashtable doc) {
        Log.debug_println("createClient");
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            h = this.m_gpDb.createClient(session, doc);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable createContact(int session, Hashtable doc) {
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            System.out.println("Contact");
            this.m_gpDb.setgpSession(this.m_gpSession);
            h = this.m_gpDb.createContact(session, doc);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable createCase(int session, Hashtable doc) {
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            h = this.m_gpDb.createCase(session, doc);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRelatedDocuments(int sessionID, String strDocumentKey) {
        Vector vec = null;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            vec = this.m_gpDb.getRelatedDocuments(sessionID, strDocumentKey);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSession(String user, String pass) {
        int iRet = -1;
        try {
            NotesThread.sinitThread();
            if (this.m_gpSession == null) {
                this.m_gpSession = (Session)Factory.createSession(null, user, pass);
            }
            iRet = this.m_gpSession.getSession(user, pass);
        }
        catch (Exception e) {
            Log.print_exception(e);
            iRet = -1;
        }
        finally {
            NotesThread.stermThread();
        }
        return iRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable createEmail(int session, String strParentID, Hashtable doc) {
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            h = this.m_gpDb.createEmail(session, strParentID, doc);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable createLetter(int session, String strParentID, Hashtable doc) {
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            h = this.m_gpDb.createLetter(session, strParentID, doc);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable createFax(int session, String strParentID, Hashtable doc) {
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            h = this.m_gpDb.createFax(session, strParentID, doc);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable createResponse(int session, String strParentID, Hashtable doc) {
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            h = this.m_gpDb.createResponseDocument(session, strParentID, doc);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteDocument(int session, String strDocumentID) {
        int res = 0;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            res = this.m_gpDb.deleteDocument(session, strDocumentID);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMail(int session, String documentID, Vector recipients) {
        int res = 0;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            res = this.m_gpDb.sendMail(session, documentID, recipients);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int markForDelete(int session, String strDocumentID) {
        int res = 0;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            res = this.m_gpDb.markForDelete(session, strDocumentID);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateDocument(int session, String strDocumentID, Hashtable docFields) {
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            h = this.m_gpDb.updateDocument(session, strDocumentID, docFields, true);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        if (h == null) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getViewResultSet(int sessionID, String view, String criteria, int maxReturn, int startPoint, int levels) {
        Vector vec = null;
        try {
            NotesThread.sinitThread();
            this.m_gpDb.setgpSession(this.m_gpSession);
            vec = this.m_gpDb.getViewEntries(sessionID, view, criteria, maxReturn, startPoint, levels);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return vec;
    }
}

