/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.rpc;

import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.rpc.DominoServer;
import net.gopro.rpc.GoProCaseDominoCRMServer;
import net.gopro.rpc.GoProWEBDominoWCMServer;
import net.gopro.rpc.XmlRpcReflect;
import net.gopro.util.Log;
import org.apache.xmlrpc.XmlRpcServer;

public class DominoXMLRPCServlet
extends HttpServlet {
    private static String ssid = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/rpc/DominoXMLRPCServlet.java 2     20.09.05 9:38 Kbg $";
    private static String the_version = "0.9.6";
    private static String the_date = "28.05.2002";
    private static String the_copyright = "Copyright (C) 2002 GoPro Development.  All rights reserved.";
    private static String the_copyright_html = "Copyright (C) 2002 <a href='http://www.gopro.net'>GoPro Development.</a>  All rights reserved.";
    private static String the_name = "GoPro XML-RPC";
    XmlRpcServer xmlrpc;
    XmlRpcReflect xrr;
    DominoServer server;

    static String VersionName() {
        return the_name;
    }

    static String Version() {
        return the_version;
    }

    static String VersionDate() {
        return the_date;
    }

    static String VersionCopyrightHTML() {
        return the_copyright_html;
    }

    public void init(ServletConfig conf) {
        try {
            String debugfile;
            String debug = conf.getInitParameter("debug");
            if (debug != null) {
                Log.setDebug(true);
            }
            if ((debugfile = conf.getInitParameter("debugfile")) != null) {
                Log.setDebug(true);
                Log.setDebugFile(debugfile);
            }
            Log.debug_println("XMLRPCServlet::init");
            this.xmlrpc = new XmlRpcServer();
            String servertype = conf.getInitParameter("servertype");
            String database = conf.getInitParameter("database");
            if (database == null) {
                throw new Exception("Missing 'database' init parameter");
            }
            if (servertype == null) {
                throw new Exception("Missing 'servertype' init parameter. It should be 'goprocase' or 'goproweb'");
            }
            String handlerName = "gopro.case";
            String handlerType = "GoPro Case";
            if (servertype.equalsIgnoreCase("goprocase")) {
                this.server = new GoProCaseDominoCRMServer(database);
            } else {
                handlerName = "gopro.web";
                handlerType = "GoPro Web";
                this.server = new GoProWEBDominoWCMServer(database);
            }
            this.xmlrpc.addHandler(handlerName, (Object)this.server);
            this.xrr = new XmlRpcReflect(handlerName, this.server);
            this.xmlrpc.addHandler("system", (Object)this.xrr);
            String msg = "\n\n";
            msg = msg + the_name + ", version " + the_version + " of " + the_date + "\n";
            msg = msg + " " + the_copyright + "\n";
            msg = msg + " Added " + handlerType + " handler '" + handlerName + "' for " + database + "\n";
            msg = msg + "\n";
            Log.println_no_stamp(msg);
            super.init(conf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            byte[] result = this.xmlrpc.execute((InputStream)req.getInputStream());
            resp.setContentType("text/xml");
            resp.setContentLength(result.length);
            ServletOutputStream out = resp.getOutputStream();
            out.write(result);
            out.flush();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            Log.debug_println("DominoXMLRPCServlet::doGet");
            resp.setContentType("text/html");
            this.xrr.htmlDocument(req, resp);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

