/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.rpc;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.NotesThread;
import lotus.domino.Session;
import lotus.domino.View;
import net.gopro.crm.domino.Case;
import net.gopro.crm.domino.Client;
import net.gopro.crm.domino.Contact;
import net.gopro.crm.domino.Email;
import net.gopro.crm.domino.Factory;
import net.gopro.crm.domino.Fax;
import net.gopro.crm.domino.Letter;
import net.gopro.crm.domino.ResponseDocument;
import net.gopro.util.Log;

public class DominoServer {
    static String ssid = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/rpc/DominoServer.java 2     20.09.05 9:38 Kbg $";
    final String GOPRO_CLIENT_VIEW_CUST = "companyFlatCust";
    final String GOPRO_CLIENT_FORM = "Company";
    private Client m_Client;
    private Contact m_Contact;
    private Case m_Case;
    private Email m_Email;
    private Letter m_Letter;
    private Fax m_Fax;
    private ResponseDocument m_Response;
    protected net.gopro.crm.domino.Session m_gpSession = null;
    private String m_Database = null;
    public final String getUserName_help = "Returns a String with the user name assosiated with the session id.  If the session id is not valid a empty string will be returned.  <dl><dt><b>Parameters:</b></dt><dd><code>int sessinID -</code> the session id returned from <a href='#getSession'>getSession</a></dd></dl>";
    public final String getSession_help = "Returns a int session id > 0 if the user/password is valid, otherwise -1.  NB: There is no guaranty how long this session id is valid.<dl><dt><b>Parameters:</b></dt><dd><code>String username -</code> a proper user name</dd><dd><code>String password -</code> a proper password for this user</dd></dl>";
    public final String echo_help = "Test function.  Returns the first parameter, which can be of any type";

    public DominoServer(String database) {
        Log.debug_println("net.gopro.rpc.DominoServer.Construct");
        this.m_Database = database;
        this.m_Client = new Client();
    }

    public DominoServer() {
        Log.debug_println("net.gopro.rpc.DominoServer.Construct");
        this.m_Database = "dev/gopro/ver2002-05-15/gpcase.nsf";
        this.m_Client = new Client();
    }

    public final String getUserName(int sessionID) throws NotesException {
        Log.debug_println("DominoServer::getUserName");
        return this.m_gpSession.getUserName(sessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSession(String user, String pass) {
        Log.debug_println("DominoServer.getSession()");
        int iRet = -1;
        try {
            NotesThread.sinitThread();
            Log.debug_println("DominoServer::getSession(" + user + "," + pass + ")");
            this.m_gpSession = (net.gopro.crm.domino.Session)Factory.createSession(null, user, pass);
            iRet = this.m_gpSession.getSession(user, pass);
        }
        catch (Exception e) {
            Log.print_exception(e);
            iRet = -1;
        }
        finally {
            NotesThread.stermThread();
        }
        return iRet;
    }

    public Object echo(Object o) {
        Log.println(this.getClass().getName() + "::echo " + o.toString());
        return new String(o.toString());
    }

    public Object echo(String o) {
        Log.println(this.getClass().getName() + "::echo " + o.toString());
        return new String(o.toString());
    }

    public String echo(Vector o) {
        Log.println(this.getClass().getName() + "::echo " + o.toString());
        return new String(o.toString());
    }

    public String echo(Hashtable o) {
        Log.println(this.getClass().getName() + "::echo " + o.toString());
        return new String(o.toString());
    }

    public String echo(int o) {
        Log.println(this.getClass().getName() + "::echo " + o);
        return new String(Integer.toString(o));
    }

    public String echo(Date o) {
        Log.println(this.getClass().getName() + "::echo " + o.toString());
        return new String(o.toString());
    }

    protected Vector getDocumentsByKey(Session session, String viewName, String formName, String criteria, int maxReturn, int startPoint, Vector fields) {
        Vector<Object> v = new Vector<Object>();
        try {
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            Log.debug_println("User " + session.getUserName());
            Log.debug_println("Server " + session.getServerName());
            Log.debug_println("Database " + this.m_Database);
            Database db = session.getDatabase(null, this.m_Database);
            Log.debug_println("Viewname " + viewName);
            View view = db.getView(viewName);
            if (view == null) {
                throw new Exception("Unable to open view " + viewName);
            }
            view.refresh();
            DocumentCollection vec = view.getAllDocumentsByKey((Object)criteria);
            int found = vec.getCount();
            Log.debug_println("found:" + found + " - Startpoint:" + startPoint);
            if (found > startPoint) {
                int idx = 0;
                if (startPoint == 0) {
                    startPoint = 1;
                }
                Document doc = vec.getNthDocument(startPoint);
                while (doc != null && idx < maxReturn) {
                    String form = doc.getItemValueString("form");
                    if (form.equalsIgnoreCase(formName)) {
                        v.addElement(this.makeDocumentHashtable(doc, fields));
                        ++idx;
                    }
                    doc = vec.getNextDocument(doc);
                }
            }
        }
        catch (Exception e) {
            v.addElement(new String(e.toString()));
            e.printStackTrace();
        }
        return v;
    }

    Hashtable makeDocumentHashtable(Document ddoc, Vector fields) throws NotesException {
        Hashtable h = new Hashtable();
        if (fields == null || fields.size() == 0) {
            Vector items = ddoc.getItems();
            for (int j = 0; j < items.size(); ++j) {
                Item item = (Item)items.elementAt(j);
                this.addItemToHash(h, item);
            }
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                String fieldName = (String)fields.elementAt(i);
                Item item = ddoc.getFirstItem(fieldName);
                if (item == null) continue;
                this.addItemToHash(h, item);
            }
        }
        return h;
    }

    void addItemToHash(Hashtable h, Item item) throws NotesException {
        if (item == null) {
            Log.debug_println("addItemToHash: null item");
            return;
        }
        if (item.getType() == 1024) {
            h.put(item.getName(), this.mkJavaDateVector(item.getValues()));
        } else {
            Vector v = new Vector();
            v = item.getValues();
            if (v != null) {
                h.put(item.getName(), v);
            }
        }
    }

    Vector mkJavaDateVector(Vector v_in) throws NotesException {
        Vector<Date> v = new Vector<Date>();
        for (int i = 0; i < v_in.size(); ++i) {
            DateTime dt = (DateTime)v_in.elementAt(i);
            v.addElement(new Date(dt.toJavaDate().getTime()));
        }
        return v;
    }

    Vector mkDateTimeVector(Session session, Vector v_in) throws NotesException {
        Vector<DateTime> v = new Vector<DateTime>();
        for (int i = 0; i < v_in.size(); ++i) {
            Date jdate = (Date)v_in.elementAt(i);
            v.addElement(session.createDateTime(jdate));
        }
        return v;
    }

    protected Hashtable createDocument(Session session, String form, Hashtable doc) {
        Log.debug_println("GoProCaseDominoCRMServer:createDocument");
        Hashtable<String, Vector> h = new Hashtable<String, Vector>();
        try {
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            Log.debug_println("User " + session.getUserName());
            Log.debug_println("Server " + session.getServerName());
            Log.debug_println("Database " + this.m_Database);
            Database db = session.getDatabase(null, this.m_Database);
            Document dominodoc = db.createDocument();
            Enumeration e = doc.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.startsWith("$")) continue;
                Vector value = (Vector)doc.get(key);
                h.put(key, value);
                Log.println("Adding field:" + key);
                if (value.size() <= 0) continue;
                if (value.elementAt(0) instanceof Date) {
                    Log.println("field is java date");
                    Vector v = this.mkDateTimeVector(session, value);
                    dominodoc.replaceItemValue(key, (Object)v);
                    continue;
                }
                dominodoc.replaceItemValue(key, (Object)value);
            }
            dominodoc.replaceItemValue("form", (Object)form);
            dominodoc.save(true);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    protected boolean updateDocument(Session session, String viewName, String docKey, Hashtable doc, boolean computeWithForm) {
        boolean result = false;
        Log.debug_println("DominoServer:updateDocument");
        try {
            Database db = session.getDatabase(null, this.m_Database);
            View docView = db.getView(viewName);
            Vector<String> key = new Vector<String>();
            key.addElement(docKey);
            Document notesDoc = docView.getDocumentByKey(key);
            Vector name = notesDoc.getItemValue("fldPageName");
            Log.debug_println("DominoServer:updateDocument, notesDoc:" + name.firstElement().toString());
            Enumeration e = doc.keys();
            while (e.hasMoreElements()) {
                String fieldEntry = (String)e.nextElement();
                Log.debug_println("The fieldEntry is " + fieldEntry);
                if (fieldEntry.startsWith("$")) continue;
                Vector value = (Vector)doc.get(fieldEntry);
                Log.debug_println("Updating field:" + fieldEntry);
                if (value.size() <= 0) continue;
                if (value.elementAt(0) instanceof Date) {
                    Log.println("field is java date");
                    Vector v = this.mkDateTimeVector(session, value);
                    notesDoc.replaceItemValue(fieldEntry, (Object)v);
                    continue;
                }
                notesDoc.replaceItemValue(fieldEntry, (Object)value);
            }
            if (computeWithForm) {
                notesDoc.computeWithForm(false, false);
            }
            result = notesDoc.save(true);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return result;
    }

    protected Session getSessionByID(int sessionID) throws NotesException {
        Log.debug_println("DominoServer:getSessionByID");
        return this.m_gpSession.getSessionByID(sessionID);
    }
}

