/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.rpc;

import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.NotesThread;
import net.gopro.crm.domino.CalendarDatabase;
import net.gopro.crm.domino.Factory;
import net.gopro.crm.domino.Session;
import net.gopro.util.Log;

public class CalendarServer {
    private Session m_gpSession = null;
    private CalendarDatabase m_calendarDatabase;
    private Hashtable calendars = new Hashtable();
    public final String getSession_help = "Returns a session id if the user name and passwords are valid and a calendar database exists for the user, otherwise -1.  NB: There is no guaranty how long this session id is valid.<dl><dt><b>Parameters:</b></dt><dd><code>String username -</code> a proper user name</dd><dd><code>String password -</code> a proper password for this user</dd></dl>";
    public String deleteEvent_help = "Deletes an event from the current users calendar, returns 1 if success, 0 if not<dl><dt><b>Parameters:</b></dt><dd><code>int session -</code> the session id</dd><dd><code>String documentID -</code> a unique ID of the document to delete</dd></dl>";
    public String updateEvent_help = "U\u00f0dates a document, refreshes and saves it, returns 1 if success, 0 if not<dl><dt><b>Parameters:</b></dt><dd><code>int session -</code> the session id</dd><dd><code>String documentID -</code> a unique ID of the document to change</dd><dd><code>Struct changes -</code> a struct with the fields to be changed and their new values, fieldnames as keys.</dd></dl>";
    public String getEventByID_help = "U\u00f0dates a document, refreshes and saves it, returns 1 if success, 0 if not<dl><dt><b>Parameters:</b></dt><dd><code>int session -</code> the session id</dd><dd><code>String documentID -</code> a unique ID of the document find</dd><dd><code>Array changes -</code> an array of filednames to return.</dd></dl>";
    public String getEventsByMonth_help = "Retrieves an arry of events in the specified month. Each event is a dictionary of fields and their values.<dl><dt><b>Parameters:</b></dt><dd><code>int session -</code> the session id</dd><dd><code>String month -</code> the month on the format mm/yyyy.</dd><dd><code>Array fileds -</code> an array of the fields that should be included in the document struct</dd></dl>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSession(String user, String pass) {
        int iRet = -1;
        try {
            NotesThread.sinitThread();
            if (this.m_gpSession == null) {
                this.m_gpSession = (Session)Factory.createSession(null, user, pass);
            }
            if ((iRet = this.m_gpSession.getSession(user, pass)) != -1) {
                CalendarDatabase calendar = new CalendarDatabase(this.m_gpSession);
                if (!calendar.isCalendarFound()) {
                    iRet = -1;
                }
                this.calendars.put(Integer.toString(iRet), calendar);
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
            iRet = -1;
        }
        finally {
            NotesThread.stermThread();
        }
        return iRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteEvent(int sessionID, String documentID) {
        int res = 0;
        try {
            NotesThread.sinitThread();
            CalendarDatabase calendar = (CalendarDatabase)this.calendars.get(Integer.toString(sessionID));
            calendar.setgpSession(this.m_gpSession);
            res = calendar.deleteEvent(sessionID, documentID);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateEvent(int sessionID, String documentID, Hashtable changes) {
        int res = 0;
        try {
            NotesThread.sinitThread();
            CalendarDatabase calendar = (CalendarDatabase)this.calendars.get(Integer.toString(sessionID));
            calendar.setgpSession(this.m_gpSession);
            res = calendar.updateEvent(sessionID, documentID, changes);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getEventByID(int sessionID, String documentID, Vector fields) {
        Hashtable h = new Hashtable();
        try {
            NotesThread.sinitThread();
            CalendarDatabase calendar = (CalendarDatabase)this.calendars.get(Integer.toString(sessionID));
            calendar.setgpSession(this.m_gpSession);
            h = calendar.getEventByID(sessionID, documentID, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getEventsByMonth(int sessionID, String month, Vector fields) {
        Vector ret = new Vector();
        try {
            NotesThread.sinitThread();
            CalendarDatabase calendar = (CalendarDatabase)this.calendars.get(Integer.toString(sessionID));
            calendar.setgpSession(this.m_gpSession);
            ret = calendar.getEventsByMonth(sessionID, month, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        finally {
            NotesThread.stermThread();
        }
        return ret;
    }
}

