/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.rpc;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.gopro.rpc.CMDLineParserThread;
import net.gopro.util.Log;
import org.apache.xmlrpc.XmlRpcClient;

public class CRMClient {
    XmlRpcClient client;
    CMDLineParserThread lpt;

    public static void main(String[] args) {
        try {
            new CRMClient(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CRMClient(String url) {
        try {
            this.client = new XmlRpcClient(url);
            this.lpt = new CMDLineParserThread(this);
            this.welcome();
            this.lpt.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cmd_getClients() {
        try {
            Vector<Integer> v = new Vector<Integer>();
            v.addElement(new Integer(100));
            Vector retv = (Vector)this.client.execute("crm.getClients", v);
            for (int i = 0; i < retv.size(); ++i) {
                System.out.println("Client " + i + " " + retv.elementAt(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cmd_getClient(String id) {
        try {
            Vector<String> v = new Vector<String>();
            v.addElement(id);
            Hashtable h = (Hashtable)this.client.execute("crm.getClient", v);
            System.out.println("======================================");
            boolean nameLength = false;
            boolean valueLength = false;
            int clientoverhead = 20;
            int total = 0;
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                int namelength = (name.length() + 3) * 2;
                String value = (String)h.get(name);
                total += namelength + value.length() + clientoverhead;
                if (value.length() > 50) {
                    value = value.substring(0, 50) + "...";
                }
                System.out.println(" " + name + ": " + value);
            }
            System.out.println(" record size (estimate) " + total + " bytes");
            System.out.println("======================================");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cmd_removeClient(String id) {
        try {
            Vector<String> v = new Vector<String>();
            v.addElement(id);
            String s = (String)this.client.execute("crm.removeClient", v);
            Log.println("removeClient: " + s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cmd_exit() {
        this.lpt.stopThread();
    }

    public void cmd_addClient() {
        try {
            Hashtable<String, String> h = new Hashtable<String, String>();
            BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
            String s = "";
            System.out.flush();
            System.out.println("======================================");
            System.out.print("    Name: ");
            s = d.readLine();
            h.put("name", s);
            System.out.print(" Address: ");
            s = d.readLine();
            h.put("address", s);
            System.out.print("   Phone: ");
            s = d.readLine();
            h.put("phone", s);
            System.out.print("   Email: ");
            s = d.readLine();
            h.put("email", s);
            System.out.println("======================================");
            Vector<Hashtable<String, String>> v = new Vector<Hashtable<String, String>>();
            v.addElement(h);
            Integer i = (Integer)this.client.execute("crm.addClient", v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void cmd_help() {
        String msg = "";
        msg = msg + "EXIT                     Exit server \n";
        msg = msg + "HELP                     Help (Displays this help information)\n";
        msg = msg + "GETCLIENTS               Gets all the clients\n";
        msg = msg + "GETCLIENT id             Gets a client with this id\n";
        msg = msg + "ADDCLIENT                Add a client\n";
        msg = msg + "REMOVECLIENT             Remove a client\n";
        System.out.println(msg);
    }

    void welcome() {
        String msg = "";
        msg = msg + "Welcome to the CRM test client.\n";
        System.out.println(msg);
    }
}

