/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.writers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.LinkedList;
import net.gopro.gdr.Base64;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Writer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class URLWriter
extends Writer {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/writers/URLWriter.java 1     23.06.03 15:18 Kbg $";
    private static String[][] paramInfo = new String[][]{{"url", "default empty, mandatory, the URL to write to."}, {"user", "default empty, optional, the username for the session"}, {"password", "default empty, optional, the password for the session"}, {"method", " default XML, mandatory, there are two possibilities:<ul><li>XML The document will be sent, URLEncoded as post data to the url.</li><li>PARAMETERS All the items will be sent as a name=value pairs as post data to the url.</li></ul>"}, {"successreply", "default empty, optional, specifies the reply from the url upon success. If this is specified an error is raised if this string isn not replied from the url,and the document will be put back into the que"}, {"maxretries", "default 10, optional, specifies the number of retries when read/write fails"}, {"readretriesdelay", "default 100, optional, specifies the number of milliseconds to wait before retrying to read from the url"}, {"writeretriesdelay", "default 100, optional, specifies the number of milliseconds to wait before retrying to write to the url"}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public URLWriter() {
        this.parameters.putString("url", "");
        this.parameters.putString("user", "");
        this.parameters.putString("password", "");
        this.parameters.putString("method", "XML");
        this.parameters.putString("successreply", "");
        this.parameters.putInt("maxretries", 10);
        this.parameters.putInt("readretriesdelay", 100);
        this.parameters.putInt("writeretriesdelay", 100);
    }

    @Override
    public String getType() {
        return "URLWriter";
    }

    @Override
    public int write(Document d) {
        LinkedList l = new LinkedList();
        try {
            String stype = this.parameters.getString("method");
            String surl = this.parameters.getString("url");
            if (this.parameters.getString("p1", null) != null) {
                surl = this.parameters.getParametricString(surl);
            }
            this.router.getLog().info(this.getType() + this.getName() + " writing to " + surl);
            String msg = "";
            String authorization = null;
            if (this.parameters.getString("user").length() > 0) {
                String user = this.parameters.getString("user");
                String pass = this.parameters.getString("password");
                String s = user + ":" + pass;
                String s1 = new String(Base64.encode(s.getBytes("UTF-8")));
                authorization = "Basic " + s1;
            }
            if (stype.equalsIgnoreCase("XML")) {
                this.router.getLog().debug("sendig XML doc");
                StringWriter sw = new StringWriter();
                XMLOutputter putter = IO.makeXMLOutputter(this);
                putter.output(d, (java.io.Writer)sw);
                msg = URLEncoder.encode(sw.toString());
            } else if (stype.equalsIgnoreCase("PARAMETERS")) {
                this.router.getLog().debug("sendig parameters");
                Element items = d.getRootElement().getChild("items");
                if (items == null) {
                    throw new Exception(this.getType() + "." + this.getName() + " ERROR: Missing <items>");
                }
                for (Element e : items.getChildren()) {
                    String name = e.getAttributeValue("name");
                    String value = e.getText();
                    msg = msg + name + "=" + URLEncoder.encode(value) + "&";
                    this.router.getLog().debug(msg);
                }
            } else {
                throw new Exception(this.getType() + "." + this.getName() + " ERROR: unsupported method '" + stype + "'");
            }
            if (msg.length() == 0) {
                this.router.getLog().info(this.getType() + "." + this.getName() + " Nothing to write!");
                return 0;
            }
            int retries = this.parameters.getInt("maxretries");
            if (retries < 0) {
                retries = 10;
            }
            boolean bWritingDone = false;
            boolean bReadingDone = false;
            while (retries > 0) {
                try {
                    String inputLine;
                    URL url = new URL(surl);
                    URLConnection urlc = url.openConnection();
                    urlc.setDoOutput(true);
                    if (authorization != null) {
                        urlc.setRequestProperty("Authorization", authorization);
                    }
                    if (!bWritingDone) {
                        PrintWriter out = new PrintWriter(urlc.getOutputStream());
                        out.println(msg);
                        out.close();
                        bWritingDone = true;
                        this.router.getLog().info(this.getType() + this.getName() + " done writing to " + surl);
                    }
                    if (bReadingDone) continue;
                    BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
                    String msgIn = "";
                    while ((inputLine = in.readLine()) != null) {
                        msgIn = msgIn + inputLine;
                    }
                    in.close();
                    bReadingDone = true;
                    this.router.getLog().info(this.getType() + "." + this.getName() + " url '" + url + "' returns '" + msgIn + "'");
                    String success = this.parameters.getString("successreply");
                    if (success.length() > 0) {
                        if (success.equals(msgIn)) {
                            return 0;
                        }
                        this.router.getLog().info(this.getType() + "." + this.getName() + " expected '" + success + "'");
                        return 1;
                    }
                    break;
                }
                catch (Exception e) {
                    this.router.getLog().error(e);
                    String what = bWritingDone ? "reading" : "writing";
                    this.router.getLog().info(this.getType() + "." + this.getName() + " I'll try " + what + " again " + retries + " times");
                    if (retries > 1) {
                        int nSleep = bWritingDone ? this.parameters.getInt("readretriesdelay") : this.parameters.getInt("writeretriesdelay");
                        this.router.getLog().info("Sleeping for " + nSleep + "ms");
                        Thread.sleep(nSleep);
                    }
                    --retries;
                }
            }
            if (!bReadingDone || !bWritingDone) {
                return 1;
            }
            return 0;
        }
        catch (Exception ne) {
            this.setError("writing", ne);
            this.router.getLog().error(ne);
            return 1;
        }
    }

    public static String getDescription() {
        return "The URLWriter writes the incoming document to a URL and waits for an answer which can be used to determine wheter or not the action was a success. ";
    }

    public static String getDocumentDesc() {
        return "The incoming document is written directly to the url.  There are no special format requirements for the document.";
    }
}

