/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.writers;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Writer;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class SocketWriter
extends Writer {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/writers/SocketWriter.java 1     23.06.03 15:18 Kbg $";
    private Socket socket = null;
    private BufferedReader in;
    int port = 5850;
    String host = "localhost";
    private static String[][] paramInfo = new String[][]{{"host", "default 127.0.0.1, mandatory, the host used."}, {"port", "default 5850, mandatory, the port number used. Make sure that this port is open to the machine which is going to send documents"}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public SocketWriter() {
        this.parameters.putInt("port", 5850);
        this.parameters.putString("host", "127.0.0.1");
    }

    @Override
    public void init() {
        this.port = this.parameters.getInt("port", 5850);
        this.host = this.parameters.getString("host", "localhost");
    }

    @Override
    public String getType() {
        return "SocketWriter";
    }

    @Override
    public int write(Document d) {
        try {
            this.router.getLog().info(this.getType() + " writing to " + this.host + ":" + this.port);
            this.socket = new Socket(this.host, this.port);
            XMLOutputter xmlout = IO.makeXMLOutputter(this);
            xmlout.output(d, this.socket.getOutputStream());
            this.socket.close();
            return 0;
        }
        catch (IOException e) {
            this.setError("writing", e);
            this.router.getLog().error((Exception)e);
            return 1;
        }
    }

    public static String getDescription() {
        return "The SocketWriter is a special writer which sends the incoming document through a socket connection to a specific port on a server. SocketWriter comes paired with a SocketReader.  The pair is able to send documents over TCPIP allowing other programs to send the router some documents to process and for other instances of the router to share documents. ";
    }

    public static String getDocumentDesc() {
        return "This writer sends all incoming documents to the host.";
    }
}

