/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.writers;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Writer;
import org.jdom.Document;
import org.jdom.Element;

public class JavaSMTPMailWriter
extends Writer {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/writers/JavaSMTPMailWriter.java 2     20.09.05 9:38 Kbg $";
    String to;
    String subject;
    String from;
    String cc;
    String bcc;
    String body;
    String host = "";
    private static String[][] paramInfo = new String[][]{{"host", "default 127.0.0.1, mandatory, name of the host with the SMTP gateway"}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public JavaSMTPMailWriter() {
        this.parameters.putString("host", "127.0.0.1");
    }

    String noNull(Element e) {
        if (e != null) {
            return e.getText();
        }
        return "";
    }

    @Override
    public void init() {
        super.init();
        this.host = this.parameters.getString("host");
    }

    void setMailFields(Document d) throws Exception {
        this.to = "";
        this.subject = "";
        this.from = "";
        this.cc = "";
        this.bcc = "";
        this.body = "";
        for (Element item : d.getRootElement().getChild("items").getChildren()) {
            String name = item.getAttributeValue("name");
            if (name.equalsIgnoreCase("to")) {
                this.to = item.getText();
                continue;
            }
            if (name.equalsIgnoreCase("subject")) {
                this.subject = item.getText();
                continue;
            }
            if (name.equalsIgnoreCase("from")) {
                this.from = item.getText();
                continue;
            }
            if (name.equalsIgnoreCase("cc")) {
                this.cc = item.getText();
                continue;
            }
            if (name.equalsIgnoreCase("bcc")) {
                this.bcc = item.getText();
                continue;
            }
            if (!name.equalsIgnoreCase("body")) continue;
            this.body = item.getText();
        }
        if (this.to.equals("") && this.cc.equals("") && this.bcc.equals("")) {
            throw new Exception("Missing 'to', 'cc' or 'bcc' field in document");
        }
    }

    @Override
    public String getType() {
        return "JavaSMTPMailWriter";
    }

    @Override
    public int write(Document d) {
        try {
            this.setMailFields(d);
            this.host = this.parameters.getString("host", this.host);
            Properties props = System.getProperties();
            props.put("mail.smtp.host", this.host);
            Session session = Session.getDefaultInstance((Properties)props, null);
            if (this.router.getLog().getLevel() == 0) {
                session.setDebug(true);
            }
            MimeMessage msg = new MimeMessage(session);
            if (!this.from.equals("")) {
                msg.setFrom((Address)new InternetAddress(this.from));
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
            if (!this.cc.equals("")) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cc, (boolean)false));
            }
            if (!this.bcc.equals("")) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.bcc, (boolean)false));
            }
            msg.setSubject(this.subject);
            msg.setText(this.body);
            msg.setHeader("X-Mailer", "GoPro XML Router");
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            return 0;
        }
        catch (Exception e) {
            this.setError("writing", e);
            this.router.getLog().error(e);
            return 1;
        }
    }

    public static String getDescription() {
        return "The JavaSMTPMailWriter sends email using SMTP";
    }

    public static String getDocumentDesc() {
        return "The incoming document must hava a <code>/document/items</code> element with <code>/document/items/item</code> elements with the following attributes: <br><ul><li><code>to</code> with the email address of the recipiend<li><code>cc</code> with the cc email address, optional<li><code>bcc</code> with the bcc email address, optional<li><code>from</code> with the from field in the email<li><code>subject</code> with the subject of the email<li><code>body</code> with name content of the email message</ul><br><h3>Example incoming document</h3><code>&lt?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?&gt;<br>" + JavaSMTPMailWriter.htmlTag("document") + "<br>" + JavaSMTPMailWriter.htmlSpace(3) + JavaSMTPMailWriter.htmlTag("items") + "<br>" + JavaSMTPMailWriter.htmlSpace(6) + "&lt;item name=\\\"to\\\"&gt;kf@gopro.net" + JavaSMTPMailWriter.htmlTag("/item") + "<br>" + JavaSMTPMailWriter.htmlSpace(6) + "&lt;item name=\\\"cc\\\"&gt;cc@gopro.net" + JavaSMTPMailWriter.htmlTag("/item") + "<br>" + JavaSMTPMailWriter.htmlSpace(6) + "&lt;item name=\\\"bcc\\\"&gt;bcc@gopro.net" + JavaSMTPMailWriter.htmlTag("/item") + "<br>" + JavaSMTPMailWriter.htmlSpace(6) + "&lt;item name=\\\"from\\\"&gt;Kristjan Finnsson" + JavaSMTPMailWriter.htmlTag("/item") + "<br>" + JavaSMTPMailWriter.htmlSpace(6) + "&lt;item name=\\\"subject\\\"&gt;News from UK" + JavaSMTPMailWriter.htmlTag("/item") + "<br>" + JavaSMTPMailWriter.htmlSpace(6) + "&lt;item name=\\\"body\\\"&gt;UK is still in Europe" + JavaSMTPMailWriter.htmlTag("/item") + "<br>" + JavaSMTPMailWriter.htmlSpace(3) + JavaSMTPMailWriter.htmlTag("/items") + "<br>" + JavaSMTPMailWriter.htmlTag("/document");
    }
}

