/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.writers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import net.gopro.gdr.Writer;
import org.jdom.Document;
import org.jdom.Element;

public class JDBCWriter
extends Writer {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/writers/JDBCWriter.java 2     20.09.05 9:38 Kbg $";
    private String last_driver = "";
    private static String[][] paramInfo = new String[][]{{"jdbc_driver", "default empty, mandatory The JDBC class used. For example: use COM.ibm.db2.jdbc.app.DB2 for DB2 and sun.jdbc.odbc.JdbcOdbcDriver for Sun jdbc/odbc bridge"}, {"jdbc_url", "default emtpy, mandatory, datasource to use with the driver. For example jdbc:odbc:NameOfDatasource when using the jdbc/odbc bridge"}, {"jdbc_user", "default empty, optional, the username for the JDBC session"}, {"jdbc_password", "default empty, optional, the password for the JDBC session"}, {"statement_insert", "Optional, the insert statement"}, {"statement_update", "Optional, the update statement"}, {"statement_lookup", "Optional, the select statement to the check if record exists"}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public JDBCWriter() {
        this.parameters.putString("jdbc_driver", "sun.jdbc.odbc.JdbcOdbcDriver");
        this.parameters.putString("jdbc_url", "jdbc:odbc:MyDatabase");
        this.parameters.putString("jdbc_user", "admin");
        this.parameters.putString("jdbc_password", "MyPassword");
        this.parameters.putString("statement_insert", "insert into MyTable (field1,field2) values({MyField1},{MyField2})");
        this.parameters.putString("statement_update", "update MyTable set field1={MyField1},field2={MyField2} where key={MyKey1}");
        this.parameters.putString("statement_lookup", "select keyfield from MyTable where keyfield={MyField1}");
    }

    @Override
    public String getType() {
        return "JDBCWriter";
    }

    @Override
    public int write(Document d) {
        try {
            String driver = this.parameters.getString("jdbc_driver");
            if (!this.last_driver.equals(driver)) {
                Class.forName(driver);
                this.last_driver = driver;
            }
            String url = this.parameters.getString("jdbc_url");
            String user = this.parameters.getString("jdbc_user");
            String pass = this.parameters.getString("jdbc_password");
            Connection con = DriverManager.getConnection(url, user, pass);
            String action = this.parameters.getString("action").toLowerCase();
            boolean is_update = action.equals("updateonly");
            if (is_update || action.equals("both")) {
                String s = this.parameters.getString("statement_lookup");
                PreparedStatement pstmt = this.prepareStatement(con, s, d);
                ResultSet rs = pstmt.executeQuery();
                boolean b = rs.next();
                rs.close();
                pstmt.close();
                if (is_update && !b) {
                    return 0;
                }
                is_update = b;
            }
            String type = is_update ? "update" : "insert";
            String statement = this.parameters.getString("statement_" + type);
            if (this.parameters.getString("p1", null) != null) {
                statement = this.parameters.getParametricString(statement);
            }
            PreparedStatement pstmt = this.prepareStatement(con, statement, d);
            pstmt.executeUpdate();
            pstmt.close();
            this.router.getLog().info(this.getName() + ":" + this.getType() + ":" + url);
            return 0;
        }
        catch (Exception e) {
            this.setError("writing", e);
            this.router.getLog().error(e);
            return 1;
        }
    }

    private final PreparedStatement prepareStatement(Connection conn, String statement, Document doc) {
        try {
            int p3;
            Element root = doc.getRootElement().getChild("items");
            StringBuffer s = new StringBuffer(statement.length() * 2);
            Vector<String> v = new Vector<String>();
            int p1 = 0;
            int p2 = statement.indexOf(123);
            while (p2 != -1 && (p3 = statement.indexOf(125, p2 + 1)) != -1) {
                String name = statement.substring(p2 + 1, p3);
                v.addElement(name);
                s.append(statement.substring(p1, p2));
                s.append('?');
                p1 = p3 + 1;
                p2 = statement.indexOf(123, p1);
            }
            s.append(statement.substring(p1));
            PreparedStatement stmt = conn.prepareStatement(s.toString());
            Enumeration e = v.elements();
            int i = 1;
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = null;
                for (Element f : root.getChildren()) {
                    String n = f.getAttributeValue("name");
                    if (!n.equalsIgnoreCase(name)) continue;
                    value = f.getText();
                    break;
                }
                stmt.setString(i++, value);
            }
            return stmt;
        }
        catch (Exception e) {
            this.setError("creating statement", e);
            this.router.getLog().error(e);
            return null;
        }
    }

    public static String getDescription() {
        return "The JDBCWriter writes data to any JDBC/ODBC compliant datasource.  The insert/update statement can contain ?'s which will be replaced by items with index numbers that correspond to the ?.  For example if the statement is like: <br><center><code>  INSERT INTO EMPLOYEES(EMPNO,FIRSTNME,LASTNAME) VALUES(?,'?','?')</code></center>and the incoming document is like:<br><code>" + JDBCWriter.htmlTag("document") + "<br>" + JDBCWriter.htmlSpace(3) + JDBCWriter.htmlTag("items") + "<br>" + JDBCWriter.htmlSpace(6) + "&lt;item index=\\\"1\\\" name=\\\"EMPNO\\\" type=\\\"CHAR\\\"&gt;000340" + JDBCWriter.htmlTag("/item") + "<br>" + JDBCWriter.htmlSpace(6) + "&lt;item index=\\\"2\\\" name=\\\"FIRSTNAME\\\" type=\\\"VARCHAR\\\"&gt;Jason" + JDBCWriter.htmlTag("/item") + "<br>" + JDBCWriter.htmlSpace(6) + "&lt;item index=\\\"3\\\" name=\\\"LASTNAME\\\" type=\\\"VARCHAR\\\"&gt;Roberts" + JDBCWriter.htmlTag("/item") + "<br>" + JDBCWriter.htmlSpace(3) + JDBCWriter.htmlTag("/items") + "<br>" + JDBCWriter.htmlTag("/document") + "</code><br>" + "then the actual insert statement will be:" + "<center><code>INSERT INTO EMPLOYEES(EMPNO,FIRSTNME," + "LASTNAME) VALUES(340,'Jason','Roberts')" + "</code></center>";
    }

    public static String getDocumentDesc() {
        return "The incoming document should contain a <code>/document/items</code> section identical to the one JDBCReader returns.<h3>Example incoming document</h3>" + Reader.getStandardDocument("JDBCReader", "EmployeeReader", false) + "<br>" + JDBCWriter.htmlSpace(3) + "<code>&lt;items&gt;<br>" + JDBCWriter.htmlSpace(6) + "&lt;item index=\\\"1\\\" name=\\\"EMPNO\\\" type=\\\"CHAR\\\"&gt;000340" + JDBCWriter.htmlTag("/item") + "<br>" + JDBCWriter.htmlSpace(6) + "&lt;item index=\\\"2\\\" name=\\\"FIRSTNAME\\\" type=\\\"VARCHAR\\\"&gt;Jason" + JDBCWriter.htmlTag("/item") + "<br>" + JDBCWriter.htmlSpace(6) + "&lt;item index=\\\"3\\\" name=\\\"LASTNAME\\\" type=\\\"VARCHAR\\\"&gt;Roberts" + JDBCWriter.htmlTag("/item") + "<br>" + JDBCWriter.htmlSpace(3) + "&lt;/items&gt;<br>" + "&lt;/document&gt;</code><br>";
    }
}

