/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.writers;

import is.hugvit.bird.BirdServiceProxy;
import is.hugvit.io.ByteArrayInputStreamEx;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.io.InputStreamDataSource;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import net.gopro.gdr.Base64;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Router;
import net.gopro.gdr.Writer;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.messaging.MessageHandler;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public final class GPWWriter
extends Writer {
    private List list = new ArrayList();
    private static final TransformerFactory tranfactory = TransformerFactory.newInstance();
    private static final boolean TEST = false;
    private static String[][] paramInfo = new String[][]{{"url", "default empty, mandatory The URL for the web service"}, {"xsl_pdf_url", "default empty, Specifies url for a custom XSL transformation for PDF, if none specified then an internal one is used"}, {"external_parameters", "XML file descriping all the external parameters required for this Writer"}};

    public GPWWriter() {
        this.parameters.putString("url", "http://myserver/bird/services/bird");
        StringBuffer s = new StringBuffer(1024);
        s.append("<input label=\"Tegund\" name=\"gpw:type\" type=\"select\">\r\n");
        s.append("<option value=\"location=Folder1\\Folder2;pagetype=News\">Fr\u00e9ttir</option>\r\n");
        s.append("</input>\r\n");
        this.parameters.putString("external_parameters", s.toString());
    }

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    @Override
    public final String getType() {
        return "GPWWriter";
    }

    public static String getDescription() {
        return "This writer writes to a GoProWeb Service";
    }

    public static String getDocumentDesc() {
        return "The format is the GDF format";
    }

    private static final void addDocumentAttachments(Element doc, Map h) throws Exception {
        for (Element e : doc.getChildren("attachment")) {
            String cid = e.getAttributeValue("cid");
            String mime = e.getAttributeValue("mime");
            String filename = e.getAttributeValue("filename");
            String surl = e.getAttributeValue("url");
            String content = e.getText();
            if (surl != null) {
                URL url = new URL(surl);
                if (filename == null) {
                    filename = Util.getFilename((URL)url);
                    e.setAttribute("filename", filename);
                }
                if (cid == null) {
                    cid = filename;
                    e.setAttribute("cid", cid);
                }
                URLDataSource ds = new URLDataSource(url);
                h.put(cid, ds);
                e.removeAttribute("url");
                continue;
            }
            if (content.equals("")) continue;
            byte[] b = Base64.decode(content.toCharArray());
            ByteArrayInputStream in = new ByteArrayInputStream(b);
            InputStreamDataSource ds = new InputStreamDataSource((InputStream)in, mime, filename);
            h.put(cid, ds);
            e.setText(null);
        }
    }

    private static final void addTemporaryAttachments(Element root, Map h) throws MalformedURLException {
        for (Element att : root.getChildren("attachment")) {
            String cid = att.getAttributeValue("cid");
            String url = att.getAttributeValue("url");
            URL u = new URL(url);
            File file = new File(u.getPath());
            FileDataSource ds = new FileDataSource(file);
            h.put(cid, ds);
        }
        root.removeChildren("attachment");
    }

    private static final Element getItem(Element doc, String name) {
        for (Element item : doc.getChildren("item")) {
            String n = item.getAttributeValue("name");
            if (n == null || !n.equals(name)) continue;
            return item;
        }
        return null;
    }

    private static final String getValue(Element doc, String name) {
        Element item = GPWWriter.getItem(doc, name);
        if (item != null) {
            Element e = item.getChild("text");
            if (e == null) {
                e = item.getChild("textlist").getChild("text");
            }
            return e.getText();
        }
        return "";
    }

    private static final File extractFile(DataSource ds, File dir) throws Exception {
        if (ds instanceof FileDataSource) {
            FileDataSource fds = (FileDataSource)ds;
            return fds.getFile();
        }
        if (ds instanceof URLDataSource) {
            URLDataSource uds = (URLDataSource)ds;
            URL url = uds.getURL();
        }
        File file = new File(dir, UID.getUID());
        FileOutputStream out = new FileOutputStream(file);
        InputStream in = ds.getInputStream();
        Util.writeStream((InputStream)in, (OutputStream)out);
        out.close();
        return file;
    }

    private static final void extractAttachments(List list, Element e, Map h, File dir) throws Exception {
        String[] att = new String[]{"src", "href"};
        for (Element tag : e.getChildren()) {
            for (int j = 0; j < att.length; ++j) {
                String cid;
                DataSource ds;
                String s = tag.getAttributeValue(att[j], "");
                if (!s.startsWith("cid:") || (ds = (DataSource)h.get(cid = s.substring(4))) == null) continue;
                h.remove(cid);
                if (tag.getName().equals("a")) break;
                File file = GPWWriter.extractFile(ds, dir);
                list.add(file);
                tag.setAttribute(att[j], file.getName());
                break;
            }
            GPWWriter.extractAttachments(list, tag, h, dir);
        }
    }

    private static final void generatePDF(Element doc, Map h, File dir, String pdf_url) throws Exception {
        InputStream in;
        InputStream gdf_fop;
        System.out.println("GPWWriter.generatePDF");
        Configuration.put((String)"baseDir", (Object)dir.getAbsolutePath());
        ByteArrayOutputStreamEx xml_out = new ByteArrayOutputStreamEx(4096);
        XMLOutputter xml_outputter = new XMLOutputter();
        xml_outputter.output(doc, (OutputStream)xml_out);
        Driver driver = new Driver();
        ByteArrayOutputStreamEx pdf_out = new ByteArrayOutputStreamEx(4096);
        ConsoleLogger log = new ConsoleLogger(2);
        MessageHandler.setScreenLogger((Logger)log);
        driver.setLogger((Logger)log);
        driver.setOutputStream((OutputStream)pdf_out);
        driver.setRenderer(1);
        if (!pdf_url.equals("")) {
            URL url = new URL(pdf_url);
            gdf_fop = url.openStream();
        } else {
            gdf_fop = GPWWriter.class.getResourceAsStream("gdf_fop.xsl");
            String[] names = new String[]{"_hugvit_header.gif", "_hugvit_footer.gif"};
            for (int i = 0; i < names.length; ++i) {
                in = GPWWriter.class.getResourceAsStream(names[i]);
                FileOutputStream out = new FileOutputStream(new File(dir, names[i]));
                Util.writeStream((InputStream)in, (OutputStream)out);
                ((OutputStream)out).close();
                in.close();
            }
        }
        Transformer transformer = tranfactory.newTransformer(new StreamSource(gdf_fop));
        StreamSource xmlsource = new StreamSource((InputStream)new ByteArrayInputStreamEx(xml_out));
        transformer.transform(xmlsource, new SAXResult(driver.getContentHandler()));
        in = new ByteArrayInputStreamEx(pdf_out);
        String cid = UID.getUID();
        String filename = "pdf_file.pdf";
        InputStreamDataSource ds = new InputStreamDataSource(in, "application/pdf", filename);
        h.put(cid, ds);
        Element att = new Element("attachment");
        att.setAttribute("cid", cid);
        att.setAttribute("filename", filename);
        doc.addContent(att);
    }

    private static final void ProcessDocument(Router router, Element doc, Map h, String pdf_url) throws Exception {
        GPWWriter.addDocumentAttachments(doc, h);
        String value = GPWWriter.getValue(doc, "gpw:format");
        if (value.equals("pdf")) {
            Element html;
            File dir = new File(router.getWebRoot(), "WEB-INF/attachments");
            Element item = GPWWriter.getItem(doc, "body");
            if (item != null && (html = item.getChild("html")) != null) {
                ArrayList list = new ArrayList();
                GPWWriter.extractAttachments(list, html, h, dir);
                GPWWriter.generatePDF(doc, h, dir, pdf_url);
                for (File file : list) {
                    file.delete();
                }
            }
        }
    }

    @Override
    public final int write(Document document) {
        try {
            System.out.println("GPWWriter.write");
            String pdf_url = this.parameters.getString("xsl_pdf_url");
            if (pdf_url == null) {
                pdf_url = "";
            }
            HashMap h = new HashMap();
            Element root = document.getRootElement();
            GPWWriter.addTemporaryAttachments(root, h);
            for (Element doc : root.getChildren("document")) {
                System.out.println("GPWWriter.processDocument");
                GPWWriter.ProcessDocument(this.getRouter(), doc, h, pdf_url);
            }
            String url = this.parameters.getString("url");
            BirdServiceProxy s = new BirdServiceProxy(url);
            for (String cid : h.keySet()) {
                DataSource ds = (DataSource)h.get(cid);
                s.addAttachment(cid, ds);
            }
            XMLOutputter xo = new XMLOutputter();
            String xml = xo.outputString(document);
            s.createPage(xml);
        }
        catch (Exception e) {
            this.setError("writing", e);
            this.router.getLog().error(e);
            return 1;
        }
        return 0;
    }
}

