/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.LinkedList;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Writer;
import net.gopro.gdr.writers.FOPLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.messaging.MessageHandler;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;

public class FOPWriter
extends Writer {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/writers/FOPWriter.java 2     20.09.05 9:38 Kbg $";
    private static String[][] paramInfo = new String[][]{{"outputfilename", "fop", "default fop, mandatory.  The base name of the output file.  A number will be added to it to make sure it will be unique.  The name will be returned in the document to later use if returned to the router."}, {"render-to-pdf", "true", "default true, optional.  If specified, document of this type will be created"}, {"render-to-mif", "false", "default false, optional.  If specified, document of this type will be created"}, {"render-to-pcl", "false", "default false, optional.  If specified, document of this type will be created"}, {"render-to-ps", "false", "default false, optional.  If specified, document of this type will be created"}, {"render-to-txt", "false", "default false, optional.  If specified, document of this type will be created"}, {"render-to-svg", "false", "default false, optional.  If specified, document of this type will be created"}};
    private static Object[][] actions = new Object[][]{{"render-to-pdf", "pdf", new Integer(1)}, {"render-to-mif", "mif", new Integer(3)}, {"render-to-pcl", "pcl", new Integer(6)}, {"render-to-ps", "ps", new Integer(7)}, {"render-to-txt", "txt", new Integer(8)}, {"render-to-svg", "svg", new Integer(9)}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][2]);
            h.put(name, p);
        }
        return h;
    }

    public FOPWriter() {
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            String value = paramInfo[i][1];
            this.parameters.putString(name, value);
        }
    }

    @Override
    public String getType() {
        return "FOPWriter";
    }

    @Override
    public int write(Document doc) {
        LinkedList l = new LinkedList();
        try {
            this.router.getLog().debug(this.getName() + ":" + "FOPWriter.write");
            XMLOutputter outputter = new XMLOutputter();
            String tmpdoc = outputter.outputString(doc);
            Driver driver = new Driver();
            FOPLogger logger = new FOPLogger(this.router.getLog());
            MessageHandler.setScreenLogger((Logger)logger);
            driver.setLogger((Logger)logger);
            Element fopfiles = new Element("fopfiles");
            int docCount = 0;
            String uniq = "" + System.currentTimeMillis();
            for (int i = 0; i < actions.length; ++i) {
                String sRenderer = (String)actions[i][0];
                if (!this.parameters.getBoolean(sRenderer, false)) continue;
                int iRenderType = (Integer)actions[i][2];
                String sRenderType = (String)actions[i][1];
                try {
                    this.router.getLog().info(this.getName() + ":Rendering document to " + sRenderType);
                    driver.setRenderer(iRenderType);
                    String filename = this.mkOutputName(sRenderType, uniq);
                    FileOutputStream fos = new FileOutputStream(filename);
                    StringReader sr = new StringReader(tmpdoc);
                    InputSource is = new InputSource(sr);
                    driver.setInputSource(is);
                    driver.setOutputStream((OutputStream)fos);
                    driver.run();
                    Element fopfile = new Element("fopfile");
                    fopfile.setAttribute("name", filename);
                    fopfile.setAttribute("type", sRenderType);
                    fopfiles.addContent(fopfile);
                    ++docCount;
                    continue;
                }
                catch (Exception e1) {
                    this.setError(sRenderType, e1);
                    this.router.getLog().error(this.getName() + ":Error while rendering " + sRenderType, e1);
                }
            }
            if (docCount > 0) {
                doc.getRootElement().addContent(fopfiles);
            }
            return 0;
        }
        catch (Exception ne) {
            this.setError("fop file", ne);
            this.router.getLog().error(ne);
            return 1;
        }
    }

    private String mkOutputName(String sRenderType, String uniq) {
        String base = this.parameters.getString("outputfilename", "fop");
        if (base == null) {
            base = "fop";
        }
        String name = this.getRouter().getWebRoot() + "tmp" + File.separatorChar + base + "-" + uniq + "." + sRenderType;
        return name;
    }

    public static String getDescription() {
        return "The FOPWriter uses Apache-FOP to create PDF, PS, TXT etc. documnents.";
    }

    public static String getDocumentDesc() {
        return "The incoming document is must apply with the FOP standard";
    }
}

