/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.writers;

import java.util.Hashtable;
import lotus.domino.Database;
import lotus.domino.NotesException;
import lotus.domino.View;
import net.gopro.gdr.DominoHelper;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.writers.DominoNOPWriter;
import org.jdom.Document;
import org.jdom.Element;

public class DominoWriter
extends DominoNOPWriter {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/writers/DominoWriter.java 1     23.06.03 15:19 Kbg $";
    private static String[][] paramInfo = new String[][]{{"database", "default empty, mandatory, the database"}, {"computewithform", "default false, optional, if specified then the form is evaluated upon save"}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    @Override
    public String getType() {
        return "DominoWriter";
    }

    @Override
    public int write(Document d) {
        try {
            boolean i = false;
            boolean bComputeWithForm = false;
            this.router.getLog().debug(this.getName() + ":starting");
            if (this.parameters == null) {
                this.router.getLog().debug(this.getName() + ":parameters==null");
            } else {
                bComputeWithForm = this.parameters.getBoolean("computewithform", false);
            }
            if (!this.dh.checkConnection()) {
                return 0;
            }
            Database db = this.dh.getDatabase();
            if (db == null) {
                this.router.getLog().error(this.getName() + ":Unable to get database handle");
                this.setError("writing", "unable to get database handle");
                return 0;
            }
            Element root = d.getRootElement();
            Element eunid = root.getChild("unid");
            Element keyview = root.getChild("viewname");
            Element key = root.getChild("viewkey");
            String skeyview = null;
            String skey = null;
            if (keyview != null && key != null) {
                skeyview = keyview.getText();
                skey = key.getText();
            }
            lotus.domino.Document ddoc = null;
            boolean bCreateNewDoc = true;
            this.router.getLog().debug(this.getName() + ":Action = " + this.getAction());
            if (this.getAction() != 2 && skeyview != null && skey != null) {
                this.router.getLog().debug(this.getName() + ":!CREATEONLY & (skeyview != null && skey != null");
                View view = db.getView(skeyview);
                view.refresh();
                ddoc = view.getDocumentByKey((Object)skey);
                if (ddoc != null) {
                    bCreateNewDoc = false;
                    this.router.getLog().debug(this.getName() + ":Found note in view " + ddoc.getNoteID());
                } else {
                    this.router.getLog().debug(this.getName() + ":Didn't find note in view");
                }
            } else if (this.getAction() != 2 && eunid != null) {
                this.router.getLog().debug(this.getName() + ":!=CREATEONLY & eunid!=null");
                String sunid = eunid.getText();
                try {
                    ddoc = db.getDocumentByUNID(sunid);
                    bCreateNewDoc = false;
                    this.router.getLog().debug(this.getName() + ":Updating note " + sunid);
                }
                catch (NotesException ne) {
                    bCreateNewDoc = true;
                    this.router.getLog().debug(this.getName() + ":Cant find note " + sunid);
                }
            }
            if (bCreateNewDoc) {
                this.router.getLog().debug(this.getName() + ":Creating a new note");
                if (this.getAction() == 1) {
                    this.router.getLog().warn(this.getName() + ":Have to create a new doc, but action==updateonly");
                    return 0;
                }
                Element eform = root.getChild("form");
                if (eform == null) {
                    this.router.getLog().error(this.getName() + ":Notes document without form name");
                    this.setError("writing", "Notes document without a form name");
                    return 0;
                }
                ddoc = db.createDocument();
                ddoc.replaceItemValue("form", (Object)eform.getText());
            } else {
                this.router.getLog().debug(this.getName() + ":Document was found");
                if (this.getAction() == 2) {
                    this.router.getLog().debug(this.getName() + ":Found doc, but action==createonly");
                    return 0;
                }
            }
            DominoHelper.updateFromJDOMDocument(ddoc, d);
            if (bComputeWithForm) {
                boolean b = ddoc.computeWithForm(false, false);
            }
            ddoc.save(true);
            return 0;
        }
        catch (NotesException ne) {
            this.setError("writing", ne.text);
            this.router.getLog().error(this.getName() + ":" + ne.text, (Exception)((Object)ne));
        }
        catch (Exception e) {
            this.setError("writing", e);
            this.router.getLog().error(e);
        }
        return 1;
    }

    public static String getDescription() {
        return "The DominoWriter creates and updates documents in a Lotus Domino database.  Currently it supports creation of main documents but it can update both main and response documents.";
    }

    public static String getDocumentDesc() {
        return "The incoming document must include some fields to help locate it in the Lotus Domino , along with a <code>/document/items</code> section identical  to the one returned by DominoViewReader and DominoSearchReader.<br>DominoWriter uses the folowing fields in the incoming document:<br><ul><li><code>/document/form</code> with name of the form this document belongs to.<li><code>/document/viewname</code> If specified it will try to find the document using this view and the <code>/document/viewkey</code>.<li><code>document/viewkey</code> with value to find in the view.<li><code>/document/unid</code> with the unique id of the document.  If specified and no <code>/document/viewname</code> is specified, DominoWriter opens a document with this id. </ul><h3>Example incoming document</h3><code>&lt?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?&gt;<br>" + DominoWriter.htmlTag("document") + "<br>" + DominoWriter.htmlSpace(3) + DominoWriter.htmlTag("unid") + "CC79D5F6BD3DB70900256A99004961FB" + DominoWriter.htmlTag("/unid") + "<br>" + DominoWriter.htmlSpace(3) + DominoWriter.htmlTag("items") + "<br>" + DominoWriter.htmlSpace(6) + "&lt;item name=\\\"textfield\\\" type=\\\"TEXT\\\"&gt;text in field" + DominoWriter.htmlTag("/item") + "<br>" + DominoWriter.htmlSpace(6) + "&lt;item name=\\\"numberfield\\\" type=\\\"NUMBER\\\"&gt;3.14159" + DominoWriter.htmlTag("/item") + "<br>" + DominoWriter.htmlSpace(6) + "&lt;item name=\\\"datefield\\\" type=\\\"DATE\\\"&gt;01.08.2001 16:44:56 GMT" + DominoWriter.htmlTag("/item") + "<br>" + DominoWriter.htmlSpace(3) + DominoWriter.htmlTag("/items") + "<br>" + DominoWriter.htmlTag("/document");
    }
}

