/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.writers;

import lotus.domino.Database;
import lotus.domino.NotesException;
import net.gopro.gdr.writers.DominoNOPWriter;
import org.jdom.Document;
import org.jdom.Element;

public class DominoMailWriter
extends DominoNOPWriter {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/writers/DominoMailWriter.java 2     20.09.05 9:38 Kbg $";
    String to = "";
    String subject = "";
    String from = "";
    String cc = "";
    String bcc = "";
    String body = "";

    @Override
    public String getType() {
        return "DominoMailWriter";
    }

    void setMailFields(Document d) throws Exception {
        this.to = "";
        this.subject = "";
        this.from = "";
        this.cc = "";
        this.bcc = "";
        this.body = "";
        for (Element item : d.getRootElement().getChild("items").getChildren()) {
            String name = item.getAttributeValue("name");
            if (name.equalsIgnoreCase("to")) {
                this.to = item.getText();
                continue;
            }
            if (name.equalsIgnoreCase("subject")) {
                this.subject = item.getText();
                continue;
            }
            if (name.equalsIgnoreCase("from")) {
                this.from = item.getText();
                continue;
            }
            if (name.equalsIgnoreCase("cc")) {
                this.cc = item.getText();
                continue;
            }
            if (name.equalsIgnoreCase("bcc")) {
                this.bcc = item.getText();
                continue;
            }
            if (!name.equalsIgnoreCase("body")) continue;
            this.body = item.getText();
        }
        if (this.to.equals("") && this.cc.equals("") && this.bcc.equals("")) {
            throw new Exception("Missing 'to', 'cc' or 'bcc' field in document");
        }
    }

    @Override
    public int write(Document d) {
        try {
            if (!this.dh.checkConnection()) {
                return 0;
            }
            Database db = this.dh.getDatabase();
            this.setMailFields(d);
            lotus.domino.Document memo = db.createDocument();
            memo.appendItemValue("Form", (Object)"Memo");
            memo.appendItemValue("Subject", (Object)this.subject);
            memo.appendItemValue("Body", (Object)this.body);
            memo.appendItemValue("blindcopyto", (Object)this.bcc);
            memo.appendItemValue("copyto", (Object)this.cc);
            memo.setSaveMessageOnSend(true);
            memo.send(false, this.to);
            return 0;
        }
        catch (NotesException ne) {
            this.setError("writing", ne.text);
            this.router.getLog().error((Exception)((Object)ne));
        }
        catch (Exception e) {
            this.setError("writing", e);
            this.router.getLog().error(e);
        }
        return 1;
    }

    public static String getDescription() {
        return "The DominoViewReader sends email via Lotus Domino<br><h3>Incoming document</h3>The incoming document must hava a <code>/document/items</code> element with <code>/document/items/item</code> elements with the following attributes: <br><ul><li><code>to</code> with the email address of the recipiend<li><code>cc</code> with the cc email address, optional<li><code>bcc</code> with the bcc email address, optional<li><code>from</code> with the from field in the email<li><code>subject</code> with the subject of the email<li><code>body</code> with name content of the email message</ul>";
    }

    public static String getDocumentDesc() {
        return "<code>&lt?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?&gt;<br>" + DominoMailWriter.htmlTag("document") + "<br>" + DominoMailWriter.htmlSpace(3) + DominoMailWriter.htmlTag("items") + "<br>" + DominoMailWriter.htmlSpace(6) + "&lt;item name=\\\"to\\\"&gt;kf@gopro.net" + DominoMailWriter.htmlTag("/item") + "<br>" + DominoMailWriter.htmlSpace(6) + "&lt;item name=\\\"cc\\\"&gt;cc@gopro.net" + DominoMailWriter.htmlTag("/item") + "<br>" + DominoMailWriter.htmlSpace(6) + "&lt;item name=\\\"bcc\\\"&gt;bcc@gopro.net" + DominoMailWriter.htmlTag("/item") + "<br>" + DominoMailWriter.htmlSpace(6) + "&lt;item name=\\\"from\\\"&gt;Kristjan Finnsson" + DominoMailWriter.htmlTag("/item") + "<br>" + DominoMailWriter.htmlSpace(6) + "&lt;item name=\\\"subject\\\"&gt;News from UK" + DominoMailWriter.htmlTag("/item") + "<br>" + DominoMailWriter.htmlSpace(6) + "&lt;item name=\\\"body\\\"&gt;UK is still in Europe" + DominoMailWriter.htmlTag("/item") + "<br>" + DominoMailWriter.htmlSpace(3) + DominoMailWriter.htmlTag("/items") + "<br>" + DominoMailWriter.htmlTag("/document");
    }
}

