/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import net.gopro.gdr.Base64;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class URLReader
extends Reader {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/readers/URLReader.java 1     23.06.03 15:19 Kbg $";
    private static String[][] paramInfo = new String[][]{{"url", "default empty, mandatory, the URL to read from. This can be any legal url, starting with http: or file "}, {"user", "default empty, optional, the username for the session"}, {"password", "default empty, optional, the password for the session"}, {"properxml", "default true, mandatory, if specified the URL is assumed to return a proper XML document and will be returned as such. If not it will be put into a new document as CDATA."}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public URLReader() {
        this.parameters.putString("url", "");
        this.parameters.putString("user", "");
        this.parameters.putString("password", "");
        this.parameters.putBoolean("properxml", true);
    }

    @Override
    public String getType() {
        return "URLReader";
    }

    @Override
    public List read() {
        LinkedList<Document> l = new LinkedList<Document>();
        try {
            boolean bProperXML;
            String surl = this.parameters.getString("url");
            if (surl == null || "".equals(surl)) {
                this.setError("validating url", "missing 'url' parameter");
                return l;
            }
            if (this.parameters.getString("p1", null) != null) {
                surl = this.parameters.getParametricString(surl);
            }
            this.router.getLog().info(this.getType() + ":" + surl);
            URL url = new URL(surl);
            URLConnection urlc = url.openConnection();
            if (this.parameters.getString("user") != "") {
                String user = this.parameters.getString("user");
                String pass = this.parameters.getString("password");
                String s = user + ":" + pass;
                String s1 = new String(Base64.encode(s.getBytes("UTF-8")));
                String authorization = "Basic " + s1;
                urlc.setRequestProperty("Authorization", authorization);
            }
            Document d = (bProperXML = this.parameters.getBoolean("properxml", false)) ? this.buildProperXMLDoc(urlc.getInputStream()) : this.buildEmbeddedDoc(urlc.getInputStream(), surl);
            l.add(d);
        }
        catch (Exception ne) {
            this.setError("reading", ne);
            this.router.getLog().error(ne);
        }
        return l;
    }

    Document buildProperXMLDoc(InputStream is) {
        try {
            String xmldecl;
            String line = "";
            String xml = "";
            boolean bOmitEncoding = this.parameters.getBoolean("xmlomitencoding", false);
            String encoding = this.parameters.getString("xmlencoding", "ISO-8859-1");
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                xml = xml + line;
            }
            xml.trim();
            if (xml.startsWith("<?") && !bOmitEncoding && (xmldecl = xml.substring(0, xml.indexOf("?>") + 2)).indexOf("encoding") == -1) {
                xmldecl = xmldecl.substring(0, xmldecl.indexOf("?>"));
                xmldecl = xmldecl + " encoding=\"" + encoding + "\"?>";
            }
            SAXBuilder builder = new SAXBuilder();
            return builder.build((java.io.Reader)new StringReader(xml));
        }
        catch (Exception e) {
            this.setError("creating xml doc", e);
            this.router.getLog().error(e);
            return null;
        }
    }

    Document buildEmbeddedDoc(InputStream is, String surl) {
        try {
            String line;
            Document doc = IO.makeXMLDocument(this);
            Element root = doc.getRootElement();
            root.addContent(new Element("url").setText(surl));
            Element urldata = new Element("urldata");
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String s = "";
            while ((line = in.readLine()) != null) {
                s = s + line + "\n";
            }
            urldata.addContent(new CDATA(s));
            root.addContent(urldata);
            return doc;
        }
        catch (Exception e) {
            this.setError("building embedded doc", e);
            this.router.getLog().error(e);
            return null;
        }
    }

    public static String getDescription() {
        return "The URLReader reads data from a URL, whether or not it is a proper XML document and returns it to the router que.";
    }

    public static String getDocumentDesc() {
        return "When <code>properxml</code> is true, the document is returned as it is received.  If not a return document with the return of the url embedded as a CDATA is returned: <br>" + URLReader.getStandardDocument("URLReader", "(to be defined)", false) + "<br><code>" + URLReader.htmlSpace(3) + URLReader.htmlTag("url") + "http://www.someurl.com" + URLReader.htmlTag("/url") + "<br>" + URLReader.htmlSpace(3) + URLReader.htmlTag("urldata") + "&lt![CDATA[ <br>" + URLReader.htmlSpace(6) + "   .. <br>" + URLReader.htmlSpace(6) + "   The Data returned from the url<br>" + URLReader.htmlSpace(6) + "   ..<br>" + URLReader.htmlSpace(3) + "   ]]&gt;" + URLReader.htmlTag("/urldata") + "<br>" + URLReader.htmlTag("/document") + "</code>";
    }
}

