/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import net.gopro.gdr.Base64;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class TxtFixedWidthReader
extends Reader {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/readers/TxtFixedWidthReader.java 3     24.05.04 13:36 Kbg $";
    private static String[][] paramInfo = new String[][]{{"url", "default empty, mandatory, the URL to read from. This can be any legal url, starting with http: or file "}, {"user", "default empty, optional, the username for the session"}, {"password", "default empty, optional, the password for the session"}, {"fields", "default empty, mandatory, the fields and width for chopping down the text file The format is:<br></code>" + TxtFixedWidthReader.htmlTag("fields") + "<br>" + TxtFixedWidthReader.htmlSpace(3) + "&lt;field name=\\\"field1\\\" begin=\\\"0\\\" length=\\\"10\\\"/&gt;<br>" + TxtFixedWidthReader.htmlSpace(3) + "&lt;field name=\\\"field2\\\" begin=\\\"10\\\" length=\\\"10\\\"/&gt;<br>" + TxtFixedWidthReader.htmlSpace(3) + "&lt;field name=\\\"field3\\\" begin=\\\"20\\\" length=\\\"10\\\"/&gt;<br>" + TxtFixedWidthReader.htmlSpace(3) + "...<br>" + TxtFixedWidthReader.htmlSpace(3) + "&lt;field name=\\\"field4\\\" begin=\\\"30\\\" length=\\\"10\\\"/&gt;<br>" + TxtFixedWidthReader.htmlTag("/fields") + "</code>"}};
    Vector vFields = null;

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public TxtFixedWidthReader() {
        StringBuffer s = new StringBuffer(128);
        s.append("<fields>\r\n");
        s.append("<field name=\"MyField1\" begin=\"0\" length=\"10\"/>\r\n");
        s.append("<field name=\"MyField2\" begin=\"10\" length=\"10\"/>\r\n");
        s.append("</fields>\r\n");
        this.parameters.putString("fields", s.toString());
    }

    @Override
    public void init() {
        try {
            String fields = this.parameters.getString("fields");
            StringReader sr = new StringReader(fields);
            SAXBuilder builder = new SAXBuilder();
            Document d = builder.build((java.io.Reader)sr);
            this.vFields = new Vector();
            Iterator i = d.getRootElement().getChildren().iterator();
            while (i != null && i.hasNext()) {
                Element e = (Element)i.next();
                String name = e.getAttributeValue("name");
                int begin = Integer.parseInt(e.getAttributeValue("begin"));
                int length = Integer.parseInt(e.getAttributeValue("length"));
                this.vFields.addElement(new field(name, begin, length));
            }
        }
        catch (Exception e) {
            this.setError("parsing field list", e);
            this.router.getLog().error(e);
        }
    }

    @Override
    public String getType() {
        return "TxtFixedWidthReader";
    }

    @Override
    public List read() {
        LinkedList l = new LinkedList();
        try {
            String surl = this.parameters.getString("url");
            if (surl == null || "".equals(surl)) {
                this.setError("validating url", "missing 'url' parameter");
                return l;
            }
            if (this.parameters.getString("p1", null) != null) {
                surl = this.parameters.getParametricString(surl);
            }
            this.router.getLog().debug(this.getType() + ":" + surl);
            URL url = new URL(surl);
            URLConnection urlc = url.openConnection();
            if (this.parameters.getString("user") != "") {
                String user = this.parameters.getString("user");
                String pass = this.parameters.getString("password");
                String s = user + ":" + pass;
                String s1 = new String(Base64.encode(s.getBytes("UTF-8")));
                String authorization = "Basic " + s1;
                urlc.setRequestProperty("Authorization", authorization);
            }
            return this.buildDocuments(urlc.getInputStream(), surl, l);
        }
        catch (Exception ne) {
            this.setError("reading", ne);
            this.router.getLog().error(ne);
            return l;
        }
    }

    List buildDocuments(InputStream is, String surl, List l) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String s = "";
            int idx = 0;
            int maxRet = this.parameters.getInt("maxreturn", Integer.MAX_VALUE);
            while ((line = in.readLine()) != null && idx < maxRet) {
                if (line.equals("")) continue;
                Document doc = IO.makeXMLDocument(this);
                Element root = doc.getRootElement();
                Element items = new Element("items");
                items.setAttribute("line", Integer.toString(idx));
                root.addContent(items);
                for (int i = 0; i < this.vFields.size(); ++i) {
                    field f = (field)this.vFields.elementAt(i);
                    if (f.begin >= line.length()) continue;
                    Element item = new Element("item");
                    item.setAttribute("name", f.name);
                    item.setAttribute("type", "TEXT");
                    String value = "BAD INDEX!";
                    try {
                        value = line.substring(f.begin, f.begin + f.length);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.setError("bad index in " + f.name, e);
                    }
                    item.setText(value);
                    items.addContent(item);
                }
                ++idx;
                l.add(doc);
            }
            return l;
        }
        catch (Exception e) {
            this.setError("building embedded doc", e);
            this.router.getLog().error(e);
            return null;
        }
    }

    public static String getDescription() {
        return "The TxtFixedWidthReader reads data from a URL, parses it into an XML document and returns it to the router que.";
    }

    public static String getDocumentDesc() {
        return TxtFixedWidthReader.getStandardDocument("TxtFixedWidthReader", "(to be defined)", false) + "<br><code>" + TxtFixedWidthReader.htmlSpace(3) + TxtFixedWidthReader.htmlTag("items") + "<br>" + TxtFixedWidthReader.htmlSpace(6) + "&lt;item name=\\\"name\\\" type=\\\"TEXT\\\"&gt;Bob Jones" + TxtFixedWidthReader.htmlTag("/item") + "<br>" + TxtFixedWidthReader.htmlSpace(6) + "&lt;item name=\\\"address\\\" type=\\\"TEXT\\\"&gt;Evergreen Fields 1" + TxtFixedWidthReader.htmlTag("/item") + "<br>" + TxtFixedWidthReader.htmlSpace(6) + "&lt;item name=\\\"phone\\\" type=\\\"TEXT\\\"&gt;555-1271" + TxtFixedWidthReader.htmlTag("/item") + "<br>" + TxtFixedWidthReader.htmlSpace(3) + TxtFixedWidthReader.htmlTag("/items") + "<br>" + TxtFixedWidthReader.htmlTag("/document") + "</code>";
    }

    class field {
        public String name;
        public int begin;
        public int length;

        public field(String name, int begin, int length) {
            this.name = name;
            this.begin = begin;
            this.length = length;
        }
    }
}

