/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import net.gopro.gdr.Base64;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class TxtDelimitedReader
extends Reader {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/readers/TxtDelimitedReader.java 2     25.09.03 11:08 Kbg $";
    private static String[][] paramInfo = new String[][]{{"url", "default empty, mandatory, the URL to read from. This can be any legal url, starting with http: or file "}, {"user", "default empty, optional, the username for the session"}, {"password", "default empty, optional, the password for the session"}, {"delimiter", "default \";\", optional, the delimiter to use."}, {"fields", "default empty, mandatory, the fields and number for chopping down the text file The format is:<br><code>" + TxtDelimitedReader.htmlTag("fields") + "<br>" + TxtDelimitedReader.htmlSpace(3) + "&lt;field name=\\\"field1\\\" number=\\\"0\\\"/&gt;<br>" + TxtDelimitedReader.htmlSpace(3) + "&lt;field name=\\\"field2\\\" number=\\\"1\\\"/&gt;<br>" + TxtDelimitedReader.htmlSpace(3) + "&lt;field name=\\\"field3\\\" number=\\\"2\\\"/&gt;<br>" + TxtDelimitedReader.htmlSpace(3) + "...<br>" + TxtDelimitedReader.htmlSpace(3) + "&lt;field name=\\\"field4\\\" number=\\\"3\\\"/&gt;<br>" + TxtDelimitedReader.htmlTag("/fields") + "</code>"}};
    Vector vFields = null;

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public TxtDelimitedReader() {
        StringBuffer s = new StringBuffer(128);
        s.append("<fields>\r\n");
        s.append("<field name=\"MyField1\" number=\"0\"/>\r\n");
        s.append("<field name=\"MyField2\" number=\"1\"/>\r\n");
        s.append("</fields>\r\n");
        this.parameters.putString("fields", s.toString());
    }

    @Override
    public void init() {
        try {
            String fields = this.parameters.getString("fields");
            StringReader sr = new StringReader(fields);
            SAXBuilder builder = new SAXBuilder();
            Document d = builder.build((java.io.Reader)sr);
            this.vFields = new Vector();
            Iterator i = d.getRootElement().getChildren().iterator();
            int n = 0;
            while (i != null && i.hasNext()) {
                Element e = (Element)i.next();
                String name = e.getAttributeValue("name");
                int number = n++;
                String s = e.getAttributeValue("number");
                if (s != null && !s.equals("")) {
                    number = Integer.parseInt(s);
                }
                this.vFields.addElement(new field(name, number));
            }
        }
        catch (Exception e) {
            this.setError("parsing field list", e);
            this.router.getLog().error(e);
        }
    }

    @Override
    public String getType() {
        return "TxtDelimitedReader";
    }

    @Override
    public List read() {
        this.init();
        LinkedList l = new LinkedList();
        try {
            String surl = this.parameters.getString("url");
            if (surl == null || "".equals(surl)) {
                this.setError("validating url", "missing 'url' parameter");
                return l;
            }
            if (this.parameters.getString("p1", null) != null) {
                surl = this.parameters.getParametricString(surl);
            }
            this.router.getLog().debug(this.getType() + ":" + surl);
            URL url = new URL(surl);
            URLConnection urlc = url.openConnection();
            if (this.parameters.getString("user") != "") {
                String user = this.parameters.getString("user");
                String pass = this.parameters.getString("password");
                String s = user + ":" + pass;
                String s1 = new String(Base64.encode(s.getBytes("UTF-8")));
                String authorization = "Basic " + s1;
                urlc.setRequestProperty("Authorization", authorization);
            }
            return this.buildDocuments(urlc.getInputStream(), surl, l);
        }
        catch (Exception ne) {
            this.setError("reading", ne);
            this.router.getLog().error(ne);
            return l;
        }
    }

    List buildDocuments(InputStream is, String surl, List l) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String s = "";
            int idx = 0;
            int maxRet = this.parameters.getInt("maxreturn", Integer.MAX_VALUE);
            String strDelimiter = this.parameters.getString("delimiter", ";");
            while ((line = in.readLine()) != null && idx < maxRet) {
                if (line.equals("")) continue;
                Vector<String> vec = new Vector<String>();
                StringTokenizer st = new StringTokenizer(line, strDelimiter);
                while (st.hasMoreTokens()) {
                    vec.addElement(st.nextToken());
                }
                Document doc = IO.makeXMLDocument(this);
                Element root = doc.getRootElement();
                Element items = new Element("items");
                items.setAttribute("line", Integer.toString(idx));
                root.addContent(items);
                for (int i = 0; i < this.vFields.size(); ++i) {
                    field f = (field)this.vFields.elementAt(i);
                    if (f.number >= vec.size()) continue;
                    Element item = new Element("item");
                    item.setAttribute("name", f.name);
                    item.setAttribute("type", "TEXT");
                    String value = "BAD INDEX!";
                    try {
                        value = (String)vec.elementAt(f.number);
                    }
                    catch (Exception e) {
                        this.setError("bad index in " + f.name, e);
                    }
                    item.setText(value);
                    items.addContent(item);
                }
                ++idx;
                l.add(doc);
            }
            return l;
        }
        catch (Exception e) {
            this.setError("building embedded doc", e);
            this.router.getLog().error(e);
            return null;
        }
    }

    public static String getDescription() {
        return "The TxtDelimitedReader reads data from a URL, parses it into an XML document and returns it to the router que.";
    }

    public static String getDocumentDesc() {
        return TxtDelimitedReader.getStandardDocument("TxtDelimitedReader", "(to be defined)", false) + "<br><code>" + TxtDelimitedReader.htmlSpace(3) + TxtDelimitedReader.htmlTag("items") + "<br>" + TxtDelimitedReader.htmlSpace(6) + "&lt;item name=\\\"name\\\" type=\\\"TEXT\\\"&gt;Bob Jones" + TxtDelimitedReader.htmlTag("/item") + "<br>" + TxtDelimitedReader.htmlSpace(6) + "&lt;item name=\\\"address\\\" type=\\\"TEXT\\\"&gt;Evergreen Fields 1" + TxtDelimitedReader.htmlTag("/item") + "<br>" + TxtDelimitedReader.htmlSpace(6) + "&lt;item name=\\\"phone\\\" type=\\\"TEXT\\\"&gt;555-1271" + TxtDelimitedReader.htmlTag("/item") + "<br>" + TxtDelimitedReader.htmlSpace(3) + TxtDelimitedReader.htmlTag("/items") + "<br>" + TxtDelimitedReader.htmlTag("/document") + "</code>";
    }

    class field {
        public String name;
        public int number;

        public field(String name, int number) {
            this.name = name;
            this.number = number;
        }
    }
}

