/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.gopro.gdr.readers.SocketReader;
import net.gopro.gdr.readers.SocketWorkerThread;

class SocketWorker
extends Thread {
    ServerSocket ss;
    public SocketReader sr;
    volatile boolean run_thread;
    int port;

    SocketWorker(SocketReader io, int port) {
        super("SocketWorker");
        this.sr = io;
        this.port = port;
        try {
            this.ss = new ServerSocket(port);
        }
        catch (IOException e) {
            this.sr.setError("creating socket " + port, e);
            io.getRouter().getLog().error((Exception)e);
        }
    }

    public boolean isExiting() {
        return !this.run_thread;
    }

    public SocketReader getSocketReader() {
        return this.sr;
    }

    public void stopThread() {
        this.run_thread = false;
        try {
            this.sr.getRouter().getLog().info("Closing socket");
            Socket socket = new Socket("localhost", this.port);
            socket.close();
        }
        catch (IOException e) {
            this.sr.setError("closing socket", e);
            this.sr.getRouter().getLog().error((Exception)e);
        }
    }

    @Override
    public void run() {
        try {
            this.run_thread = true;
            while (this.run_thread) {
                new SocketWorkerThread(this, this.ss.accept()).start();
            }
        }
        catch (IOException e) {
            this.sr.setError("accepting connection", e);
            this.sr.getRouter().getLog().error((Exception)e);
        }
    }
}

