/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import net.gopro.gdr.readers.SocketWorker;
import org.jdom.Document;

public class SocketReader
extends Reader {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/readers/SocketReader.java 1     23.06.03 15:19 Kbg $";
    SocketWorker sw;
    LinkedList l;
    private static String[][] paramInfo = new String[][]{{"port", "default 5850, mandatory, the port number used. Make sure that this port is open to the machine which is going to send documents"}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public SocketReader() {
        this.parameters.putInt("port", 5850);
    }

    synchronized void put(Document d) {
        this.l.addFirst(d);
    }

    synchronized Document get() {
        if (this.l.size() > 0) {
            Document d = (Document)this.l.removeLast();
            return d;
        }
        return null;
    }

    @Override
    public void init() {
        this.l = new LinkedList();
        int port = this.parameters.getInt("port");
        this.router.getLog().info(this.getType() + " listening on port " + port);
        this.sw = new SocketWorker(this, port);
        this.sw.start();
    }

    @Override
    public void term() {
        this.sw.stopThread();
    }

    @Override
    public String getType() {
        return "SocketReader";
    }

    @Override
    public List read() {
        LinkedList<Document> l = new LinkedList<Document>();
        try {
            Document d;
            while ((d = this.get()) != null) {
                l.add(d);
            }
        }
        catch (Exception ne) {
            this.setError("reading", ne);
            this.router.getLog().error(ne);
        }
        return l;
    }

    public static String getDescription() {
        return "The SocketReader is a special reader which comes paired with a SocketWriter.  The pair is able to send documents over TCPIP allowing other programs to send the router some documents to process and for other instances of the router to share documents.";
    }

    public static String getDocumentDesc() {
        return "There is no actual return document. The document received is put into the document que in the router";
    }
}

