/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.AndTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class MailReader
extends Reader {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/readers/MailReader.java 3     20.09.05 9:38 Kbg $";
    final int IMAP = 1;
    final int POP3 = 2;
    int iProtocol = 1;
    String sHost = "localhost";
    String sUser;
    String sPassword;
    String sProtocol = "imap";
    String sMoveToFolder;
    String sCopyToFolder;
    String sFolder;
    int iPort;
    static int level = 0;
    static int attnum = 0;
    boolean bSaveAttachments = false;
    boolean bGetRawContent = false;
    boolean bGetRawContentAsXML = false;
    boolean bGetBodyAsXML = false;
    String sSearchSubject = null;
    String sSearchFrom = null;
    boolean bReverseOrder = false;
    private static String[][] paramInfo = new String[][]{{"host", "localhost", "default localhost, mandatory, the host to read from"}, {"user", "", "default empty, mandatory, the username for the session"}, {"password", "", "default empty, mandatory, the password for the session"}, {"protocol", "imap", "default imap, optional, either imap or pop3"}, {"folder", "INBOX", "default INBOX, optional, folder to read messages from.  Only for IMAP"}, {"movetofolder", "", "default empty, optional, folder to move each email to after reading it.  Only for IMAP"}, {"copytofolder", "", "default empty, optional, folder to copy each email to after reading it.  Only for IMAP"}, {"getattachments", "false", "default false, optional, if true attachments are saved into a temporary folder and a url to it returned"}, {"getrawcontent", "false", "default false, optional, if true all body content is returned as bodyparts, including fileattachments"}, {"getrawcontentasxml", "false", "default false, optional, if true all body content is returned as XML bodyparts, including fileattachments"}, {"getbodyasxml", "false", "default false, optional, if true all body content is returned as XML"}, {"searchsubject", "", "default empty, optional, if specified will only return mails containg this subject"}, {"searchfrom", "", "default empty, optional, if specified will only return mails from this address"}, {"reverseorder", "false", "default false, optional, if true, the messages will be returned in reverse order (newest first)"}};

    public MailReader() {
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            this.parameters.putString(name, paramInfo[i][1]);
        }
    }

    @Override
    public void init() {
        this.sHost = this.parameters.getString("host", "localhost");
        this.sUser = this.parameters.getString("user");
        if (this.sUser == null) {
            this.setError("init user", "missing user");
        }
        this.sPassword = this.parameters.getString("password");
        if (this.sPassword == null) {
            this.setError("init password", "missing password");
        }
        this.sProtocol = this.parameters.getString("protocol", "imap");
        this.bSaveAttachments = this.parameters.getBoolean("getattachments", false);
        this.bGetRawContent = this.parameters.getBoolean("getrawcontent", false);
        this.sMoveToFolder = this.parameters.getString("movetofolder", null);
        this.sCopyToFolder = this.parameters.getString("copytofolder", null);
        if ("imap".equals(this.sProtocol)) {
            this.iPort = 143;
            this.iProtocol = 1;
        } else {
            this.iPort = 110;
            this.iProtocol = 2;
            this.sProtocol = "pop3";
        }
        this.sSearchSubject = this.parameters.getString("searchsubject", null);
        this.sSearchFrom = this.parameters.getString("searchfrom", null);
        if ("".equals(this.sSearchFrom)) {
            this.sSearchFrom = null;
        }
        if ("".equals(this.sSearchSubject)) {
            this.sSearchSubject = null;
        }
        this.sFolder = this.parameters.getString("folder", "INBOX");
        this.router.getLog().debug("parameters:\n" + this.parameters.toString());
        this.bGetRawContentAsXML = this.parameters.getBoolean("getrawcontentasxml", false);
        this.bGetBodyAsXML = this.parameters.getBoolean("getbodyasxml", false);
        this.bReverseOrder = this.parameters.getBoolean("reverseorder", false);
    }

    public static String getDescription() {
        return "This reader reads emails from POP3 or IMAP server, the document contains the content of the email and header.";
    }

    public static String getDocumentDesc() {
        return MailReader.getStandardDocument("MailReader", "(to be defined)", true);
    }

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][2]);
            h.put(name, p);
        }
        return h;
    }

    @Override
    public String getType() {
        return "MailReader";
    }

    @Override
    public List read() {
        LinkedList<Document> l = new LinkedList<Document>();
        try {
            Message[] msgs;
            Properties props = System.getProperties();
            Session session = Session.getDefaultInstance((Properties)props, null);
            Store store = session.getStore(this.sProtocol);
            store.connect(this.sHost, this.iPort, this.sUser, this.sPassword);
            Folder folder = store.getDefaultFolder();
            if (folder == null) {
                this.setError("get default folder", "no default folder");
                return null;
            }
            if ((folder = folder.getFolder(this.sFolder)) == null) {
                this.setError("get folder", "unable to open folder '" + this.sFolder + "'");
                return null;
            }
            try {
                folder.open(2);
            }
            catch (MessagingException ex) {
                folder.open(1);
            }
            int totalMessages = folder.getMessageCount();
            if (totalMessages == 0) {
                System.out.println("Empty folder");
                folder.close(false);
                store.close();
                return null;
            }
            int newMessages = folder.getNewMessageCount();
            System.out.println("Total messages = " + totalMessages);
            System.out.println("New messages = " + newMessages);
            System.out.println("-------------------------------");
            if (this.sSearchFrom != null || this.sSearchSubject != null) {
                this.router.getLog().debug(this.getName() + ":searching");
                Object term = null;
                if (this.sSearchSubject != null) {
                    term = new SubjectTerm(this.sSearchSubject);
                }
                if (this.sSearchFrom != null) {
                    FromStringTerm fromTerm = new FromStringTerm(this.sSearchFrom);
                    term = term != null ? new AndTerm((SearchTerm)term, (SearchTerm)fromTerm) : fromTerm;
                }
                msgs = folder.search((SearchTerm)term);
            } else {
                msgs = folder.getMessages();
            }
            this.router.getLog().debug("handling " + msgs.length + " messages");
            if (msgs.length == 0) {
                return l;
            }
            FetchProfile fp = new FetchProfile();
            fp.add(FetchProfile.Item.ENVELOPE);
            fp.add(FetchProfile.Item.FLAGS);
            fp.add("X-Mailer");
            folder.fetch(msgs, fp);
            int inc = 1;
            int i = 0;
            if (this.bReverseOrder) {
                inc = -1;
                i = msgs.length - 1;
            }
            int max = this.getMaxReturn();
            for (int idx = 0; idx < max && i >= 0 && i < msgs.length; i += inc, ++idx) {
                Document doc = IO.makeXMLDocument(this);
                doc.getRootElement().setAttribute("msgid", Integer.toString(i));
                doc = this.dumpEnvelope(msgs[i], doc);
                doc = this.dumpPart((Part)msgs[i], doc);
                l.add(doc);
            }
            if (this.sCopyToFolder != null && !this.sCopyToFolder.equals("") && this.iProtocol == 1) {
                try {
                    Folder copyToFolder = store.getFolder(this.sCopyToFolder);
                    if (!copyToFolder.exists()) {
                        copyToFolder.create(1);
                    }
                    copyToFolder.open(2);
                    folder.copyMessages(msgs, copyToFolder);
                    System.out.println("Copied messages...");
                    copyToFolder.close(false);
                }
                catch (Exception e) {
                    this.setError("copying to folder " + this.sCopyToFolder, e);
                    this.router.getLog().error(e);
                }
            }
            if (this.sMoveToFolder != null && !this.sMoveToFolder.equals("") && this.iProtocol == 1) {
                try {
                    Folder moveToFolder = store.getFolder(this.sMoveToFolder);
                    if (!moveToFolder.exists()) {
                        moveToFolder.create(1);
                    }
                    moveToFolder.open(2);
                    folder.copyMessages(msgs, moveToFolder);
                    folder.setFlags(msgs, new Flags(Flags.Flag.DELETED), true);
                    moveToFolder.close(false);
                }
                catch (Exception e) {
                    this.setError("moving to folder " + this.sMoveToFolder, e);
                    this.router.getLog().error(e);
                }
            }
        }
        catch (Exception e) {
            this.setError("reading", e);
            this.router.getLog().error(e);
        }
        return l;
    }

    private Document dumpPart(Part p, Document doc) throws Exception {
        String disp;
        Element root = doc.getRootElement();
        String filename = p.getFileName();
        if (p.isMimeType("text/plain")) {
            Element items = root.getChild("items");
            if (items == null) {
                items = new Element("items");
                root.addContent(items);
            }
            Element body = new Element("item");
            body.setAttribute("name", "body");
            items.addContent(body);
            String stmp = (String)p.getContent();
            if (this.bGetBodyAsXML) {
                try {
                    String sxml = stmp;
                    int attidx = stmp.indexOf("(See attached file");
                    if (attidx > -1) {
                        sxml = stmp.substring(0, attidx);
                    }
                    StringReader sr = new StringReader(sxml);
                    this.router.getLog().debug("bodyxml:'" + sxml + "'");
                    SAXBuilder builder = new SAXBuilder();
                    Document d = builder.build((java.io.Reader)sr);
                    body.addContent(d.getRootElement());
                }
                catch (Exception e) {
                    body.setText("Error converting body content to XML " + e.getMessage());
                }
            } else {
                body.setText(stmp);
            }
        } else if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                ++level;
                doc = this.dumpPart((Part)mp.getBodyPart(i), doc);
                --level;
            }
        } else if (p.isMimeType("message/rfc822")) {
            ++level;
            doc = this.dumpPart((Part)p.getContent(), doc);
            --level;
        } else if (this.bGetRawContent) {
            Object o = p.getContent();
            String stmp = "";
            if (o instanceof String) {
                stmp = (String)o;
            } else if (o instanceof InputStream) {
                int c;
                InputStream is = (InputStream)o;
                while ((c = is.read()) != -1) {
                    stmp = stmp + (char)c;
                }
            } else {
                stmp = o.toString();
            }
            Element bp = new Element("bodypart");
            if (filename != null) {
                bp.setAttribute("filename", filename);
            }
            bp.setAttribute("contenttype", p.getContentType());
            if (p.getDescription() != null) {
                bp.setAttribute("description", p.getDescription());
            }
            if (this.bGetRawContentAsXML) {
                try {
                    StringReader sr = new StringReader(stmp);
                    SAXBuilder builder = new SAXBuilder();
                    Document d = builder.build((java.io.Reader)sr);
                    bp.addContent(d.getRootElement());
                }
                catch (Exception e) {
                    bp.setText("Error converting bodypart to XML " + e.getMessage());
                }
            } else {
                CDATA cdata = new CDATA(stmp);
                bp.addContent(cdata);
            }
            Element bodyparts = root.getChild("bodyparts");
            if (bodyparts == null) {
                bodyparts = new Element("bodyparts");
                root.addContent(bodyparts);
            }
            bodyparts.addContent(bp);
        }
        if (this.bSaveAttachments && level != 0 && !p.isMimeType("multipart/*") && ((disp = p.getDisposition()) == null || disp.equalsIgnoreCase("attachment"))) {
            Element fas = root.getChild("fileattachments");
            if (fas == null) {
                fas = new Element("fileattachments");
                root.addContent(fas);
            }
            if (filename == null) {
                filename = "Attachment" + attnum++;
            }
            long ctm = System.currentTimeMillis();
            String tmpfile = this.getRouter().getWebRoot() + "tmp" + File.separator + ctm + "." + filename;
            String surl = "/tmp/" + ctm + "." + filename;
            Element fa = new Element("fileattachment");
            fa.setAttribute("name", filename);
            fa.setAttribute("realpath", tmpfile);
            fa.setAttribute("url", surl);
            fa.setAttribute("size", Integer.toString(p.getSize()));
            fas.addContent(fa);
            this.router.getLog().info("Saving attachment to file " + tmpfile);
            try {
                int c;
                File f = new File(tmpfile);
                if (f.exists()) {
                    throw new IOException("file exists");
                }
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                InputStream is = p.getInputStream();
                while ((c = is.read()) != -1) {
                    ((OutputStream)os).write(c);
                }
                ((OutputStream)os).close();
            }
            catch (IOException ex) {
                this.setError("saving attachment " + tmpfile, ex);
                this.router.getLog().error((Exception)ex);
            }
        }
        return doc;
    }

    private Document dumpEnvelope(Message m, Document doc) throws Exception {
        Element items = new Element("items");
        doc.getRootElement().addContent(items);
        Enumeration e = m.getAllHeaders();
        while (e.hasMoreElements()) {
            Header h = (Header)e.nextElement();
            Element header = new Element("item");
            header.setAttribute("name", h.getName());
            header.setText(h.getValue());
            items.addContent(header);
        }
        Flags flags = m.getFlags();
        StringBuffer sb = new StringBuffer();
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        for (int i = 0; i < sf.length; ++i) {
            String s;
            Flags.Flag f = sf[i];
            if (f == Flags.Flag.ANSWERED) {
                s = "\\Answered";
            } else if (f == Flags.Flag.DELETED) {
                s = "\\Deleted";
            } else if (f == Flags.Flag.DRAFT) {
                s = "\\Draft";
            } else if (f == Flags.Flag.FLAGGED) {
                s = "\\Flagged";
            } else if (f == Flags.Flag.RECENT) {
                s = "\\Recent";
            } else {
                if (f != Flags.Flag.SEEN) continue;
                s = "\\Seen";
            }
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(s);
        }
        String[] uf = flags.getUserFlags();
        for (int i = 0; i < uf.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i]);
        }
        Element eflags = new Element("item");
        eflags.setAttribute("name", "flags");
        eflags.setText(sb.toString());
        items.addContent(eflags);
        return doc;
    }
}

