/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import org.jdom.Document;
import org.jdom.Element;

public class JDBCReader
extends Reader {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/readers/JDBCReader.java 2     20.09.05 9:38 Kbg $";
    String url = null;
    String user = null;
    String pass = null;
    String sel = null;
    private static String[][] paramInfo = new String[][]{{"jdbc_driver", "default empty, mandatory The JDBC class used. For example: use COM.ibm.db2.jdbc.app.DB2 for DB2 and sun.jdbc.odbc.JdbcOdbcDriver for Sun jdbc/odbc bridge"}, {"jdbc_url", "default emtpy, mandatory, datasource to use with the driver. For example jdbc:odbc:NameOfDatasource when using the jdbc/odbc bridge"}, {"jdbc_user", "default empty, optional, the username for the JDBC session"}, {"jdbc_password", "default empty, optional, the password for the JDBC session"}, {"jdbc_statement", "default empty, mandatory,the selection formula. I.e. <pre>select e.* from emp e where e.name like \u0092John\u0092</pre>. This string  can also contain zero or more ? which will be replaced with parameters p1 throuh pN."}, {"singledoc", "default false, optional If specified the complet resultset will bereturned in on document."}, {"singledocmax", "default 0, optional, determines the maximum number of results to put into the return document.  If 0 then all documents will be returned"}, {"p1", "default empty, optional, all ? will be replaced with p-parameters in that order. This can be very usefull when using this reader through a servlet."}, {"p2", "default empty, optional, all ? will be replaced with p-parameters in that order. This can be very usefull when using this reader through a servlet."}, {"p3", "default empty, optional, all ? will be replaced with p-parameters in that order. This can be very usefull when using this reader through a servlet."}, {"p4", "default empty, optional, all ? will be replaced with p-parameters in that order. This can be very usefull when using this reader through a servlet."}, {"p5", "default empty, optional, all ? will be replaced with p-parameters in that order. This can be very usefull when using this reader through a servlet."}, {"p6", "default empty, optional, all ? will be replaced with p-parameters in that order. This can be very usefull when using this reader through a servlet."}, {"p7", "default empty, optional, all ? will be replaced with p-parameters in that order. This can be very usefull when using this reader through a servlet."}, {"p8", "default empty, optional, all ? will be replaced with p-parameters in that order. This can be very usefull when using this reader through a servlet."}, {"p9", "default empty, optional, all ? will be replaced with p-parameters in that order. This can be very usefull when using this reader through a servlet."}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public JDBCReader() {
        this.parameters.putString("jdbc_driver", "COM.ibm.db2.jdbc.app.DB2Driver");
        this.parameters.putString("jdbc_url", "jdbc:db2:MyDatabase");
        this.parameters.putString("jdbc_user", "db2admin");
        this.parameters.putString("jdbc_password", "MyPassword");
        this.parameters.putString("jdbc_statement", "select * from MyTable");
    }

    @Override
    public String getType() {
        return "JDBCReader";
    }

    @Override
    public void init() {
        super.init();
        String driver = this.parameters.getString("jdbc_driver");
        if (driver == null || "".equals(driver)) {
            this.setError("missing parameter", "missing 'jdbc_driver' parameter");
            return;
        }
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            this.setError("error while initializing", e);
            this.router.getLog().error(e);
        }
    }

    @Override
    public List read() {
        LinkedList<Document> l = new LinkedList<Document>();
        try {
            this.url = this.parameters.getString("jdbc_url");
            this.user = this.parameters.getString("jdbc_user");
            this.pass = this.parameters.getString("jdbc_password");
            this.sel = this.parameters.getString("jdbc_statement");
            boolean bSingleDoc = this.parameters.getBoolean("singledoc", false);
            Connection con = DriverManager.getConnection(this.url, this.user, this.pass);
            Statement stmt = con.createStatement();
            if (this.parameters.getString("p1", null) != null) {
                this.sel = this.parameters.getParametricString(this.sel);
            }
            this.router.getLog().info(this.getType() + "." + this.getName() + ": " + this.sel);
            ResultSet rs = stmt.executeQuery(this.sel);
            if (bSingleDoc) {
                l.add(this.mkSingleDoc(rs));
            } else {
                int maxRet = this.getMaxReturn();
                for (int idx = 0; rs.next() && idx < maxRet; ++idx) {
                    l.add(this.mkXMLDoc(rs));
                }
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ne) {
            l.add(this.mkErrorXMLDoc(ne));
            this.setError("while reading", ne);
            this.router.getLog().error(ne);
        }
        return l;
    }

    protected Document mkErrorXMLDoc(Exception e) {
        Document d = IO.makeXMLDocument(this);
        Element root = d.getRootElement();
        this.setHeaderInfo(root);
        Element error = new Element("error");
        root.addContent(error);
        error.addContent(e.toString());
        return d;
    }

    private void setHeaderInfo(Element root) {
        root.addContent(new Element("jdbc_user").addContent(this.user));
        root.addContent(new Element("jdbc_statement").addContent(this.sel));
        root.addContent(new Element("jdbc_url").addContent(this.url));
    }

    protected Document mkSingleDoc(ResultSet rs) {
        Document d = IO.makeXMLDocument(this);
        Element root = d.getRootElement();
        this.setHeaderInfo(root);
        try {
            int idx = 0;
            int maxRet = this.parameters.getInt("singledocmax", 0);
            if (maxRet == 0) {
                maxRet = Integer.MAX_VALUE;
            }
            while (rs.next() && idx < maxRet) {
                Element row = new Element("row");
                row.setAttribute("number", String.valueOf(++idx));
                root.addContent(row);
                Element items = new Element("items");
                row.addContent(items);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numberOfColumns = rsmd.getColumnCount();
                for (int i = 1; i <= numberOfColumns; ++i) {
                    Element item = new Element("item");
                    try {
                        String index = String.valueOf(i);
                        String name = rsmd.getColumnName(i).toLowerCase();
                        String type = JDBCReader.getTypeAsString(rsmd.getColumnType(i));
                        String value = rs.getString(i);
                        if (value == null) {
                            value = "";
                        }
                        item.setAttribute("index", index);
                        item.setAttribute("name", name);
                        item.setAttribute("type", type);
                        item.setText(value);
                    }
                    catch (Exception e1) {
                        this.setError("going through result set(" + i + ")", e1);
                        this.router.getLog().error(e1);
                    }
                    items.addContent(item);
                }
            }
        }
        catch (Exception e) {
            this.setError("error creating single doc", e);
            this.router.getLog().error(e);
        }
        return d;
    }

    protected Document mkXMLDoc(ResultSet rs) {
        Document d = IO.makeXMLDocument(this);
        Element root = d.getRootElement();
        this.setHeaderInfo(root);
        Element items = new Element("items");
        root.addContent(items);
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            for (int i = 1; i <= numberOfColumns; ++i) {
                Element item = new Element("item");
                try {
                    String index = String.valueOf(i);
                    String name = rsmd.getColumnName(i).toLowerCase();
                    String type = JDBCReader.getTypeAsString(rsmd.getColumnType(i));
                    String value = rs.getString(i);
                    if (value == null) {
                        value = "";
                    }
                    item.setAttribute("index", index);
                    item.setAttribute("name", name);
                    item.setAttribute("type", type);
                    item.setText(value);
                }
                catch (Exception e1) {
                    this.setError("going through result set(" + i + ")", e1);
                    this.router.getLog().error(e1);
                }
                items.addContent(item);
            }
        }
        catch (Exception e) {
            this.router.getLog().error(e);
            this.setError("creating document", e);
        }
        return d;
    }

    static String getTypeAsString(int i) {
        switch (i) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN_TYPE";
    }

    public static String getDescription() {
        return "The JDBCReader reads data from any JDBC/ODBC compliant datasource.";
    }

    public static String getDocumentDesc() {
        return "The return document contains the standard document header plus the JDBC data " + JDBCReader.getStandardDocument("JDBCReader", "(to be defined)", false) + "<br>" + JDBCReader.htmlSpace(3) + "<code>&lt;items&gt;<br>" + JDBCReader.htmlSpace(6) + "&lt;item name='name1' type='type1' index='1'&gt;value1&lt;/item&gt;<br>" + JDBCReader.htmlSpace(6) + "&lt;comment&gt;..&lt;/comment&gt;<br>" + JDBCReader.htmlSpace(6) + "&lt;item name='nameN' type='typeN' index='N'&gt;valueN&lt;/item&gt;<br>" + JDBCReader.htmlSpace(3) + "&lt;/items&gt;<br>" + "&lt;/document&gt;</code><br>" + "Where <ul>" + "<li><code>name</code> is the column name from the result set</li>" + "<li><code>index</code> is the column number from the result set </li>" + "<li><code>type</code> is a SQL type of the column which can be any of: <code>" + "BIGINT, BINARY, BIT, BLOB ,  CHAR," + "CLOB , DATE, DECIMAL, DISTINCT, DOUBLE " + "FLOAT, INTEGER, LONGVARBINARY, LONGVARCHAR, NULL " + "NUMERIC , OTHER, REAL , REF , SMALLINT " + "STRUCT, TIME , TIMESTAMP, TINYINT, VARBINARY , VARCHAR </code>" + "</li></ul>";
    }
}

