/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import lotus.domino.Database;
import lotus.domino.NotesException;
import lotus.domino.View;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;
import net.gopro.gdr.DominoHelper;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import org.jdom.Document;

public class DominoViewReader
extends Reader {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/readers/DominoViewReader.java 2     20.09.05 9:38 Kbg $";
    private DominoHelper dh;
    private static String[][] paramInfo = new String[][]{{"fields", "default empty, optional, Comma delimeted list of fields (with or without an alias) to retrieve"}, {"sessiontype", "default <code>server</code>, optional, specifies the type of connection used to Lotus Domino server. Possible values are: <ul><li><code>iiop</code> for to use the CORBA connection classes for Domino. When using <code>iiop</code> the user, server and password parameters are mandatory.<li><code>server</code> which is proper when running on a Lotus Domino Server<li><code>local</code> when using the local installation of Lotus Notes to access the server.When using <code>local</code> the user and password parameters are mandatory.</ul>"}, {"user", "default empty, optional username for the session"}, {"password", "default empty, optional password for the session"}, {"server", "default empty, mandatory, the server"}, {"database", "default empty, mandatory, the database"}, {"includeresponses", "default false, optional, returns all response documents"}, {"includeattachments", "default false, optional, returns all response documents"}, {"viewname", "default empty, mandatory, the view to search for documents using the key specified"}, {"singledoc", "default false, optional If specified the complet resultset will bereturned in on document."}, {"singledocmax", "default 0, optional, determines the maximum number of results to put into the return document.  If 0 then all documents will be returned"}, {"viewkey", "default empty, optional, the key used to locate documents in the view selected. If nothing is specified it will return all documents in the view. Note however that the view must be sorted on the left-most column."}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public DominoViewReader() {
        this.parameters.putString("server", "");
        this.parameters.putString("database", "MyNotesDatabase.nsf");
        this.parameters.putString("viewname", "MyView");
        this.parameters.putString("viewkey", "");
        this.parameters.putString("fields", "MyField1,MyField2");
    }

    @Override
    public void init() {
        super.init();
        String sessionType = this.parameters.getString("sessiontype", "server");
        this.dh = new DominoHelper(this, sessionType);
        this.dh.initThread();
        this.dh.init();
    }

    @Override
    public void term() {
        this.dh.termThread();
        this.dh.term();
    }

    @Override
    public void initThread() {
        this.dh.initThread();
    }

    @Override
    public void termThread() {
        this.dh.termThread();
    }

    @Override
    public String getType() {
        return "DominoViewReader";
    }

    @Override
    public List read() {
        LinkedList<Document> l = new LinkedList<Document>();
        try {
            if (!this.dh.checkConnection()) {
                return l;
            }
            String viewName = this.parameters.getString("viewname");
            String viewKey = this.parameters.getString("viewkey");
            boolean bResponses = this.parameters.getBoolean("includeresponses", false);
            boolean bAttachments = this.parameters.getBoolean("includeattachments", false);
            boolean bSingleDoc = this.parameters.getBoolean("singledoc", false);
            int iSingleMax = this.parameters.getInt("singledocmax", Integer.MAX_VALUE);
            boolean bMore = true;
            String fields = this.parameters.getString("fields");
            int maxReturn = this.getMaxReturn();
            this.router.getLog().debug(this.name + ":view key:" + viewKey);
            this.router.getLog().debug(this.name + ":view name:" + viewName);
            this.router.getLog().debug(this.name + ":maxreturn:" + maxReturn);
            Database db = this.dh.getDatabase();
            View view = db.getView(viewName);
            if (view == null) {
                throw new Exception("Unable to open view " + viewName);
            }
            view.refresh();
            ViewEntryCollection vec = view.getAllEntriesByKey((Object)viewKey);
            int found = vec.getCount();
            this.router.getLog().debug(this.name + ":found:" + found);
            if (found > 0) {
                if (bSingleDoc) {
                    if (maxReturn < iSingleMax || vec.getCount() < iSingleMax) {
                        l.add(DominoHelper.makeJDOMDocument((Reader)this, vec, 1, maxReturn, fields));
                    } else {
                        int iCount = 1;
                        int iCountLast = 1;
                        while (bMore) {
                            if (maxReturn <= iCount + iSingleMax) {
                                bMore = false;
                                int iLastFew = maxReturn - iCount;
                                l.add(DominoHelper.makeJDOMDocument((Reader)this, vec, iCount, iLastFew, fields));
                            } else {
                                l.add(DominoHelper.makeJDOMDocument((Reader)this, vec, iCount, iSingleMax, fields));
                            }
                            iCountLast = iCount;
                            iCount += iSingleMax;
                        }
                    }
                } else {
                    ViewEntry entry = vec.getFirstEntry();
                    for (int idx = 0; entry != null && idx < maxReturn; ++idx) {
                        lotus.domino.Document ddoc = entry.getDocument();
                        if (bResponses) {
                            l.add(this.dh.makeJDOMDocumentWithResponses(this, ddoc, bAttachments, fields));
                        } else {
                            l.add(this.dh.makeJDOMDocument(this, ddoc, bAttachments, fields));
                        }
                        entry = vec.getNextEntry();
                    }
                }
            }
        }
        catch (NotesException ne) {
            this.router.getLog().error((Exception)((Object)ne));
            this.setError("reading", ne.text);
        }
        catch (Exception e) {
            this.setError("reading", e);
            this.router.getLog().error(e);
        }
        return l;
    }

    public static String getDescription() {
        return "The DominoViewReader uses a Domino View to locate documents which are returned";
    }

    public static String getDocumentDesc() {
        return "DominoViewReader returns a document with content of a domino document found.  Here is an example content:<br><code>" + DominoViewReader.getStandardDocument("DominoViewReader", "(to be defined)", false) + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("server") + "CN=Domino02/O=Orga01" + DominoViewReader.htmlTag("/server") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("database") + "names.nsf" + DominoViewReader.htmlTag("/database") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("form") + "Company" + DominoViewReader.htmlTag("/form") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("noteid") + "122A" + DominoViewReader.htmlTag("/noteid") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("unid") + "CC79D5F6BD3DB70900256A99004961FB" + DominoViewReader.htmlTag("/unid") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("created") + "30.07.2001 13:21:32 GMT" + DominoViewReader.htmlTag("/created") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("modified") + "01.08.2001 16:44:56 GMT" + DominoViewReader.htmlTag("/modified") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("accessed") + "01.08.2001 16:44:56 GMT" + DominoViewReader.htmlTag("/accessed") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("thisread") + "10.08.2001 13:34:38 GMT" + DominoViewReader.htmlTag("/thisread") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("isresponse") + "no" + DominoViewReader.htmlTag("/isresponse") + "<br>" + DominoViewReader.htmlSpace(6) + DominoViewReader.htmlTag("items") + "<br>" + DominoViewReader.htmlSpace(6) + "&lt;item name=\\\"textfield\\\" type=\\\"TEXT\\\"&gt;text in field" + DominoViewReader.htmlTag("/item") + "<br>" + DominoViewReader.htmlSpace(6) + "&lt;item name=\\\"numberfield\\\" type=\\\"NUMBER\\\"&gt;3.14159" + DominoViewReader.htmlTag("/item") + "<br>" + DominoViewReader.htmlSpace(6) + "&lt;item name=\\\"datefield\\\" type=\\\"DATE\\\"&gt;01.08.2001 16:44:56 GMT" + DominoViewReader.htmlTag("/item") + "<br>" + DominoViewReader.htmlSpace(6) + "&lt;item name=\\\"textlistfield\\\" type=\\\"TEXTLIST\\\"&gt;<br>" + DominoViewReader.htmlSpace(9) + DominoViewReader.htmlTag("TEXT") + "text1" + DominoViewReader.htmlTag("/TEXT") + "<br>" + DominoViewReader.htmlSpace(9) + DominoViewReader.htmlTag("comment") + "..." + DominoViewReader.htmlTag("/comment") + "<br>" + DominoViewReader.htmlSpace(9) + DominoViewReader.htmlTag("TEXT") + "textN" + DominoViewReader.htmlTag("/TEXT") + "<br>" + DominoViewReader.htmlSpace(6) + DominoViewReader.htmlTag("/item") + "<br>" + DominoViewReader.htmlSpace(6) + "&lt;item name=\\\"numberlist_field\\\" type=\\\"NUMBERLIST\\\"&gt;<br>" + DominoViewReader.htmlSpace(9) + DominoViewReader.htmlTag("NUMBER") + "3.14159" + DominoViewReader.htmlTag("/NUMBER") + "<br>" + DominoViewReader.htmlSpace(9) + DominoViewReader.htmlTag("comment") + "..." + DominoViewReader.htmlTag("/comment") + "<br>" + DominoViewReader.htmlSpace(9) + DominoViewReader.htmlTag("NUMBER") + "2.7128128" + DominoViewReader.htmlTag("/NUMBER") + "<br>" + DominoViewReader.htmlSpace(6) + DominoViewReader.htmlTag("/item") + "<br>" + DominoViewReader.htmlSpace(6) + "&lt;item name=\\\"datelist_field\\\" type=\\\"DATELIST\\\"&gt;<br>" + DominoViewReader.htmlSpace(9) + DominoViewReader.htmlTag("DATE") + "01.08.2001 16:44:56 GMT" + DominoViewReader.htmlTag("/DATE") + "<br>" + DominoViewReader.htmlSpace(9) + DominoViewReader.htmlTag("comment") + "..." + DominoViewReader.htmlTag("/comment") + "<br>" + DominoViewReader.htmlSpace(9) + DominoViewReader.htmlTag("DATE") + "01.08.2001 16:44:59 GMT" + DominoViewReader.htmlTag("/DATE") + "<br>" + DominoViewReader.htmlSpace(6) + DominoViewReader.htmlTag("/item") + "<br>" + DominoViewReader.htmlSpace(3) + DominoViewReader.htmlTag("/items") + "<br>" + DominoViewReader.htmlTag("/document") + "</code>";
    }
}

