/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import lotus.domino.Database;
import lotus.domino.DocumentCollection;
import lotus.domino.NotesException;
import net.gopro.gdr.DominoHelper;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import net.gopro.gdr.readers.DominoNOPReader;
import org.jdom.Document;

public class DominoSearchReader
extends DominoNOPReader {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/readers/DominoSearchReader.java 2     20.09.05 9:38 Kbg $";
    private static String[][] paramInfo = new String[][]{{"database", "default empty, mandatory, the database"}, {"singledoc", "default false, optional If specified the complet resultset will bereturned in on document."}, {"singledocmax", "default 0, optional, determines the maximum number of results to put into the return document.  If 0 then all documents will be returned"}, {"select", "default @all, mandatory, the selection criteria for the documents."}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public DominoSearchReader() {
        this.parameters.putString("select", "@all");
    }

    @Override
    public String getType() {
        return "DominoSearchReader";
    }

    @Override
    public List read() {
        LinkedList<Document> l = new LinkedList<Document>();
        try {
            if (!this.dh.checkConnection()) {
                return l;
            }
            String sCriteria = this.parameters.getString("select");
            boolean bSingleDoc = this.parameters.getBoolean("singledoc", false);
            int iSingleMax = this.parameters.getInt("singledocmax", Integer.MAX_VALUE);
            boolean bMore = true;
            int maxReturn = this.getMaxReturn();
            Database db = this.dh.getDatabase();
            if (db == null) {
                return l;
            }
            DocumentCollection dc = db.search(sCriteria);
            lotus.domino.Document ddoc = dc.getFirstDocument();
            this.router.getLog().debug("found: " + dc.getCount());
            if (dc.getCount() > 0) {
                if (bSingleDoc) {
                    if (dc.getCount() < iSingleMax) {
                        l.add(DominoHelper.makeJDOMDocument((Reader)this, dc, 1, maxReturn, null));
                    } else {
                        int iCount = 1;
                        while (bMore) {
                            if (dc.getCount() <= iCount) {
                                bMore = false;
                            }
                            l.add(DominoHelper.makeJDOMDocument((Reader)this, dc, iCount, iSingleMax, null));
                            iCount += iSingleMax;
                        }
                    }
                } else {
                    for (int idx = 0; ddoc != null && idx < maxReturn; ++idx) {
                        l.add(DominoHelper.makeJDOMDocument(this, ddoc));
                        ddoc = dc.getNextDocument();
                    }
                }
            }
        }
        catch (NotesException ne) {
            this.setError("reading", ne.text);
            this.router.getLog().error((Exception)((Object)ne));
        }
        catch (Exception e) {
            this.setError("reading", e);
            this.router.getLog().error(e);
        }
        return l;
    }

    public static String getDescription() {
        return "The DominoSearchReader is similar to the DominoViewReader but performs a database search instead of using a Domino view.  This can be good when working on a small database without changing the design of it, but is not good for large databases since it has to read through all the documents.  ";
    }

    public static String getDocumentDesc() {
        return "DominoSearchReader returns a document with content of a domino document found.  Here is an example content:<br><code>" + DominoSearchReader.getStandardDocument("DominoSearchReader", "(to be defined)", false) + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("server") + "CN=Domino02/O=Orga01" + DominoSearchReader.htmlTag("/server") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("database") + "names.nsf" + DominoSearchReader.htmlTag("/database") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("form") + "Company" + DominoSearchReader.htmlTag("/form") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("noteid") + "122A" + DominoSearchReader.htmlTag("/noteid") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("unid") + "CC79D5F6BD3DB70900256A99004961FB" + DominoSearchReader.htmlTag("/unid") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("created") + "30.07.2001 13:21:32 GMT" + DominoSearchReader.htmlTag("/created") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("modified") + "01.08.2001 16:44:56 GMT" + DominoSearchReader.htmlTag("/modified") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("accessed") + "01.08.2001 16:44:56 GMT" + DominoSearchReader.htmlTag("/accessed") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("thisread") + "10.08.2001 13:34:38 GMT" + DominoSearchReader.htmlTag("/thisread") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("isresponse") + "no" + DominoSearchReader.htmlTag("/isresponse") + "<br>" + DominoSearchReader.htmlSpace(6) + DominoSearchReader.htmlTag("items") + "<br>" + DominoSearchReader.htmlSpace(6) + "&lt;item name=\\\"textfield\\\" type=\\\"TEXT\\\"&gt;text in field" + DominoSearchReader.htmlTag("/item") + "<br>" + DominoSearchReader.htmlSpace(6) + "&lt;item name=\\\"numberfield\\\" type=\\\"NUMBER\\\"&gt;3.14159" + DominoSearchReader.htmlTag("/item") + "<br>" + DominoSearchReader.htmlSpace(6) + "&lt;item name=\\\"datefield\\\" type=\\\"DATE\\\"&gt;01.08.2001 16:44:56 GMT" + DominoSearchReader.htmlTag("/item") + "<br>" + DominoSearchReader.htmlSpace(6) + "&lt;item name=\\\"textlistfield\\\" type=\\\"TEXTLIST\\\"&gt;<br>" + DominoSearchReader.htmlSpace(9) + DominoSearchReader.htmlTag("TEXT") + "text1" + DominoSearchReader.htmlTag("/TEXT") + "<br>" + DominoSearchReader.htmlSpace(9) + DominoSearchReader.htmlTag("comment") + "..." + DominoSearchReader.htmlTag("/comment") + "<br>" + DominoSearchReader.htmlSpace(9) + DominoSearchReader.htmlTag("TEXT") + "textN" + DominoSearchReader.htmlTag("/TEXT") + "<br>" + DominoSearchReader.htmlSpace(6) + DominoSearchReader.htmlTag("/item") + "<br>" + DominoSearchReader.htmlSpace(6) + "&lt;item name=\\\"numberlist_field\\\" type=\\\"NUMBERLIST\\\"&gt;<br>" + DominoSearchReader.htmlSpace(9) + DominoSearchReader.htmlTag("NUMBER") + "3.14159" + DominoSearchReader.htmlTag("/NUMBER") + "<br>" + DominoSearchReader.htmlSpace(9) + DominoSearchReader.htmlTag("comment") + "..." + DominoSearchReader.htmlTag("/comment") + "<br>" + DominoSearchReader.htmlSpace(9) + DominoSearchReader.htmlTag("NUMBER") + "2.7128128" + DominoSearchReader.htmlTag("/NUMBER") + "<br>" + DominoSearchReader.htmlSpace(6) + DominoSearchReader.htmlTag("/item") + "<br>" + DominoSearchReader.htmlSpace(6) + "&lt;item name=\\\"datelist_field\\\" type=\\\"DATELIST\\\"&gt;<br>" + DominoSearchReader.htmlSpace(9) + DominoSearchReader.htmlTag("DATE") + "01.08.2001 16:44:56 GMT" + DominoSearchReader.htmlTag("/DATE") + "<br>" + DominoSearchReader.htmlSpace(9) + DominoSearchReader.htmlTag("comment") + "..." + DominoSearchReader.htmlTag("/comment") + "<br>" + DominoSearchReader.htmlSpace(9) + DominoSearchReader.htmlTag("DATE") + "01.08.2001 16:44:59 GMT" + DominoSearchReader.htmlTag("/DATE") + "<br>" + DominoSearchReader.htmlSpace(6) + DominoSearchReader.htmlTag("/item") + "<br>" + DominoSearchReader.htmlSpace(3) + DominoSearchReader.htmlTag("/items") + "<br>" + DominoSearchReader.htmlTag("/document") + "</code>";
    }
}

