/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr.readers;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import lotus.domino.Session;
import net.gopro.gdr.DominoHelper;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Reader;
import org.jdom.Document;

public class DominoNOPReader
extends Reader {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/readers/DominoNOPReader.java 2     20.09.05 9:38 Kbg $";
    protected DominoHelper dh;
    private static String[][] paramInfo = new String[][]{{"sessiontype", "default <code>server</code>, optional, specifies the type of connection used to Lotus Domino server. Possible values are: <ul><li><code>iiop</code> for to use the CORBA connection classes for Domino. When using <code>iiop</code> the user, server and password parameters are mandatory.<li><code>server</code> which is proper when running on a Lotus Domino Server<li><code>local</code> when using the local installation of Lotus Notes to access the server.When using <code>local</code> the user and password parameters are mandatory.</ul>"}, {"user", "default empty, optional username for the session"}, {"password", "default empty, optional password for the session"}, {"server", "default empty, mandatory, the server"}};

    public DominoHelper getDominoHelper() {
        return this.dh;
    }

    public Session getSession() {
        return this.dh.getSession();
    }

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    @Override
    public void init() {
        super.init();
        String sessionType = this.parameters.getString("sessiontype", "server");
        this.dh = new DominoHelper(this, sessionType);
        this.dh.initThread();
        this.dh.init();
    }

    @Override
    public void term() {
        this.dh.termThread();
        this.dh.term();
    }

    @Override
    public void initThread() {
        this.dh.initThread();
    }

    @Override
    public void termThread() {
        this.dh.termThread();
    }

    @Override
    public String getType() {
        return "DominoNOPReader";
    }

    @Override
    public List read() {
        LinkedList<Document> l = new LinkedList<Document>();
        try {
            if (!this.dh.checkConnection()) {
                return l;
            }
            l.add(IO.makeXMLDocument(this));
        }
        catch (Exception e) {
            this.setError("reading", e);
            this.router.getLog().error(e);
        }
        return l;
    }

    public static String getDescription() {
        return "The DominoNOPReader is similar to the NOPReader but it initialises a Lotus Domino session that is available to scripts, via theio.getSession().";
    }

    public static String getDocumentDesc() {
        return "DominoNOPReader returns a standard document: " + DominoNOPReader.getStandardDocument("DominoNOPReader", "(to be defined)", true);
    }
}

