/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import com.werken.xpath.XPath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.gopro.gdr.IO;
import net.gopro.gdr.IOInfo;
import net.gopro.gdr.Router;
import net.gopro.gdr.Writer;
import net.gopro.gdr.writers.DominoMailWriter;
import net.gopro.gdr.writers.DominoNOPWriter;
import net.gopro.gdr.writers.DominoWriter;
import net.gopro.gdr.writers.FOPWriter;
import net.gopro.gdr.writers.GPWWriter;
import net.gopro.gdr.writers.JDBCWriter;
import net.gopro.gdr.writers.JavaSMTPMailWriter;
import net.gopro.gdr.writers.NOPWriter;
import net.gopro.gdr.writers.SocketWriter;
import net.gopro.gdr.writers.URLWriter;
import org.jdom.Document;
import org.jdom.Element;

public class Writers {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/Writers.java 2     20.09.05 9:38 Kbg $";
    private LinkedList writers = new LinkedList();
    private Router parent;

    public List getWriterList() {
        return this.writers;
    }

    public void stop() {
        for (Writer w : this.writers) {
            w.term();
        }
        this.parent.getLog().info("Writers shutdown");
    }

    Writers(Router parent) {
        this.parent = parent;
    }

    final void load(Element eWriters) {
        try {
            this.writers = new LinkedList();
            Iterator i = eWriters.getChildren().iterator();
            while (i != null && i.hasNext()) {
                Element e = (Element)i.next();
                String enabled = e.getAttributeValue("enabled");
                String stype = e.getAttributeValue("type");
                String sname = e.getAttributeValue("name");
                String msg = "disabled";
                Writer w = this.addWriter(sname, stype);
                if (w != null) {
                    w.initFromElement(e);
                }
                msg = "enabled";
                this.parent.getLog().info(stype + "." + sname + " " + msg);
            }
        }
        catch (Exception e) {
            this.parent.getLog().error(e);
        }
    }

    public final Writer addWriter(String name, String stype) {
        Writer w = null;
        try {
            w = (Writer)Class.forName(stype).newInstance();
        }
        catch (Exception e1) {
            String err1 = "Error loading writer '" + stype + "': " + e1.toString();
            String stype2 = "net.gopro.gdr.writers." + stype;
            try {
                w = (Writer)Class.forName(stype2).newInstance();
            }
            catch (Exception e2) {
                this.parent.getLog().error("Error loading writer '" + stype2 + "': ", e2);
                return null;
            }
        }
        w.name = name;
        w.type = stype;
        w.setRouter(this.parent);
        this.writers.add(w);
        this.parent.getLog().info("Added Writer: " + name + ' ' + stype);
        return w;
    }

    public final void removeWriter(String name) {
        Writer w = this.getWriterByName(name);
        if (w != null) {
            this.writers.remove(w);
        }
    }

    public String report() {
        Iterator i = this.writers.iterator();
        return IO.reportIO(i);
    }

    public List getMatchingWriters(Document d) {
        LinkedList<Writer> lret = new LinkedList<Writer>();
        try {
            for (Writer w : this.writers) {
                String crit = w.parameters.getString("criteria");
                if (null == crit || crit == "" || "/*".equals(crit)) {
                    Writer wNew = null;
                    try {
                        wNew = (Writer)Class.forName(w.getClass().getName()).newInstance();
                        wNew.parameters = w.parameters;
                    }
                    catch (Exception e1) {
                        String err1 = "Error loading writer '" + w.getType() + "': " + e1.toString();
                        String stype2 = "net.gopro.gdr.writers." + w.getType();
                        try {
                            w = (Writer)Class.forName(stype2).newInstance();
                        }
                        catch (Exception e2) {
                            this.parent.getLog().error("Error loading writer '" + stype2 + "': ", e2);
                            return null;
                        }
                    }
                    wNew.name = w.getName();
                    wNew.type = w.getType();
                    wNew.setRouter(this.parent);
                    lret.add(wNew);
                    continue;
                }
                try {
                    boolean bMatch = true;
                    XPath xpath = new XPath(crit);
                    if (xpath.applyTo(d).size() <= 0) continue;
                    Writer wNew = null;
                    try {
                        wNew = (Writer)Class.forName(w.getClass().getName()).newInstance();
                        wNew.parameters = w.parameters;
                    }
                    catch (Exception e1) {
                        String err1 = "Error loading writer '" + w.getType() + "': " + e1.toString();
                        String stype2 = "net.gopro.gdr.writers." + w.getType();
                        try {
                            w = (Writer)Class.forName(stype2).newInstance();
                        }
                        catch (Exception e2) {
                            this.parent.getLog().error("Error loading writer '" + stype2 + "': ", e2);
                            return null;
                        }
                    }
                    wNew.name = w.getName();
                    wNew.type = w.getType();
                    wNew.setRouter(this.parent);
                    lret.add(wNew);
                }
                catch (Exception e1) {
                    w.setError("bad criteria", e1);
                }
            }
        }
        catch (Exception e) {
            this.parent.getLog().error(e);
        }
        return lret;
    }

    public final void setWriterName(String old_name, String new_name) {
        Writer w = this.getWriterByName(old_name);
        if (w != null) {
            w.setName(new_name);
        }
    }

    public Writer getWriterByName(String name) {
        Iterator i = this.writers.iterator();
        try {
            while (i.hasNext()) {
                Writer w = (Writer)i.next();
                if (!w.getName().equals(name)) continue;
                return w;
            }
        }
        catch (Exception e) {
            this.parent.getLog().error(e);
        }
        return null;
    }

    final void addContent(Element root) {
        Element p = new Element("writers");
        root.addContent(p);
        for (Writer w : this.writers) {
            w.addContent(p);
        }
    }

    static {
        String[][] saKnownWriters = new String[][]{{"DominoMailWriter", DominoMailWriter.getDescription(), DominoMailWriter.getDocumentDesc()}, {"DominoWriter", DominoWriter.getDescription(), DominoWriter.getDocumentDesc()}, {"DominoNOPWriter", DominoNOPWriter.getDescription(), DominoNOPWriter.getDocumentDesc()}, {"JDBCWriter", JDBCWriter.getDescription(), JDBCWriter.getDocumentDesc()}, {"JavaSMTPMailWriter", JavaSMTPMailWriter.getDescription(), JavaSMTPMailWriter.getDocumentDesc()}, {"NOPWriter", NOPWriter.getDescription(), NOPWriter.getDocumentDesc()}, {"SocketWriter", SocketWriter.getDescription(), SocketWriter.getDocumentDesc()}, {"URLWriter", URLWriter.getDescription(), URLWriter.getDocumentDesc()}, {"FOPWriter", FOPWriter.getDescription(), FOPWriter.getDocumentDesc()}, {"GPWWriter", GPWWriter.getDescription(), GPWWriter.getDocumentDesc()}};
        for (int i = 0; i < saKnownWriters.length; ++i) {
            IOInfo ioi = new IOInfo(saKnownWriters[i][0], saKnownWriters[i][1], saKnownWriters[i][2]);
            IO.getKnownIOs().put(ioi.getName(), ioi);
        }
    }
}

