/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import is.hugvit.log.Log;
import java.util.Date;
import java.util.Hashtable;
import net.gopro.gdr.Documents;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Parameters;
import org.jdom.Document;
import org.jdom.Element;

public abstract class Writer
extends IO {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/Writer.java 2     20.09.05 9:38 Kbg $";
    Element criteria;
    int totalWritten = 0;
    Date lastWrite = null;
    boolean bReturnToRouter = false;
    public final int UPDATEONLY = 1;
    public final int CREATEONLY = 2;
    public final int BOTH = 4;
    private int action = 4;
    private static String[][] paramInfo = new String[][]{{"action", "both", "default both, optional.  The following options are available:<ul><li><code>updateonly</code> then the datasource will be updated only<li><code>createonly</code> then the document will be added to the datasource<li><code>both</code> then the datasource will be updated if corresponding document is found,but a new one created if not</ul> NB: this does not apply to all writers"}, {"enabled", "false", "Specifies if this writer is enabled or not.  The following options are available:<ul><li><code>true</code> The writer is enabled<li><code>false</code> The writer is disabled"}, {"retryonfailure", "false", "default false, optional.  If specified then the writer will retry on failure.NB: this does not apply to all writers"}, {"returntorouter", "false", "default false, optional.  If specified then the document will be returned to the router for further processing after writing has been done"}, {"criteria", "/*", "default <code>/*</code> which matches all documents, optional.  If specified then this XPATH criteria will be used to select the documents applicabe to this writer. If empty all documents go this writer."}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][2]);
            h.put(name, p);
        }
        return h;
    }

    public Writer() {
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            String value = paramInfo[i][1];
            if (name.equals("retryonfailure") || name.equals("returntorouter")) continue;
            this.parameters.putString(name, value);
        }
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(String s) {
        this.action = s.toLowerCase().equals("updateonly") ? 1 : (s.toLowerCase().equals("createonly") ? 2 : 4);
    }

    @Override
    public void initFromElement(Element element) {
        super.initFromElement(element);
        this.setAction(this.parameters.getString("action"));
        String saction = "BOTH";
        if (this.action == 1) {
            saction = "UPDATEONLY";
        } else if (this.action == 2) {
            saction = "CREATEONLY";
        }
        this.parameters.put("action", saction);
        this.bReturnToRouter = this.parameters.getBoolean("returntorouter", false);
    }

    public void incWrite() {
        this.lastWrite = new Date();
        ++this.totalWritten;
    }

    @Override
    public Parameters getParameters() {
        super.getParameters();
        if (this.criteria != null) {
            this.parameters.put("criteria", this.criteria.toString());
        }
        if (this.lastWrite != null) {
            this.parameters.put("last write", this.lastWrite.toString(), "MX");
        }
        this.parameters.put("total written", "" + this.totalWritten, "MX");
        return this.parameters;
    }

    void executeAndWrite(Document d) {
        Log log = this.getRouter().getLog();
        if ((d = this.execute(d, true)) == null) {
            log.warn(this.getType() + "." + this.getName() + " canceling write because of an empty document");
            return;
        }
        String dir = this.getRouter().getDebugDir();
        if (dir != null && !dir.equals("")) {
            this.setDumpFile(Documents.dump(this, d));
        }
        int rc = 0;
        this.initThread();
        rc = this.write(d);
        if (rc > 0) {
            boolean bRetry = this.parameters.getBoolean("retryonfailure", false);
            String msg = " writing failed with return code " + rc;
            if (bRetry) {
                this.getRouter().getDocuments().put(d);
                msg = msg + ", returned document to que";
            }
            msg = this.getType() + "." + this.getName() + msg;
            log.error(msg);
            this.setError("executing and writing", msg);
        } else {
            this.incWrite();
        }
        this.termThread();
        if (d != null && this.bReturnToRouter) {
            Element root = d.getRootElement();
            if (root == null) {
                return;
            }
            String round = root.getAttributeValue("round");
            if (round == null) {
                round = "0";
                root.setAttribute("round", "0");
            }
            int iRound = Integer.parseInt(round) + 1;
            String desc = d.getRootElement().getAttributeValue("description");
            if (desc == null) {
                desc = "document with no description";
            }
            if (iRound < this.getRouter().getMaxRounds()) {
                root.setAttribute("round", Integer.toString(iRound));
                this.getRouter().getDocuments().put(d);
                log.info("Returning document '" + desc + "', round " + iRound + ", to router");
            } else {
                log.info("NOT returning document '" + desc + "' to router.  Allowed rounds have been used");
            }
        }
    }

    public abstract int write(Document var1);

    final void addContent(Element root) {
        Element e = new Element("writer");
        e.setAttribute("name", this.name);
        e.setAttribute("type", this.type);
        this.parameters.addContent(e);
        root.addContent(e);
    }
}

