/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import is.hugvit.log.Log;
import net.gopro.gdr.Router;
import net.gopro.gdr.RouterXMLRPC;
import net.gopro.gdr.RouterXMLRPCHandler;
import org.apache.xmlrpc.WebServer;

class RouterXMLRPCThread
extends Thread {
    RouterXMLRPC parent;
    WebServer ws;
    RouterXMLRPCHandler rxh;
    Router router;
    volatile boolean thread_run;
    int port;
    final int THREAD_SLEEP = 100;

    public RouterXMLRPCThread(RouterXMLRPC parent, int port) {
        super("RouterXMLRPCThread");
        this.parent = parent;
        this.port = port;
        this.router = parent.router;
    }

    public void shutdown() {
        if (this.ws != null) {
            this.ws.shutdown();
            this.ws = null;
            this.rxh = null;
        }
        this.thread_run = false;
        try {
            Thread.sleep(1100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.router.getLog().info("XMLRPC shutdown");
    }

    @Override
    public void run() {
        Log log = this.router.getLog();
        try {
            this.ws = new WebServer(this.port);
            this.rxh = new RouterXMLRPCHandler(this.parent.getRouter());
            this.ws.addHandler("gdr", (Object)this.rxh);
            this.ws.start();
            log.info("XMLRPC Created WS, will now go to sleep");
            this.thread_run = true;
            while (this.thread_run) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {}
            }
            log.debug("XMLRPC going down");
        }
        catch (Exception e) {
            log.error(e);
        }
    }
}

