/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import is.hugvit.log.Log;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import net.gopro.gdr.Documents;
import net.gopro.gdr.IO;
import net.gopro.gdr.Reader;
import net.gopro.gdr.Router;
import org.apache.xmlrpc.XmlRpcHandler;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

class RouterXMLRPCHandler
implements XmlRpcHandler {
    Router router;

    RouterXMLRPCHandler(Router router) {
        this.router = router;
    }

    public Object execute(String methodName, Vector params) throws Exception {
        if (methodName.equals("kick")) {
            return this.kick(params);
        }
        if (methodName.equals("put")) {
            return this.put(params);
        }
        if (methodName.equals("putGoProDocument")) {
            if (params.elementAt(0) instanceof Hashtable) {
                Hashtable h = (Hashtable)params.elementAt(0);
                return this.putGoProDocument(h);
            }
            if (params.elementAt(0) instanceof Vector) {
                Vector v = (Vector)params.elementAt(0);
                return this.putGoProDocument(v);
            }
        }
        String msg = "XMLRPC received unknown command: " + methodName;
        this.router.getLog().warn(msg);
        return msg + ".\n" + this.help();
    }

    String help() {
        String msg = "Supported commands are: \n   gdr.kick(String readerName, Hashtable parameters)\n   gdr.put(String xmldoc)\n";
        return msg;
    }

    String kick(Vector params) {
        Log log = this.router.getLog();
        String msg = "XMLRPC Missing reader parameter";
        try {
            log.debug("XMLRPC kick");
            if (params.size() == 0) {
                log.error(msg);
                return msg;
            }
            msg = "XMLRPC bad reader name";
            String sreader = (String)params.elementAt(0);
            if (sreader == null) {
                log.error(msg);
                return msg;
            }
            msg = "XMLRPC unable to find reader: " + sreader;
            Reader r = this.router.getReaders().getReaderByName(sreader);
            if (r == null) {
                log.error(msg);
                return msg;
            }
            if (params.size() > 1) {
                Hashtable h = (Hashtable)params.elementAt(1);
                if (h == null) {
                    log.warn("XMLRPC kick: received bad hashtable for parameters. Continuing anyway");
                }
                r.parameters.putAll(h);
            }
            r.kick();
            msg = "XMLRPC kicked " + sreader + " succsessfully";
            log.info(msg);
            return msg;
        }
        catch (Exception e) {
            log.error(e);
            return "ERROR " + msg;
        }
    }

    String put(Vector params) {
        Log log = this.router.getLog();
        String msg = "XMLRPC put: Missing document to put";
        try {
            log.debug("XMLRPC put ");
            if (params.size() == 0) {
                log.error(msg);
                return msg;
            }
            msg = "XMLRPC put: bad document to put";
            String sdoc = (String)params.elementAt(0);
            if (sdoc == null) {
                log.error(msg);
                return msg;
            }
            msg = "XMLRPC put: unable to construct proper XML doc";
            StringReader sr = new StringReader(sdoc);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((java.io.Reader)sr);
            this.router.getDocuments().put(doc);
            msg = "XMLRPC put document successfully";
            return msg;
        }
        catch (Exception e) {
            log.error(e);
            return "ERROR " + msg;
        }
    }

    String putGoProDocument(Hashtable doc) {
        Log log = this.router.getLog();
        String msg = "XMLRPC put: Missing document to put";
        try {
            Document jDoc = null;
            log.debug("XMLRPC putGoProDoc ");
            if (doc.size() == 0) {
                log.error(msg);
                return msg;
            }
            msg = "XMLRPC put: bad document to put. Not a GoPro document";
            String strForm = (String)doc.get("document.form");
            if (strForm == null) {
                log.error(msg);
                return msg;
            }
            if (this.initFieldMapping(strForm)) {
                jDoc = this.makeJDOMDocument(doc);
            }
            Documents.dump(this.router, "XMLRpc", "RouterXMLRPC", jDoc);
            msg = "XMLRPC put: unable to construct proper XML doc";
            this.router.getDocuments().put(jDoc);
            msg = "XMLRPC put document successfully";
            return msg;
        }
        catch (Exception e) {
            log.error(e);
            return "ERROR " + msg;
        }
    }

    String putGoProDocument(Vector vec) {
        Log log = this.router.getLog();
        String msg = "XMLRPC put: Missing document to put";
        try {
            Document jDoc = null;
            Hashtable h = null;
            log.debug("XMLRPC putGoProDoc ");
            if (vec.size() == 0) {
                log.error(msg);
                return msg;
            }
            Enumeration e = vec.elements();
            while (e.hasMoreElements()) {
                h = (Hashtable)e.nextElement();
                String strForm = (String)h.get("document.form");
                log.debug(strForm);
                if (!this.isMainDoc(strForm)) continue;
                log.debug("1 create main doc");
                jDoc = this.makeJDOMDocument(h);
                log.debug("2 create resp doc");
                jDoc = this.makeJDOMResponseDocuments(vec, jDoc);
                log.debug("3 last");
            }
            Documents.dump(this.router, "XMLRpc", "RouterXMLRPC", jDoc);
            msg = "XMLRPC put: unable to construct proper XML doc";
            this.router.getDocuments().put(jDoc);
            msg = "XMLRPC put document successfully";
            return msg;
        }
        catch (Exception e) {
            log.error(e);
            return "ERROR " + msg;
        }
    }

    private boolean initFieldMapping(String strForm) {
        return true;
    }

    private Document makeJDOMDocument(Hashtable doc) {
        Document jdoc = IO.makeXMLDocument("Stuff", "noType", "Stuff");
        try {
            Element root = jdoc.getRootElement();
            Element eitems = new Element("items");
            Enumeration e = doc.keys();
            while (e.hasMoreElements()) {
                String sName = (String)e.nextElement();
                Element eitem = new Element("item");
                eitem.setAttribute("name", sName);
                Object value = doc.get(sName);
                if (value instanceof Vector) {
                    Vector vValues = (Vector)value;
                    if (vValues != null && vValues.size() > 1) {
                        eitem.setAttribute("type", "LIST");
                        for (int i = 0; i < vValues.size(); ++i) {
                            Element listitem = new Element(sName);
                            listitem.addContent(vValues.elementAt(i).toString());
                            eitem.addContent(listitem);
                        }
                    } else if (vValues != null && vValues.size() == 1) {
                        eitem.setAttribute("type", "TEXT");
                        eitem.addContent(vValues.elementAt(0).toString());
                    }
                } else {
                    String sValue = "";
                    if (value == null) continue;
                    sValue = (String)value;
                    eitem.addContent(sValue);
                }
                eitems.addContent(eitem);
            }
            root.addContent(eitems);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jdoc;
    }

    private Document makeJDOMResponseDocuments(Vector vec, Document parent) {
        net.gopro.util.Log.println("makeJDOMResponseDocuments - " + vec.size());
        Vector temp = new Vector();
        Hashtable h = null;
        Object resp = null;
        Document jDoc = null;
        try {
            Enumeration e = vec.elements();
            while (e.hasMoreElements()) {
                h = (Hashtable)e.nextElement();
                String strForm = (String)h.get("document.form");
                if (this.isMainDoc(strForm)) continue;
                jDoc = this.makeJDOMDocument(h);
                if (jDoc != null) {
                    Element root = parent.getRootElement();
                    Element rootResp = jDoc.getRootElement();
                    Element rootRespNew = new Element("responsedoc");
                    List l = rootResp.getChildren();
                    rootRespNew.setChildren(l);
                    root.addContent(rootRespNew);
                }
                temp = (Vector)vec.clone();
                temp.removeElementAt(vec.indexOf(h));
                if (temp.size() <= 0) continue;
                jDoc = this.makeJDOMResponseDocuments(temp, jDoc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jDoc;
    }

    private boolean isMainDoc(String form) {
        return "maindoc".equalsIgnoreCase(form);
    }
}

