/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import net.gopro.gdr.Router;
import net.gopro.gdr.RouterXMLRPCThread;

public class RouterXMLRPC {
    Router router;
    RouterXMLRPCThread rxt = null;

    public RouterXMLRPC(Router router) {
        this.router = router;
    }

    public Router getRouter() {
        return this.router;
    }

    public void stop() {
        if (this.rxt != null) {
            this.rxt.shutdown();
        }
    }

    public void serve(int port) {
        if (port == 0) {
            this.router.getLog().info("XMLRPC disabled because of a 0 port");
            return;
        }
        try {
            this.rxt = new RouterXMLRPCThread(this, port);
            this.rxt.start();
            this.router.getLog().info("XMLRPC started on port " + port);
        }
        catch (Exception e) {
            this.router.getLog().error("Unable to start XMLRPC on port " + port, e);
        }
    }
}

