/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import is.hugvit.log.Log;
import is.hugvit.log.NullLog;
import is.hugvit.log.SystemLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdr.CMDLineParser;
import net.gopro.gdr.Documents;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Parameters;
import net.gopro.gdr.Readers;
import net.gopro.gdr.RouterThread;
import net.gopro.gdr.RouterXMLRPC;
import net.gopro.gdr.Version;
import net.gopro.gdr.Writer;
import net.gopro.gdr.Writers;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class Router
implements Runnable {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/Router.java 1     23.06.03 15:18 Kbg $";
    private static Documents dq;
    private Readers readers;
    private Writers writers;
    private RouterXMLRPC routerXMLRPC = null;
    private CMDLineParser cmdline = null;
    private Date startDate;
    private int iMaxRounds = 4;
    private long startTime;
    private long docsSentToWriters = 0L;
    private boolean bInitOK = false;
    private static Hashtable hKnownParameters;
    private String sWebURI = "/";
    private File webroot;
    private int iConcurrentWriters = 4;
    private int iXMLRPCPort = 11;
    private File file;
    private volatile boolean stop_flag;
    private volatile Thread thread;
    private ThreadGroup activeWriters;
    private String name;
    private Log log;
    private Parameters parameters = new Parameters(this);
    static String[][] paramInfo;

    public int getMaxRounds() {
        return this.iMaxRounds;
    }

    public static Hashtable getKnownParameters() {
        return hKnownParameters;
    }

    String getDebugDir() {
        return this.parameters.getString("debugdir");
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setFile(File file) {
        this.file = file;
    }

    public final Log getLog() {
        return this.log;
    }

    public Documents getDocuments() {
        return dq;
    }

    public final void put(Document doc) {
        dq.put(doc);
        this.thread.interrupt();
    }

    public Readers getReaders() {
        return this.readers;
    }

    public Writers getWriters() {
        return this.writers;
    }

    public String getWebURI() {
        return this.sWebURI;
    }

    public final void setWebURI(String s) {
        this.sWebURI = s;
    }

    public final void setWebRoot(String s) {
        this.webroot = new File(s);
    }

    public final String getWebRoot() {
        return this.webroot == null ? null : this.webroot.getAbsolutePath();
    }

    public final boolean isStopping() {
        return this.stop_flag;
    }

    public Router(File file, Log log, boolean bInteractive) {
        try {
            this.file = file;
            this.log = log;
            this.startDate = new Date();
            for (int i = 0; i < paramInfo.length; ++i) {
                String name = paramInfo[i][0];
                String value = paramInfo[i][1];
                this.parameters.putString(name, value);
            }
            this.load();
            this.bInitOK = true;
            this.startTime = System.currentTimeMillis();
            dq = new Documents(this);
            boolean usexmlrpc = this.parameters.getBoolean("usexmlrpc", false);
            this.iXMLRPCPort = this.parameters.getInt("xmlrpcport", 11);
            if (usexmlrpc && this.iXMLRPCPort > 0) {
                this.routerXMLRPC = new RouterXMLRPC(this);
            }
            if (bInteractive) {
                this.cmdline = new CMDLineParser(this);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    String report() {
        return this.parameters.report();
    }

    public Parameters getParameters() {
        this.parameters.put("started", this.startDate.toString(), "MX");
        this.parameters.put("docs written", "" + this.docsSentToWriters, "MX");
        this.parameters.put("docs processed", "" + this.getDocuments().getDocumentsProcessed(), "MX");
        this.parameters.put("elapsed time", this.mkelapsed(this.getElapsedTime()), "MX");
        return this.parameters;
    }

    public final void setParameter(String name, String value) {
        this.parameters.put(name, value);
        this.refreshParameters();
    }

    public final void removeParameter(String name) {
        this.parameters.remove(name);
    }

    private String mkelapsed(long e) {
        int s = (int)(e / 1000L);
        s = s == 0 ? 1 : s;
        int m = s / 60;
        s %= 60;
        int h = m / 60;
        int d = h / 24;
        String sret = "";
        sret = sret + (d > 0 ? d + " day(s) " : "");
        sret = sret + (h > 0 ? (h %= 24) + " hour(s) " : "");
        sret = sret + (m > 0 ? (m %= 60) + " minute(s) " : "");
        sret = sret + (s > 0 ? s + " second(s) " : "");
        return sret;
    }

    private final void load() {
        this.readers = new Readers(this);
        this.writers = new Writers(this);
        if (this.file != null && this.file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.file);
                SAXBuilder builder = new SAXBuilder();
                Document doc = new Document();
                doc = builder.build((InputStream)fis);
                fis.close();
                Element root = doc.getRootElement();
                if (root != null) {
                    this.name = root.getAttributeValue("name");
                    Element p = root.getChild("parameters");
                    if (p != null) {
                        this.parameters.addFromElement(p);
                        this.refreshParameters();
                        Element r = root.getChild("readers");
                        Element w = root.getChild("writers");
                        if (r != null) {
                            this.readers.load(r);
                        }
                        if (w != null) {
                            this.writers.load(w);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.error("Error parsing init file " + this.file.getAbsoluteFile(), e);
                return;
            }
        }
    }

    public final void save() throws IOException {
        Element root = new Element("gdr");
        if (this.name != null) {
            root.setAttribute("name", this.name);
        }
        Document doc = new Document(root);
        this.parameters.addContent(root);
        this.readers.addContent(root);
        this.writers.addContent(root);
        XMLOutputter xo = new XMLOutputter();
        xo.setEncoding("ISO-8859-1");
        xo.setIndent(true);
        xo.setIndentSize(2);
        xo.setNewlines(true);
        FileOutputStream fos = new FileOutputStream(this.file);
        xo.output(doc, (OutputStream)fos);
        fos.close();
    }

    private final void refreshParameters() {
        String s = this.parameters.getString("loglevel", "INFO");
        this.log.setLevel(NullLog.getLogLevel((String)s));
        this.iMaxRounds = this.parameters.getInt("maxrounds", 4);
        this.iXMLRPCPort = this.parameters.getInt("xmlrpcport", 11);
        this.iConcurrentWriters = this.parameters.getInt("concurrentwriters", 4);
        this.iConcurrentWriters = this.iConcurrentWriters > 0 ? this.iConcurrentWriters : 4;
    }

    public final void start() {
        this.thread = new Thread(this);
        this.stop_flag = false;
        this.thread.start();
    }

    public void stop() {
        while (dq.size() > 0 || this.activeWriters.activeCount() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        this.stop_flag = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.readers.stop();
        this.writers.stop();
        if (this.routerXMLRPC != null) {
            this.routerXMLRPC.stop();
        }
        if (this.cmdline != null) {
            this.cmdline.stop();
        }
        this.cmdline = null;
    }

    private final void serve() {
        try {
            if (!this.bInitOK) {
                return;
            }
            this.readers.serve();
            if (this.cmdline != null) {
                this.cmdline.serve();
            }
            if (this.routerXMLRPC != null) {
                this.routerXMLRPC.serve(this.iXMLRPCPort);
            }
            this.activeWriters = new ThreadGroup("writers");
            while (!this.stop_flag) {
                if (dq.size() > 0) {
                    Document d = dq.get();
                    while (d != null && this.writers != null) {
                        List l = this.writers.getMatchingWriters(d);
                        this.log.debug("Finding writers:" + l);
                        Iterator i = l.iterator();
                        while (i.hasNext()) {
                            ++this.docsSentToWriters;
                            new RouterThread(this, (Writer)i.next(), (Document)d.clone(), this.activeWriters).start();
                        }
                        while (this.activeWriters.activeCount() >= this.iConcurrentWriters && dq.size() > 0 && !this.stop_flag) {
                            try {
                                this.log.debug("Waiting for writers: " + this.activeWriters.activeCount() + " are active - waiting on queue " + dq.size());
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException je) {}
                        }
                        d = dq.get();
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException je) {}
            }
            this.log.info("Server shutdown");
        }
        catch (Exception e) {
            this.log.error(e);
        }
    }

    static final void copyright() {
        System.out.println("\n\n" + Version.name() + ", " + Version.version() + ", " + Version.date() + "\n" + Version.copyright() + "\n");
    }

    long getElapsedTime() {
        long currentTime = System.currentTimeMillis();
        long total = currentTime - this.startTime;
        return total;
    }

    static final void help() {
        Router.copyright();
        System.out.println("Usage: java -classpath <jars> net.gopro.gdr.Router <setup script>");
    }

    @Override
    public final void run() {
        this.serve();
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                Router.help();
                return;
            }
            String filename = args[0];
            Router r = new Router(new File(filename), (Log)new SystemLog(), true);
            r.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        hKnownParameters = new Hashtable();
        paramInfo = new String[][]{{"debug", "false", "default false, optional, when specified, all debug informations will be displayed on the console and put into the log file. If you have to report a bug to <a href=\\\"http://www.gopro.net\\\">GoPro Development</a> please run GoPro XML Router at least once with this flag set and send the log files along with the bug informations."}, {"loglevel", "INFO", "default INFO, specifies the level of the log can have values DEBUG,INFO,WARN,ERROR"}, {"visible", "false", "default false, specifies if this router is visible to the outside world as a web service"}, {"concurrentwriters", "4", "default 4, mandatory.  Specifies the number of concurrent writers"}, {"maxrounds", "4", "default 4, mandatory.  Specifies the maximum rounds a document can be returned to the router by a writer"}, {"usexmlrpc", "false", "default false, mandatory.  Specifies if XMLRPC is used."}, {"xmlrpcport", "11", "default 11, mandatory.  Specifies the port number for the XMLRPC interface.   On this port it accepts the following commands:<ul><li><code>gdr.kick(String)</code> with a reader name as parameter</li><li><code>gdr.put(String)</code> with a XML document as a parameter</li></ul>"}, {"maxrounds", "4", "default 4, mandatory.  Specifies the maximum rounds a document can be returned to the router by a writer"}, {"debugdir", "", "default empty, optional, when specified, all documents going through GoPro XML Router will be saved there. This can be very helpfull when debugging data transformations and for data recovery."}};
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][2]);
            hKnownParameters.put(name, p);
        }
    }
}

