/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import is.hugvit.log.Log;
import net.gopro.gdr.Reader;
import net.gopro.gdr.Readers;

class ReadersThread
extends Thread {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/ReadersThread.java 1     23.06.03 15:18 Kbg $";
    Readers parent;
    Reader reader;
    volatile boolean stop_thread;

    public void stopThread() {
        this.stop_thread = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ReadersThread(Readers parent, Reader reader) {
        super("ReadersThread");
        this.parent = parent;
        this.reader = reader;
    }

    public final Reader getReader() {
        return this.reader;
    }

    @Override
    public void run() {
        Log log = this.reader.getRouter().getLog();
        this.reader.init();
        if (this.reader.getRunOnStartup()) {
            log.info("Activating " + this.reader.getName());
            this.reader.readAndExecute();
            log.info("Done with " + this.reader.getName());
        }
        while (!this.stop_thread) {
            if (this.reader.getKick()) {
                log.info("Kicking " + this.reader.getName());
                this.reader.readAndExecute();
                log.info("Done with kicking " + this.reader.getName());
                this.reader.setKick(false);
            }
            try {
                long interval = this.reader.getInterval();
                if (interval == 0L) {
                    interval = 60L;
                }
                interval *= 1000L;
                if (this.stop_thread) continue;
                Thread.sleep(interval);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.reader.term();
    }
}

