/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.gopro.gdr.IO;
import net.gopro.gdr.IOInfo;
import net.gopro.gdr.Reader;
import net.gopro.gdr.ReadersThread;
import net.gopro.gdr.Router;
import net.gopro.gdr.readers.DominoNOPReader;
import net.gopro.gdr.readers.DominoSearchReader;
import net.gopro.gdr.readers.DominoViewReader;
import net.gopro.gdr.readers.JDBCReader;
import net.gopro.gdr.readers.MailReader;
import net.gopro.gdr.readers.NOPReader;
import net.gopro.gdr.readers.SocketReader;
import net.gopro.gdr.readers.TxtDelimitedReader;
import net.gopro.gdr.readers.TxtFixedWidthReader;
import net.gopro.gdr.readers.URLReader;
import org.jdom.Element;

public class Readers {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/Readers.java 2     20.09.05 9:38 Kbg $";
    private LinkedList readerList = new LinkedList();
    private LinkedList threadList = new LinkedList();
    private Router parent;

    public List getReaderList() {
        return this.readerList;
    }

    public void stop() {
        for (ReadersThread r : this.threadList) {
            r.stopThread();
        }
        this.parent.getLog().info("Readers shutdown");
    }

    Readers(Router parent) {
        this.parent = parent;
    }

    final void load(Element e) {
        try {
            Iterator i = e.getChildren().iterator();
            while (i != null && i.hasNext()) {
                Element f = (Element)i.next();
                String stype = f.getAttributeValue("type");
                String sname = f.getAttributeValue("name");
                Reader r = this.addReader(sname, stype);
                if (r != null) {
                    r.initFromElement(f);
                }
                this.parent.getLog().info(stype + "." + sname + " loaded");
            }
        }
        catch (Exception ex) {
            this.parent.getLog().error(ex);
        }
    }

    public final Reader addReader(String name, String stype) {
        ReadersThread rt;
        Reader r = null;
        try {
            r = (Reader)Class.forName(stype).newInstance();
        }
        catch (Exception e1) {
            String err1 = "Error loading reader '" + stype + "': " + e1.toString();
            String stype2 = "net.gopro.gdr.readers." + stype;
            try {
                r = (Reader)Class.forName(stype2).newInstance();
                this.parent.getLog().debug("loaded reader of type " + stype2);
            }
            catch (Exception e2) {
                this.parent.getLog().error("Loading reader '" + stype2 + "': " + e2);
                return null;
            }
        }
        r.name = name;
        r.type = stype;
        r.setRouter(this.parent);
        r.thread = rt = new ReadersThread(this, r);
        this.readerList.add(r);
        this.threadList.add(rt);
        rt.start();
        this.parent.getLog().info("Added Reader: " + name + ' ' + stype);
        return r;
    }

    public final void removeReader(String name) {
        for (ReadersThread rt : this.threadList) {
            Reader r = rt.getReader();
            if (!r.getName().equals(name)) continue;
            rt.stopThread();
            this.threadList.remove(rt);
            this.readerList.remove(r);
            return;
        }
    }

    public void serve() {
        for (Reader r : this.readerList) {
            ReadersThread rt = new ReadersThread(this, r);
            rt.start();
            this.threadList.add(rt);
        }
    }

    public final void setReaderName(String old_name, String new_name) {
        Reader r = this.getReaderByName(old_name);
        if (r != null) {
            r.setName(new_name);
        }
    }

    public Reader getReaderByName(String name) {
        Iterator i = this.readerList.iterator();
        try {
            while (i.hasNext()) {
                Reader r = (Reader)i.next();
                if (!r.getName().equals(name)) continue;
                return r;
            }
        }
        catch (Exception e) {
            this.parent.getLog().error(e);
        }
        return null;
    }

    public String report() {
        Iterator i = this.readerList.iterator();
        return IO.reportIO(i);
    }

    final void addContent(Element root) {
        Element p = new Element("readers");
        root.addContent(p);
        for (Reader r : this.readerList) {
            r.addContent(p);
        }
    }

    static {
        String[][] saKnownReaders = new String[][]{{"NOPReader", NOPReader.getDescription(), NOPReader.getDocumentDesc()}, {"DominoSearchReader", DominoSearchReader.getDescription(), DominoSearchReader.getDocumentDesc()}, {"DominoViewReader", DominoViewReader.getDescription(), DominoViewReader.getDocumentDesc()}, {"DominoNOPReader", DominoNOPReader.getDescription(), DominoNOPReader.getDocumentDesc()}, {"JDBCReader", JDBCReader.getDescription(), JDBCReader.getDocumentDesc()}, {"SocketReader", SocketReader.getDescription(), SocketReader.getDocumentDesc()}, {"TxtFixedWidthReader", TxtFixedWidthReader.getDescription(), TxtFixedWidthReader.getDocumentDesc()}, {"TxtDelimitedReader", TxtDelimitedReader.getDescription(), TxtDelimitedReader.getDocumentDesc()}, {"URLReader", URLReader.getDescription(), URLReader.getDocumentDesc()}, {"MailReader", MailReader.getDescription(), MailReader.getDocumentDesc()}};
        for (int i = 0; i < saKnownReaders.length; ++i) {
            IOInfo ioi = new IOInfo(saKnownReaders[i][0], saKnownReaders[i][1], saKnownReaders[i][2]);
            IO.getKnownIOs().put(ioi.getName(), ioi);
        }
    }
}

