/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdr.Documents;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Parameters;
import net.gopro.gdr.ReadersThread;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public abstract class Reader
extends IO {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/Reader.java 1     23.06.03 15:18 Kbg $";
    private int totalRead = 0;
    private int totalManualRead = 0;
    private int totalKicked = 0;
    private Date lastRead = null;
    private volatile boolean bkick = false;
    ReadersThread thread;
    private static String[][] paramInfo = new String[][]{{"interval", "default 0, optional Number of seconds between invokation of the reader. Default is 0 which means that it will not be automatically invoked, but can be read via the servlet access or kick started."}, {"maxreturn", "default 0, optional, Max number of documents returned. Default is 0 which means that all documents found will be returned."}, {"runonstartup", "default false, optional, specifies whether or not the reader should be run when the router is started or reloaded."}, {"xmlencoding", "default ISO-8859-1, optional, specifies the character encoding ", "upon generating the XML document"}, {"xmlexpandemptyelements", "default false, optional, if specified, empty elements are expanded from &lt;element/&gt; to &lt;element&gt;&lt;/element&gt;"}, {"xmlindent", "default false, optional, specifies wheter or not to indent the XML document"}, {"xmlindentsize", "default 3, optional, sets the indent size; an indent-size of 4 would result in the indentation being equivalent to four spaces"}, {"xmlnewlines", "default false, optional, sets wheter or not newlines will be output"}, {"xmlomitdeclaration", "default false, optional, sets wheter the XML declaration <code><? xml version=\"1.0\" ... ?></code> will be output in the XML document."}, {"xmlomitencoding", "default false, optional, Sets wheter the character encoding part of the XML declaration &lt;? .. encoding=\"ISO-8859-1\" .. ?&gt; will beoutput in the XML document."}, {"xmltextnormalize", "default false, optional, This will set whether the text isoutput verbatim (false) or with whitespace normalized per element"}};

    @Override
    public Hashtable getKnownParameters() {
        Hashtable h = super.getKnownParameters();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = paramInfo[i][0];
            Parameter p = new Parameter(name, null);
            p.setDescription(paramInfo[i][1]);
            h.put(name, p);
        }
        return h;
    }

    public static String getStandardDocument(String iotype, String ioname, boolean bClose) {
        Date d = new Date();
        return "<code><br>&lt;?xml version=\\\"1.0\\\" encoding=\\\"ISO-8859-1\\\"?&gt;<br>&nbsp;&nbsp;&nbsp;&lt;document date=\\\"" + d.toString() + "\\\"<br>" + "&nbsp;&nbsp;&nbsp;io-type=\\\"net.gopro.gdr." + iotype + "\\\"<br>" + "&nbsp;&nbsp;&nbsp;io-name=\\\"" + ioname + "\\\"<br>" + "&nbsp;&nbsp;&nbsp;router-version=\\\"" + Reader.getRouterVersion() + "\\\"<br>" + "&nbsp;&nbsp;&nbsp;description=\\\"net.gopro.gdr." + iotype + " document created by " + ioname + " on " + d.toString() + "\\\" " + (bClose ? "/" : "") + "&gt;</code>";
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public Parameters getParameters() {
        super.getParameters();
        this.parameters.put("read", "" + this.totalRead, "MX");
        this.parameters.put("manual read", "" + this.totalManualRead, "MX");
        this.parameters.put("kicked", "" + this.totalKicked, "MX");
        if (this.lastRead != null) {
            this.parameters.put("last read", this.lastRead.toString(), "MX");
        }
        return this.parameters;
    }

    public int getInterval() {
        int i = this.parameters.getInt("interval");
        return i;
    }

    public int getMaxReturn() {
        int i = this.parameters.getInt("maxreturn");
        if (i == 0) {
            i = Integer.MAX_VALUE;
            this.parameters.putInt("maxreturn", i);
        }
        return i;
    }

    boolean getRunOnStartup() {
        return this.parameters.getBoolean("runonstartup", false);
    }

    public void incRead() {
        this.lastRead = new Date();
        ++this.totalRead;
    }

    public void incManualRead() {
        ++this.totalManualRead;
    }

    public void incKicked() {
        ++this.totalKicked;
    }

    public boolean getKick() {
        return this.bkick;
    }

    public void setKick(boolean bkick) {
        this.bkick = bkick;
    }

    public void kick() {
        this.bkick = true;
        ++this.totalKicked;
        this.thread.interrupt();
    }

    public final void kickAndWait() {
        this.kick();
        while (this.bkick) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final boolean isRunning() {
        return this.bkick;
    }

    void readAndExecute() {
        int iter = 0;
        while (!this.getRouter().getDocuments().isEmpty()) {
            ++iter;
            if (this.getRouter().isStopping()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        if (iter > 0) {
            this.getRouter().getLog().info(this.getType() + " waited (" + iter + ") iterations");
        }
        List l = this.read();
        this.getRouter().getLog().debug("read returns list of " + l.size());
        if (!l.isEmpty()) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                if (this.getRouter().isStopping()) {
                    return;
                }
                this.incRead();
                Document d = (Document)i.next();
                d = this.execute(d, true);
                String dir = this.getRouter().getDebugDir();
                if (dir != null && !dir.equals("")) {
                    try {
                        this.setDumpFile(Documents.dump(this, d));
                    }
                    catch (Exception e1) {
                        this.getRouter().getLog().error(e1);
                    }
                }
                this.getRouter().getDocuments().put(d);
            }
        }
    }

    public void readAndExecuteIntoStream(OutputStream out, boolean bxslt) {
        try {
            List lret = this.read(1);
            if (!lret.isEmpty()) {
                this.incRead();
                this.incManualRead();
                Document d = (Document)lret.get(0);
                d = this.execute(d, bxslt);
                String dir = this.getRouter().getDebugDir();
                if (dir != null && !dir.equals("")) {
                    this.setDumpFile(Documents.dump(this, d));
                }
                XMLOutputter xmlout = Reader.makeXMLOutputter(this);
                xmlout.output(d, out);
            }
        }
        catch (Exception e) {
            this.setError("executing into stream", e);
            this.getRouter().getLog().error(e);
        }
    }

    public List read(int n) {
        int old = this.getMaxReturn();
        this.parameters.putInt("maxreturn", 1);
        List l = this.read();
        this.parameters.putInt("maxreturn", old);
        return l;
    }

    public abstract List read();

    final void addContent(Element root) {
        Element e = new Element("reader");
        e.setAttribute("name", this.name);
        e.setAttribute("type", this.type);
        this.parameters.addContent(e);
        root.addContent(e);
    }
}

