/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import is.hugvit.log.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.gopro.gdr.Router;
import org.jdom.Element;

public class Parameters {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/Parameters.java 2     20.09.05 9:38 Kbg $";
    Hashtable param = new Hashtable();
    Hashtable paramAttr = new Hashtable();
    private static final HashMap ignore = new HashMap();
    private Router router;

    private Parameters() {
    }

    public Parameters(Router router) {
        this.router = router;
    }

    public final void setRouter(Router router) {
        this.router = router;
    }

    public boolean isRO(String name) {
        return this.isAttribute(name, "X");
    }

    public Object[] getOrderedKeyArray() {
        Object[] sa = this.param.keySet().toArray();
        Arrays.sort(sa);
        return sa;
    }

    public boolean isMandatory(String name) {
        return this.isAttribute(name, "M");
    }

    boolean isAttribute(String name, String a) {
        String att = (String)this.paramAttr.get(name);
        return att != null && att.indexOf(a) > -1;
    }

    public Object put(String name, Object o, String att) {
        this.putAttribute(name, att);
        return this.put(name, o);
    }

    public Object put(String name, Object o) {
        return this.param.put(name, o);
    }

    public void putAttribute(String name, String attr) {
        this.paramAttr.put(name, attr);
    }

    public Object get(Object o) {
        return this.param.get(o);
    }

    public Enumeration keys() {
        return this.param.keys();
    }

    public void putAll(Map t) {
        this.param.putAll(t);
    }

    final void addContent(Element root) {
        Element f = new Element("parameters");
        root.addContent(f);
        Enumeration e = this.param.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (ignore.containsKey(name) || name.startsWith("error ")) continue;
            Object value = this.param.get(name);
            Element g = new Element("parameter");
            f.addContent(g);
            g.setAttribute("name", name);
            g.addContent(value.toString());
        }
    }

    public void addFromElement(Element par) {
        Log log = this.router.getLog();
        if (par == null) {
            return;
        }
        Iterator it = par.getChildren().iterator();
        while (it != null && it.hasNext()) {
            Element e = (Element)it.next();
            String name = e.getAttributeValue("name");
            String type = "string";
            if (e.getAttribute("type") != null) {
                type = e.getAttributeValue("type");
            }
            String value = "";
            if (e.getAttribute("url") != null) {
                String surl = e.getAttributeValue("url");
                try {
                    String inputLine;
                    URL url = new URL(surl);
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                    while ((inputLine = in.readLine()) != null) {
                        value = value + inputLine + "\n";
                    }
                    in.close();
                }
                catch (Exception ex2) {
                    log.error("Unable to open url: " + surl, ex2);
                }
            } else {
                value = e.getAttribute("value") != null ? e.getAttributeValue("value") : e.getText().trim();
            }
            if (type.equalsIgnoreCase("string")) {
                this.put(name, new String(value));
            } else if (type.equalsIgnoreCase("int")) {
                this.put(name, new Integer(value));
            } else if (type.equalsIgnoreCase("second")) {
                int i = Integer.parseInt(value) * 1000;
                this.put(name, new Integer(i));
            } else if (type.equalsIgnoreCase("minute")) {
                int i = Integer.parseInt(value) * 1000 * 60;
                this.put(name, new Integer(i));
            } else if (type.equalsIgnoreCase("hour")) {
                int i = Integer.parseInt(value) * 1000 * 60 * 601;
                this.put(name, new Integer(i));
            } else if (type.equalsIgnoreCase("boolean")) {
                boolean b = Boolean.getBoolean(value);
                this.put(name, new Boolean(value));
            } else {
                log.error("Error reading parameter " + name);
            }
            log.debug("Parameter:" + name + " type:" + type + " value:" + value);
        }
    }

    public String getParametricString(String sel) {
        String sret = "";
        int i = 1;
        for (int j = 0; j < sel.length(); ++j) {
            if (sel.charAt(j) == '?') {
                sret = sret + this.getString("p" + i, "");
                ++i;
                continue;
            }
            sret = sret + sel.charAt(j);
        }
        return sret;
    }

    public final void remove(String name) {
        this.param.remove(name);
    }

    public String getString(Object o, String def) {
        Object oo = this.get(o);
        if (oo != null) {
            return oo.toString();
        }
        return def;
    }

    public String getString(Object o) {
        return this.getString(o, "");
    }

    public void putString(String k, String v) {
        this.put(k, new String(v));
    }

    public boolean getBoolean(String o, boolean def) {
        Object oo = this.get(o);
        if (oo != null) {
            if (oo instanceof String) {
                return Boolean.valueOf((String)oo);
            }
            return (Boolean)oo;
        }
        return def;
    }

    public void putBoolean(String o, boolean b) {
        if (b) {
            this.put(o, "true");
        } else {
            this.put(o, "false");
        }
    }

    public void putInt(String s, int i) {
        this.put(s, Integer.toString(i));
    }

    public int getInt(String o) {
        return this.getInt(o, 0);
    }

    public int getInt(String o, int def) {
        Object oo = this.get(o);
        if (oo != null) {
            try {
                return Integer.parseInt((String)oo);
            }
            catch (NumberFormatException e) {
                this.putInt(o, def);
            }
        }
        return def;
    }

    public String getAsHTMLString(String name) {
        String s = this.get(name).toString();
        String sret = "";
        block7: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '<': {
                    sret = sret + "&lt;";
                    continue block7;
                }
                case '>': {
                    sret = sret + "&gt;";
                    continue block7;
                }
                case '\n': {
                    sret = sret + "<br/>\n";
                    continue block7;
                }
                case '\r': {
                    sret = sret + "<br/>\n";
                    continue block7;
                }
                case '\t': 
                case ' ': {
                    sret = sret + "&nbsp;";
                    continue block7;
                }
                default: {
                    sret = sret + s.charAt(i);
                }
            }
        }
        sret = sret + "&nbsp;";
        if (name.indexOf("error") > -1) {
            sret = "<font color='#FF0000'><b>" + sret + "</b></font>";
        }
        return sret;
    }

    public String report() {
        String s = "";
        boolean first = true;
        Enumeration e = this.param.keys();
        while (e.hasMoreElements()) {
            if (!first) {
                s = s + "\n";
            }
            String name = (String)e.nextElement();
            String value = this.get(name).toString();
            s = s + Parameters.paddr("   " + name + ": ", 20);
            s = (value = value.replace('\n', ' ').replace('\r', ' ').trim()).length() > 50 ? s + value.substring(0, 50) + "..." : s + value;
            first = false;
        }
        return s;
    }

    static String paddl(String s, int len) {
        for (int i = s.length(); i < len; ++i) {
            s = ' ' + s;
        }
        return s;
    }

    static String paddr(String s, int len) {
        for (int i = s.length(); i < len; ++i) {
            s = s + ' ';
        }
        return s;
    }

    static {
        ignore.put("last write", null);
        ignore.put("total written", null);
        ignore.put("read", null);
        ignore.put("manual read", null);
        ignore.put("kicked", null);
        ignore.put("last read", null);
        ignore.put("last write", null);
        ignore.put("total writter", null);
        ignore.put("docs processed", null);
        ignore.put("docs written", null);
        ignore.put("elapsed time", null);
        ignore.put("started", null);
    }
}

