/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import com.ibm.bsf.BSFManager;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Parameters;
import net.gopro.gdr.Router;
import net.gopro.gdr.Version;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;

public abstract class IO {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/IO.java 1     23.06.03 15:18 Kbg $";
    protected Parameters parameters = new Parameters(null);
    protected Router router = null;
    protected String name;
    protected String type;
    private Object object = null;
    private String lastDumpFile = null;
    private Transformer transformer = null;
    private static Hashtable hKnownIOs = new Hashtable();
    private Hashtable hKnownParameters;
    private static Object[][] paramInfo = new Object[][]{{"code", Boolean.TRUE, "default empty, optional, script code executed after the document has been read from the source when reading and before writing to the source when writing"}, {"codetype", Boolean.FALSE, "default javascript, optional, determines the type of code used.  Possible values are: <ul><li><code>javascript</code> for Rhino javascript<li><code>netrexx</code> for NetREXX<li><code>jacl</code> for Jacl<li><code>jpython</code> for JPython<li><code>vbscript</code> for VBScript.  Note: Win32 only<li><code>jscript</code> for JScript.  Note: Win32 only<li><code>perlscript</code> for ActivePerl.  Note: Win32 only</ul>The scripting mechanism uses <a href=\\\"http://www.alphaWorks.ibm.com/tech/bsf\\\">BSF</a>.  Please refer to the <a href=\\\"http://www.alphaWorks.ibm.com/tech/bsf\\\">BSF</a>documentation for further information about how to use it."}, {"xslt", Boolean.FALSE, "default empty, optional, XSLT transformation applied to the document after it has been read from the source when reading and before writing to the source when writing"}};

    public void setError(String sError, String sMsg) {
        String name = "error " + sError;
        Parameter p = new Parameter(name, sMsg);
        p.setReadOnly(true);
        this.parameters.put(name, p);
    }

    public void setError(String sError, Exception e) {
        this.setError(sError, e.getClass().getName() + ": " + e.getMessage());
    }

    public final Router getRouter() {
        return this.router;
    }

    public static Hashtable getKnownIOs() {
        return hKnownIOs;
    }

    public Hashtable getKnownParameters() {
        this.hKnownParameters = new Hashtable();
        for (int i = 0; i < paramInfo.length; ++i) {
            String name = (String)paramInfo[i][0];
            boolean bCDATA = (Boolean)paramInfo[i][1];
            Parameter p = new Parameter(name, null);
            p.setCDATA(bCDATA);
            p.setDescription((String)paramInfo[i][2]);
            this.hKnownParameters.put(name, p);
        }
        return this.hKnownParameters;
    }

    public static String getDescription() {
        return "IO";
    }

    public static String getDocumentDesc() {
        return "";
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String s) {
        this.name = s;
    }

    public static Document makeXMLDocument(IO io) {
        Date d = new Date();
        if (io == null) {
            return IO.makeXMLDocument("", "", "");
        }
        String desc = io.getType() + " document created by " + io.getName() + " on " + d.toString();
        return IO.makeXMLDocument(desc, io.getType(), io.getName());
    }

    public static String getRouterVersion() {
        return Version.name() + ", " + Version.version() + " of " + Version.date();
    }

    protected static String htmlSpace(int sp) {
        String s = "";
        for (int i = 0; i < sp; ++i) {
            s = s + "&nbsp;";
        }
        return s;
    }

    protected static String htmlTag(String s) {
        return "&lt;" + s + "&gt;";
    }

    public static Document makeXMLDocument(String desc, String type, String name) {
        Date d = new Date();
        Element root = new Element("document");
        root.setAttribute("date", d.toString());
        String version = IO.getRouterVersion();
        root.setAttribute("io-type", type);
        root.setAttribute("io-name", name);
        root.setAttribute("router-version", version);
        root.setAttribute("description", desc);
        root.setAttribute("round", "0");
        return new Document(root);
    }

    public static XMLOutputter makeXMLOutputter(IO io) {
        return IO.makeXMLOutputter(io.getParameters());
    }

    public static XMLOutputter makeXMLOutputter(Parameters p) {
        XMLOutputter xo = new XMLOutputter();
        String s = p.getString("xmlencoding", "ISO-8859-1");
        xo.setEncoding(s);
        boolean b = p.getBoolean("xmlexpandemptyelements", false);
        xo.setExpandEmptyElements(b);
        b = p.getBoolean("xmlindent", true);
        xo.setIndent(b);
        int i = p.getInt("xmlindentsize", 3);
        xo.setIndentSize(i);
        b = p.getBoolean("xmlnewlines", true);
        xo.setNewlines(b);
        b = p.getBoolean("xmlomitdeclaration", false);
        xo.setOmitDeclaration(b);
        b = p.getBoolean("xmlomitencoding", false);
        xo.setOmitEncoding(b);
        b = p.getBoolean("xmltextnormalize", false);
        xo.setTextNormalize(b);
        return xo;
    }

    public void setDumpFile(String s) {
        this.lastDumpFile = s;
        this.parameters.put("lastdumpfile", s, "MX");
    }

    public String getDumpFile() {
        return this.lastDumpFile;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public abstract String getType();

    public void init() {
        try {
            String s = this.parameters.getString("xslt");
            if (s != "") {
                this.transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(s)));
            }
        }
        catch (Exception e) {
            this.setError("initializing XSLT", e);
            this.router.getLog().error(e);
        }
    }

    public void term() {
    }

    public void initThread() {
    }

    public void termThread() {
    }

    public boolean isObjectNull() {
        return this.object == null;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object o) {
        this.object = o;
    }

    public void initFromElement(Element element) {
        if (element.getAttribute("name") != null) {
            this.setName(element.getAttributeValue("name"));
        }
        this.parameters.addFromElement(element.getChild("parameters"));
    }

    public final void setRouter(Router router) {
        this.router = router;
        this.parameters.setRouter(router);
    }

    Document execute(Document d, boolean bxslt) {
        Element root = d.getRootElement();
        String code = this.parameters.getString("code");
        if (code != "") {
            Element name = d.getRootElement().getChild("name");
            String docname = "unknown";
            if (name != null) {
                docname = name.getText();
            }
            this.router.getLog().debug(this.getType() + " " + this.parameters.getString("description") + " executing code on document '" + docname + "'");
            BSFManager manager = new BSFManager();
            String codetype = this.parameters.getString("codetype", "javascript");
            try {
                manager.declareBean("thedoc", (Object)d, d.getClass());
                manager.declareBean("theio", (Object)this, this.getClass());
                manager.exec(codetype, this.getType() + "." + this.getName() + " code", 0, 0, (Object)code);
            }
            catch (Exception e) {
                this.router.getLog().error("ERROR in code.  Execution will be skipped", e);
                this.setError("in code", e);
            }
        } else {
            this.router.getLog().debug("found no code");
        }
        if (bxslt && this.parameters.getString("xslt") != "") {
            d = this.processXSLT(d);
        }
        return d;
    }

    public void readLastDumpFileIntoStream(OutputStream out) {
        try {
            Document doc;
            if (this.lastDumpFile != null) {
                try {
                    SAXBuilder builder = new SAXBuilder();
                    doc = builder.build(new File(this.lastDumpFile));
                }
                catch (Exception e) {
                    PrintWriter p = new PrintWriter(out);
                    p.println("<html>Error loading " + this.lastDumpFile);
                    p.println("<br>Error: " + e.toString() + "</html>");
                    this.setError("building last dump file", e);
                    this.router.getLog().error(e);
                    return;
                }
            } else {
                PrintWriter p = new PrintWriter(out);
                p.println("<html>");
                p.println("There is no dump file for " + this.getType() + "." + this.getName());
                p.println("</html>");
                return;
            }
            XMLOutputter xmlout = new XMLOutputter();
            xmlout.output(doc, out);
        }
        catch (Exception e) {
            this.setError("reading last dump file", e);
            this.router.getLog().error(e);
        }
    }

    public Document processXSLT(Document doc) {
        try {
            if (this.transformer == null) {
                String msg = this.getType() + "." + this.getName();
                msg = msg + ":Trying to transform via XSLT but the XSL transformer is NULL. ";
                msg = msg + "Could there be some errors in the XSL document?";
                this.setError("applying XSLT", msg);
                this.router.getLog().error(msg);
                return doc;
            }
            JDOMResult out = new JDOMResult();
            this.transformer.transform((Source)new JDOMSource(doc), (Result)out);
            return out.getDocument();
        }
        catch (Exception e) {
            this.setError("applying XSLT", e);
            this.router.getLog().error(e);
            return doc;
        }
    }

    public static String reportIO(Iterator i) {
        String s = "";
        boolean first = true;
        while (i.hasNext()) {
            IO r = (IO)i.next();
            String ioname = r.getName();
            if (ioname.equals("")) {
                ioname = "<no name>";
            }
            if (!first) {
                s = s + "\n";
            }
            s = s + "\n" + r.getType() + "." + ioname + ":\n";
            s = s + r.getParameters().report();
            if (!first) continue;
            first = false;
        }
        return s;
    }
}

